/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.Vp8PayloadType;
import org.jitsi.nlj.format.Vp9PayloadType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.GenericAdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.vp8.VP8AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.vp9.Vp9AdaptiveSourceProjectionContext;
import org.json.simple.JSONObject;

public class AdaptiveSourceProjection {
    private final Logger logger;
    private final Logger parentLogger;
    private final long targetSsrc;
    private final DiagnosticContext diagnosticContext;
    private AdaptiveSourceProjectionContext context;
    private int contextPayloadType = -1;
    private int targetIndex = -1;
    private final Map<Byte, PayloadType> payloadTypes;
    private final Runnable keyframeRequester;

    public AdaptiveSourceProjection(@NotNull DiagnosticContext diagnosticContext, @NotNull MediaSourceDesc source, Runnable keyframeRequester, Map<Byte, PayloadType> payloadTypes, Logger parentLogger) {
        this.targetSsrc = source.getPrimarySSRC();
        this.diagnosticContext = diagnosticContext;
        this.payloadTypes = payloadTypes;
        this.parentLogger = parentLogger;
        this.logger = parentLogger.createChildLogger(AdaptiveSourceProjection.class.getName(), Map.of("targetSsrc", Long.toString(this.targetSsrc), "srcEpId", Objects.toString(source.getOwner(), "")));
        this.keyframeRequester = keyframeRequester;
    }

    public void setTargetIndex(int value2) {
        this.targetIndex = value2;
    }

    public boolean accept(@NotNull PacketInfo packetInfo) {
        VideoRtpPacket videoRtpPacket = (VideoRtpPacket)packetInfo.packetAs();
        AdaptiveSourceProjectionContext contextCopy = this.getContext(videoRtpPacket);
        if (contextCopy == null) {
            return false;
        }
        if (videoRtpPacket.getQualityIndex() < 0) {
            this.logger.warn("Dropping an RTP packet, because egress was unable to find an associated layer/encoding. rtpPacket=" + String.valueOf(videoRtpPacket));
            return false;
        }
        int targetIndexCopy = this.targetIndex;
        boolean accept = contextCopy.accept(packetInfo, videoRtpPacket.getQualityIndex(), targetIndexCopy);
        if (contextCopy.needsKeyframe() && targetIndexCopy > -1) {
            this.keyframeRequester.run();
        }
        return accept;
    }

    private AdaptiveSourceProjectionContext getContext(@NotNull VideoRtpPacket rtpPacket) {
        PayloadType payloadTypeObject;
        int payloadType = rtpPacket.getPayloadType();
        if (this.context == null || this.contextPayloadType != payloadType) {
            payloadTypeObject = this.payloadTypes.get((byte)payloadType);
            if (payloadTypeObject == null) {
                this.logger.error("No payload type object signalled for payload type " + payloadType + " yet, cannot create source projection context");
                return null;
            }
        } else {
            payloadTypeObject = this.context.getPayloadType();
        }
        if (payloadTypeObject instanceof Vp8PayloadType) {
            boolean projectable;
            boolean bl = projectable = rtpPacket instanceof Vp8Packet && ((Vp8Packet)rtpPacket).getHasTemporalLayerIndex() && ((Vp8Packet)rtpPacket).getHasPictureId();
            if (projectable && !(this.context instanceof VP8AdaptiveSourceProjectionContext)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " VP8 context for payload type " + payloadType + ", source packet ssrc " + rtpPacket.getSsrc());
                this.context = new VP8AdaptiveSourceProjectionContext(this.diagnosticContext, payloadTypeObject, rtpState, this.parentLogger);
                this.contextPayloadType = payloadType;
            } else if (!projectable && !(this.context instanceof GenericAdaptiveSourceProjectionContext)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> {
                    boolean hasTemporalLayer = rtpPacket instanceof Vp8Packet && ((Vp8Packet)rtpPacket).getHasTemporalLayerIndex();
                    boolean hasPictureId = rtpPacket instanceof Vp8Packet && ((Vp8Packet)rtpPacket).getHasPictureId();
                    return "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " generic context for non-scalable VP8 payload type " + payloadType + " (packet is " + rtpPacket.getClass().getSimpleName() + ", ssrc " + rtpPacket.getSsrc() + ", hasTL=" + hasTemporalLayer + ", hasPID=" + hasPictureId + ")";
                });
                this.context = new GenericAdaptiveSourceProjectionContext(payloadTypeObject, rtpState, this.parentLogger);
                this.contextPayloadType = payloadType;
            }
            return this.context;
        }
        if (payloadTypeObject instanceof Vp9PayloadType) {
            if (!(this.context instanceof Vp9AdaptiveSourceProjectionContext)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " VP9 context for payload type " + payloadType + ", source packet ssrc " + rtpPacket.getSsrc());
                this.context = new Vp9AdaptiveSourceProjectionContext(this.diagnosticContext, payloadTypeObject, rtpState, this.parentLogger);
                this.contextPayloadType = payloadType;
            }
            return this.context;
        }
        if (this.context == null || this.contextPayloadType != payloadType) {
            RtpState rtpState = this.getRtpState();
            this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " generic context for payload type " + payloadType);
            this.context = new GenericAdaptiveSourceProjectionContext(payloadTypeObject, rtpState, this.parentLogger);
            this.contextPayloadType = payloadType;
            return this.context;
        }
        return this.context;
    }

    @NotNull
    private RtpState getRtpState() {
        if (this.context == null) {
            return new RtpState(this.targetSsrc, 1, 1L);
        }
        return this.context.getRtpState();
    }

    public void rewriteRtp(@NotNull PacketInfo packetInfo) throws RewriteException {
        AdaptiveSourceProjectionContext contextCopy = this.context;
        if (contextCopy != null) {
            contextCopy.rewriteRtp(packetInfo);
        }
    }

    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        AdaptiveSourceProjectionContext contextCopy = this.context;
        if (contextCopy == null) {
            return true;
        }
        return contextCopy.rewriteRtcp(rtcpSrPacket);
    }

    public long getTargetSsrc() {
        return this.targetSsrc;
    }

    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put("targetSsrc", this.targetSsrc);
        AdaptiveSourceProjectionContext contextCopy = this.context;
        debugState.put("context", contextCopy == null ? null : contextCopy.getDebugState());
        debugState.put("contextPayloadType", this.contextPayloadType);
        debugState.put("targetIndex", this.targetIndex);
        return debugState;
    }
}

