/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002)*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013J\u001a\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$J*\u0010%\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010&\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/utils/logging2/Logger;)V", "currentIndex", "", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "internalTargetEncoding", "internalTargetSpatialId", "layers", "", "", "[Ljava/lang/Boolean;", "logger", "mostRecentKeyframeGroupArrivalTime", "Ljava/time/Instant;", "<set-?>", "needsKeyframe", "getNeedsKeyframe", "()Z", "acceptFrame", "Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter$AcceptResult;", "frame", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "incomingIndex", "externalTargetIndex", "receivedTime", "acceptKeyframe", "addDiagnosticContext", "", "pt", "Lorg/jitsi/utils/logging/DiagnosticContext$TimeSeriesPoint;", "addDiagnosticContext$jitsi_videobridge", "doAcceptFrame", "isOutOfSwitchingPhase", "isPossibleToSwitch", "incomingEncoding", "AcceptResult", "Companion", "jitsi-videobridge"})
public final class Vp9QualityFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @Nullable
    private Instant mostRecentKeyframeGroupArrivalTime;
    private boolean needsKeyframe;
    private int internalTargetEncoding;
    private int internalTargetSpatialId;
    private int currentIndex;
    @NotNull
    private final Boolean[] layers;
    private static final Duration MIN_KEY_FRAME_WAIT = Duration.ofMillis(300L);
    private static final int MAX_VP9_LAYERS = 8;

    public Vp9QualityFilter(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.internalTargetEncoding = -1;
        this.internalTargetSpatialId = -1;
        this.currentIndex = -1;
        int n = 0;
        Boolean[] booleanArray = new Boolean[8];
        Vp9QualityFilter vp9QualityFilter = this;
        while (n < 8) {
            int n2 = n++;
            booleanArray[n2] = false;
        }
        vp9QualityFilter.layers = booleanArray;
    }

    public final boolean getNeedsKeyframe() {
        return this.needsKeyframe;
    }

    @NotNull
    public final synchronized AcceptResult acceptFrame(@NotNull Vp9Frame frame, int incomingIndex, int externalTargetIndex, @Nullable Instant receivedTime) {
        boolean isResumption;
        Intrinsics.checkNotNullParameter(frame, "frame");
        int prevIndex = this.currentIndex;
        boolean accept = this.doAcceptFrame(frame, incomingIndex, externalTargetIndex, receivedTime);
        boolean mark = frame.isInterPicturePredicted() ? RtpLayerDesc.Companion.getSidFromIndex(incomingIndex) == RtpLayerDesc.Companion.getSidFromIndex(this.currentIndex) : RtpLayerDesc.Companion.getSidFromIndex(incomingIndex) == RtpLayerDesc.Companion.getSidFromIndex(externalTargetIndex);
        boolean bl = isResumption = prevIndex == -1 && this.currentIndex != -1;
        if (isResumption && _Assertions.ENABLED && !accept) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new AcceptResult(accept, isResumption, mark);
    }

    private final boolean doAcceptFrame(Vp9Frame frame, int incomingIndex, int externalTargetIndex, Instant receivedTime) {
        boolean bl;
        int externalTargetEncoding = RtpLayerDesc.Companion.getEidFromIndex(externalTargetIndex);
        int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
        if (externalTargetEncoding != this.internalTargetEncoding) {
            this.internalTargetEncoding = externalTargetEncoding;
            if (externalTargetEncoding != -1 && externalTargetEncoding != currentEncoding) {
                this.needsKeyframe = true;
            }
        }
        if (externalTargetEncoding == -1) {
            this.currentIndex = -1;
            return false;
        }
        int temporalLayerIdOfFrame = RangesKt.coerceAtLeast(frame.getTemporalLayer(), 0);
        int incomingEncoding = RtpLayerDesc.Companion.getEidFromIndex(incomingIndex);
        if (frame.isKeyframe()) {
            this.logger.debug(() -> Vp9QualityFilter.doAcceptFrame$lambda-0(frame));
            boolean accept = this.acceptKeyframe(incomingIndex, receivedTime);
            if (accept) {
                int n = this.layers.length;
                for (int i = 0; i < n; ++i) {
                    this.layers[i] = i == 0;
                }
            }
            bl = accept;
        } else if (currentEncoding != -1) {
            boolean accept;
            boolean wantToForwardLayer;
            boolean wantToSwitch;
            if (this.isOutOfSwitchingPhase(receivedTime) && this.isPossibleToSwitch(incomingEncoding)) {
                this.needsKeyframe = true;
            }
            if (incomingEncoding != currentEncoding) {
                return false;
            }
            int spatialLayerOfFrame = RtpLayerDesc.Companion.getSidFromIndex(incomingIndex);
            Ref.IntRef externalTargetSpatialId = new Ref.IntRef();
            externalTargetSpatialId.element = RtpLayerDesc.Companion.getSidFromIndex(externalTargetIndex);
            Ref.IntRef currentSpatialLayer = new Ref.IntRef();
            currentSpatialLayer.element = RtpLayerDesc.Companion.getSidFromIndex(this.currentIndex);
            if (frame.getNumSpatialLayers() != -1 && externalTargetSpatialId.element >= frame.getNumSpatialLayers()) {
                externalTargetSpatialId.element = frame.getNumSpatialLayers() - 1;
            }
            boolean canForwardLayer = !(frame.isInterPicturePredicted() && this.layers[spatialLayerOfFrame] == false || frame.getUsesInterLayerDependency() && this.layers[spatialLayerOfFrame - 1] == false);
            boolean bl2 = wantToSwitch = spatialLayerOfFrame > currentSpatialLayer.element && spatialLayerOfFrame <= externalTargetSpatialId.element || spatialLayerOfFrame < currentSpatialLayer.element && spatialLayerOfFrame >= externalTargetSpatialId.element || frame.getNumSpatialLayers() != -1 && currentSpatialLayer.element >= frame.getNumSpatialLayers();
            if (wantToSwitch) {
                if (canForwardLayer) {
                    this.logger.debug(() -> Vp9QualityFilter.doAcceptFrame$lambda-1(externalTargetSpatialId, currentSpatialLayer));
                    this.currentIndex = incomingIndex;
                    currentSpatialLayer.element = spatialLayerOfFrame;
                } else {
                    if (this.internalTargetSpatialId != externalTargetSpatialId.element) {
                        this.logger.debug(() -> Vp9QualityFilter.doAcceptFrame$lambda-2(externalTargetSpatialId, currentSpatialLayer));
                    }
                    this.needsKeyframe = true;
                }
                this.internalTargetSpatialId = externalTargetSpatialId.element;
            }
            boolean bl3 = wantToForwardLayer = spatialLayerOfFrame == currentSpatialLayer.element || spatialLayerOfFrame < currentSpatialLayer.element && frame.isUpperLevelReference();
            if (wantToForwardLayer && !canForwardLayer) {
                this.logger.warn("Want to forward " + RtpLayerDesc.Companion.indexString(this.currentIndex) + " frame, but can't! layers=" + ArraysKt.joinToString$default((Object[])this.layers, null, null, null, 0, null, null, 63, null) + ", currentIndex=" + RtpLayerDesc.Companion.indexString(this.currentIndex) + ", isInterPicturePredicted=" + frame.isInterPicturePredicted() + ", usesInterLayerDependency=" + frame.getUsesInterLayerDependency() + ".");
            }
            boolean bl4 = accept = wantToForwardLayer && canForwardLayer;
            if (temporalLayerIdOfFrame == 0) {
                this.layers[spatialLayerOfFrame] = accept;
            }
            if (!accept) {
                return false;
            }
            if (currentEncoding > externalTargetEncoding || currentSpatialLayer.element > externalTargetSpatialId.element) {
                bl = temporalLayerIdOfFrame < 1;
            } else if (currentEncoding < externalTargetEncoding || currentSpatialLayer.element < externalTargetSpatialId.element) {
                bl = true;
            } else {
                boolean acceptTemporal;
                int externalTargetTemporalId = RtpLayerDesc.Companion.getTidFromIndex(externalTargetIndex);
                int currentTemporalLayer = RtpLayerDesc.Companion.getTidFromIndex(this.currentIndex);
                boolean bl5 = acceptTemporal = temporalLayerIdOfFrame <= externalTargetTemporalId;
                if (acceptTemporal && temporalLayerIdOfFrame > currentTemporalLayer) {
                    this.currentIndex = RtpLayerDesc.Companion.getIndex(currentEncoding, currentSpatialLayer.element, temporalLayerIdOfFrame);
                }
                bl = acceptTemporal;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final synchronized boolean isOutOfSwitchingPhase(Instant receivedTime) {
        if (receivedTime == null) {
            return false;
        }
        if (this.mostRecentKeyframeGroupArrivalTime == null) {
            return true;
        }
        Duration delta = Duration.between(this.mostRecentKeyframeGroupArrivalTime, receivedTime);
        return delta.compareTo(MIN_KEY_FRAME_WAIT) > 0;
    }

    private final synchronized boolean isPossibleToSwitch(int incomingEncoding) {
        int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
        if (incomingEncoding == -1) {
            return false;
        }
        return incomingEncoding > currentEncoding && currentEncoding < this.internalTargetEncoding ? true : incomingEncoding < currentEncoding && currentEncoding > this.internalTargetEncoding;
    }

    private final synchronized boolean acceptKeyframe(int incomingIndex, Instant receivedTime) {
        boolean bl;
        int encodingIdOfKeyframe = RtpLayerDesc.Companion.getEidFromIndex(incomingIndex);
        if (encodingIdOfKeyframe < 0) {
            this.logger.error("unable to get layer id from keyframe");
            return false;
        }
        if (RtpLayerDesc.Companion.getSidFromIndex(incomingIndex) != 0 || RtpLayerDesc.Companion.getTidFromIndex(incomingIndex) != 0) {
            this.logger.warn("Surprising index " + RtpLayerDesc.Companion.indexString(incomingIndex) + " on keyframe");
        }
        this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda-3(encodingIdOfKeyframe));
        this.needsKeyframe = false;
        if (this.isOutOfSwitchingPhase(receivedTime)) {
            this.mostRecentKeyframeGroupArrivalTime = receivedTime;
            this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda-4(encodingIdOfKeyframe, this));
            if (encodingIdOfKeyframe <= this.internalTargetEncoding) {
                int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
                if (currentEncoding != encodingIdOfKeyframe) {
                    this.currentIndex = incomingIndex;
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
            if (currentEncoding <= encodingIdOfKeyframe && encodingIdOfKeyframe <= this.internalTargetEncoding) {
                if (currentEncoding != encodingIdOfKeyframe) {
                    this.currentIndex = incomingIndex;
                }
                this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda-5(encodingIdOfKeyframe, this));
                bl = true;
            } else if (encodingIdOfKeyframe <= this.internalTargetEncoding && this.internalTargetEncoding < currentEncoding) {
                this.currentIndex = incomingIndex;
                this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda-6(encodingIdOfKeyframe, this));
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    public final void addDiagnosticContext$jitsi_videobridge(@NotNull DiagnosticContext.TimeSeriesPoint pt) {
        Intrinsics.checkNotNullParameter(pt, "pt");
        Instant instant = this.mostRecentKeyframeGroupArrivalTime;
        pt.addField("qf.currentIndex", RtpLayerDesc.Companion.indexString(this.currentIndex)).addField("qf.internalTargetEncoding", this.internalTargetEncoding).addField("qf.needsKeyframe", this.needsKeyframe).addField("qf.mostRecentKeyframeGroupArrivalTimeMs", instant != null ? instant.toEpochMilli() : -1L);
        int n = this.layers.length;
        for (int i = 0; i < n; ++i) {
            pt.addField("qf.layer." + i, this.layers[i]);
        }
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    @NotNull
    public final JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        Map map = debugState;
        String string = "mostRecentKeyframeGroupArrivalTimeMs";
        Instant instant = this.mostRecentKeyframeGroupArrivalTime;
        Long l = instant != null ? instant.toEpochMilli() : -1L;
        map.put(string, l);
        ((Map)debugState).put("needsKeyframe", this.needsKeyframe);
        ((Map)debugState).put("internalTargetIndex", this.internalTargetEncoding);
        ((Map)debugState).put("currentIndex", RtpLayerDesc.Companion.indexString(this.currentIndex));
        return debugState;
    }

    private static final String doAcceptFrame$lambda-0(Vp9Frame $frame) {
        Intrinsics.checkNotNullParameter($frame, "$frame");
        return "Quality filter got keyframe for stream " + $frame.getSsrc();
    }

    private static final String doAcceptFrame$lambda-1(Ref.IntRef $externalTargetSpatialId, Ref.IntRef $currentSpatialLayer) {
        Intrinsics.checkNotNullParameter($externalTargetSpatialId, "$externalTargetSpatialId");
        Intrinsics.checkNotNullParameter($currentSpatialLayer, "$currentSpatialLayer");
        return "Switching to spatial layer " + $externalTargetSpatialId.element + " from " + $currentSpatialLayer.element;
    }

    private static final String doAcceptFrame$lambda-2(Ref.IntRef $externalTargetSpatialId, Ref.IntRef $currentSpatialLayer) {
        Intrinsics.checkNotNullParameter($externalTargetSpatialId, "$externalTargetSpatialId");
        Intrinsics.checkNotNullParameter($currentSpatialLayer, "$currentSpatialLayer");
        return "Want to switch to spatial layer " + $externalTargetSpatialId.element + " from " + $currentSpatialLayer.element + ", requesting keyframe";
    }

    private static final String acceptKeyframe$lambda-3(int $encodingIdOfKeyframe) {
        return "Received a keyframe of encoding: " + $encodingIdOfKeyframe;
    }

    private static final String acceptKeyframe$lambda-4(int $encodingIdOfKeyframe, Vp9QualityFilter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "First keyframe in this kf group currentEncodingId: " + $encodingIdOfKeyframe + ". Target is " + this$0.internalTargetEncoding;
    }

    private static final String acceptKeyframe$lambda-5(int $encodingIdOfKeyframe, Vp9QualityFilter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Upscaling to encoding " + $encodingIdOfKeyframe + ". The target is " + this$0.internalTargetEncoding;
    }

    private static final String acceptKeyframe$lambda-6(int $encodingIdOfKeyframe, Vp9QualityFilter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Downscaling to encoding " + $encodingIdOfKeyframe + ". The target is " + this$0.internalTargetEncoding;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter$AcceptResult;", "", "accept", "", "isResumption", "mark", "(ZZZ)V", "getAccept", "()Z", "getMark", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "jitsi-videobridge"})
    public static final class AcceptResult {
        private final boolean accept;
        private final boolean isResumption;
        private final boolean mark;

        public AcceptResult(boolean accept, boolean isResumption, boolean mark) {
            this.accept = accept;
            this.isResumption = isResumption;
            this.mark = mark;
        }

        public final boolean getAccept() {
            return this.accept;
        }

        public final boolean isResumption() {
            return this.isResumption;
        }

        public final boolean getMark() {
            return this.mark;
        }

        public final boolean component1() {
            return this.accept;
        }

        public final boolean component2() {
            return this.isResumption;
        }

        public final boolean component3() {
            return this.mark;
        }

        @NotNull
        public final AcceptResult copy(boolean accept, boolean isResumption, boolean mark) {
            return new AcceptResult(accept, isResumption, mark);
        }

        public static /* synthetic */ AcceptResult copy$default(AcceptResult acceptResult, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = acceptResult.accept;
            }
            if ((n & 2) != 0) {
                bl2 = acceptResult.isResumption;
            }
            if ((n & 4) != 0) {
                bl3 = acceptResult.mark;
            }
            return acceptResult.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "AcceptResult(accept=" + this.accept + ", isResumption=" + this.isResumption + ", mark=" + this.mark + ")";
        }

        public int hashCode() {
            int n;
            int result2;
            int n2 = this.accept ? 1 : 0;
            if (n2 != 0) {
                n2 = result2 = 1;
            }
            if ((n = this.isResumption) != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n3 = this.mark ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result2 = result2 * 31 + n3;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AcceptResult)) {
                return false;
            }
            AcceptResult acceptResult = (AcceptResult)other;
            if (this.accept != acceptResult.accept) {
                return false;
            }
            if (this.isResumption != acceptResult.isResumption) {
                return false;
            }
            return this.mark == acceptResult.mark;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter$Companion;", "", "()V", "MAX_VP9_LAYERS", "", "MIN_KEY_FRAME_WAIT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

