/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReplicationQuotaUtils$;
import kafka.common.AdminCommandFailedException;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000ecWo\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t\u0019\u0011J\u001c;\t\r\r\u0002\u0001\u0015!\u0003\u001d\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011\u001d)\u0003\u00011A\u0005\u0002\u0019\nqa]3sm\u0016\u00148/F\u0001(!\rA3&L\u0007\u0002S)\u0011!FH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0017*\u0005\r\u0019V-\u001d\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\t1\u0014\b\u0005\u0002\u001eo%\u0011\u0001H\b\u0002\u0005+:LG\u000fC\u0004;g\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013\u0007\u0003\u0004=\u0001\u0001\u0006KaJ\u0001\tg\u0016\u0014h/\u001a:tA!9a\b\u0001b\u0001\n\u0003y\u0014!\u0003;pa&\u001cg*Y7f+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007'R\u0014\u0018N\\4\t\r%\u0003\u0001\u0015!\u0003A\u0003)!x\u000e]5d\u001d\u0006lW\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001\u001c\u0003\u001d!W\r\\1z\u001bNDa!\u0014\u0001!\u0002\u0013a\u0012\u0001\u00033fY\u0006LXj\u001d\u0011\t\u000f=\u0003\u0001\u0019!C\u0001!\u0006Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\u0005\t\u0006C\u0001*\\\u001b\u0005\u0019&BA\u0002U\u0015\t)f+A\u0004dY&,g\u000e^:\u000b\u0005\u00159&B\u0001-Z\u0003\u0019\t\u0007/Y2iK*\t!,A\u0002pe\u001eL!\u0001X*\u0003\u0017\u0005#W.\u001b8DY&,g\u000e\u001e\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fHC\u0001\u001ca\u0011\u001dQT,!AA\u0002ECaA\u0019\u0001!B\u0013\t\u0016\u0001D1e[&t7\t\\5f]R\u0004\u0003\"\u00023\u0001\t\u0003)\u0017!\u0004>l+B$\u0017\r^3EK2\f\u0017\u0010F\u00017\u0011\u00159\u0007\u0001\"\u0011f\u0003\u0015\u0019X\r^+qQ\t1\u0017\u000e\u0005\u0002k[6\t1N\u0003\u0002m3\u0006)!.\u001e8ji&\u0011an\u001b\u0002\u0007\u0005\u00164wN]3\t\u000bA\u0004A\u0011A9\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0005Y\u0012\b\"B:p\u0001\u0004!\u0018!\u00032s_.,'/\u00133t!\rA3\u0006\b\u0005\u0006m\u0002!\ta^\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCA)y\u0011\u0015)S\u000f1\u0001(\u0011\u0015Q\b\u0001\"\u0001|\u0003e9W\r\u001e*b]\u0012|W\u000eT8h\t&\u0014\u0018i]:jO:lWM\u001c;\u0015\u0007q\fi\u0001E\u0002~\u0003\u0013q1A`A\u0003!\tyh$\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\r\t9AH\u0001\u0007!J,G-\u001a4\n\u0007\u001d\u000bYAC\u0002\u0002\byAa!a\u0004z\u0001\u0004a\u0012\u0001\u00032s_.,'/\u00133\t\r\u0005M\u0001\u0001\"\u0011f\u0003!!X-\u0019:E_^t\u0007\u0006BA\t\u0003/\u00012A[A\r\u0013\r\tYb\u001b\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0007\u0003?\u0001A\u0011A3\u0002AQ,7\u000f\u001e%x\u0003\u001a$XM\u001d)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0005\u0003;\t\u0019\u0003E\u0002k\u0003KI1!a\nl\u0005\u0011!Vm\u001d;\t\r\u0005-\u0002\u0001\"\u0001f\u0003e\u0019\bn\\;mI6{g/Z*j]\u001edW\rU1si&$\u0018n\u001c8)\t\u0005%\u00121\u0005\u0005\u0007\u0003c\u0001A\u0011A3\u0002KMDw.\u001e7e\u001b>4XmU5oO2,\u0007+\u0019:uSRLwN\\,ji\"LgN\u0011:pW\u0016\u0014\b\u0006BA\u0018\u0003GAa!a\u000e\u0001\t\u0003)\u0017aE:i_VdG-\u0012=qC:$7\t\\;ti\u0016\u0014\b\u0006BA\u001b\u0003GAa!!\u0010\u0001\t\u0003)\u0017aE:i_VdGm\u00155sS:\\7\t\\;ti\u0016\u0014\b\u0006BA\u001e\u0003GAa!a\u0011\u0001\t\u0003)\u0017\u0001H:i_VdG-T8wKN+(m]3u\u001f\u001a\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0003\u0003\n\u0019\u0003\u0003\u0004\u0002J\u0001!\t!Z\u0001#g\"|W\u000f\u001c3Fq\u0016\u001cW\u000f^3UQJ|G\u000f\u001e7fIJ+\u0017m]:jO:lWM\u001c;)\t\u0005\u001d\u00131\u0005\u0005\u0007\u0003\u001f\u0002A\u0011A3\u0002AMDw.\u001e7e\u001f:d\u0017\u0010\u00165s_R$H.Z'pm&twMU3qY&\u001c\u0017m\u001d\u0015\u0005\u0003\u001b\n\u0019\u0003\u0003\u0004\u0002V\u0001!\t!Z\u0001-g\"|W\u000f\u001c3DQ\u0006tw-\u001a+ie>$H\u000f\\3P]J+'/\u001e8B]\u0012\u0014V-\\8wK>sg+\u001a:jMfDC!a\u0015\u0002$!1\u00111\f\u0001\u0005\u0002\u0015\f\u0001f\u001d5pk2$g)Y5m\u0013\u001a\u0004&o\u001c9pg\u0016$Gi\\3t\u001d>$X*\u0019;dQ\u0016C\u0018n\u001d;j]\u001eD\u0003\"!\u0017\u0002$\u0005}\u0013\u0011M\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u0003\u0002\r\r|W.\\8o\u0013\u0011\ti'a\u001a\u00037\u0005#W.\u001b8D_6l\u0017M\u001c3GC&dW\rZ#yG\u0016\u0004H/[8o\u0011\u0019\t\t\b\u0001C\u0001K\u000693\u000f[8vY\u00124\u0015-\u001b7JMB\u0013x\u000e]8tK\u0012D\u0015m]#naRL(+\u001a9mS\u000e\fG*[:uQ!\ty'a\t\u0002`\u0005\u0005\u0004BBA<\u0001\u0011\u0005Q-\u0001\u0014tQ>,H\u000e\u001a$bS2Le\r\u0015:pa>\u001cX\r\u001a%bg&sg/\u00197jI\n\u0013xn[3s\u0013\u0012C\u0003\"!\u001e\u0002$\u0005}\u0013\u0011\r\u0005\u0007\u0003{\u0002A\u0011A3\u0002IMDw.\u001e7e\r\u0006LG.\u00134Qe>\u0004xn]3e\u0011\u0006\u001c\u0018J\u001c<bY&$Gj\\4ESJD\u0003\"a\u001f\u0002$\u0005}\u0013\u0011\r\u0005\u0007\u0003\u0007\u0003A\u0011A3\u0002kMDw.\u001e7e\r\u0006LG.\u00134Qe>\u0004xn]3e\u0011\u0006\u001c\u0018J\\2p]NL7\u000f^3oiJ+\u0007\u000f\\5dCN\fe\u000e\u001a'pO\u0012K'o\u001d\u0015\t\u0003\u0003\u000b\u0019#a\u0018\u0002b!1\u0011\u0011\u0012\u0001\u0005\u0002\u0015\f1g\u001d5pk2$\u0007+\u001a:g_JlG\u000b\u001b:piRdW\r\u001a*fCN\u001c\u0018n\u001a8nK:$xJ^3s-\u0006\u0014\u0018n\\;t)>\u0004\u0018nY:)\t\u0005\u001d\u00151\u0005\u0005\u0007\u0003\u001f\u0003A\u0011A3\u0002yMDw.\u001e7e!\u0016\u0014hm\u001c:n\u001bVdG/\u001b9mKJ+\u0017m]:jO:lWM\u001c;Pa\u0016\u0014\u0018\r^5p]N|e/\u001a:WCJLw.^:U_BL7m\u001d\u0015\u0005\u0003\u001b\u000b\u0019\u0003\u0003\u0004\u0002\u0016\u0002!\t!Z\u0001-g\"|W\u000f\u001c3Ue&<w-\u001a:SK\u0006\u001c8/[4o[\u0016tGo\u00148D_:$(o\u001c7mKJ\u001cF/\u0019:ukBDC!a%\u0002$!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015!H<bSR4uN\u001d*fCN\u001c\u0018n\u001a8nK:$Hk\\\"p[BdW\r^3\u0015\u0007Y\ny\n\u0003\u0006\u0002\"\u0006e\u0005\u0013!a\u0001\u0003G\u000bQ\u0001]1vg\u0016\u00042!HAS\u0013\r\t9K\b\u0002\u0005\u0019>tw\rC\u0004\u0002,\u0002!\t!!,\u0002\t)\u001cxN\u001c\u000b\u0004y\u0006=\u0006\u0002CAY\u0003S\u0003\r!a-\u0002\u000bQ|\u0007/[2\u0011\tu\t)\f`\u0005\u0004\u0003os\"A\u0003\u001fsKB,\u0017\r^3e}!I\u00111\u0018\u0001\u0012\u0002\u0013\u0005\u0011QX\u0001(o\u0006LGOR8s%\u0016\f7o]5h]6,g\u000e\u001e+p\u0007>l\u0007\u000f\\3uK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002@*\"\u00111UAaW\t\t\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\u0013Ut7\r[3dW\u0016$'bAAg=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0017q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReassignPartitionsClusterTest
extends ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers = null;
    private final String topicName;
    private final int delayMs;
    private AdminClient adminClient = null;

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public AdminClient adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    public void zkUpdateDelay() {
        Thread.sleep(this.delayMs());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    public void startBrokers(Seq<Object> brokerIds) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> ReassignPartitionsClusterTest.$anonfun$startBrokers$1(this, BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    public AdminClient createAdminClient(Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(servers, TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        props.put("request.timeout.ms", "10000");
        return AdminClient.create((Properties)props);
    }

    public String getRandomLogDirAssignment(int brokerId) {
        KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$getRandomLogDirAssignment$1(brokerId, x$1))).get();
        Seq logDirs = server.config().logDirs();
        return new File((String)logDirs.apply(Random$.MODULE$.nextInt(logDirs.size()))).getAbsolutePath();
    }

    @Override
    @After
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
            this.adminClient_$eq(null);
        }
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHwAfterPartitionReassignment() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$testHwAfterPartitionReassignment$1(x$2))).get();
        leaderServer.replicaManager().logManager().truncateFullyAndStartAt(topicPartition, 100L, false);
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101, 102]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        KafkaServer newLeaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$testHwAfterPartitionReassignment$2(x$3))).get();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$25 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> newLeaderServer.replicaManager().getPartition(topicPartition).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.leaderReplicaIfLocal()).isDefined();
        Function0 & Serializable & scala.Serializable x$26 = (Function0 & Serializable & scala.Serializable)() -> "broker 101 should be the new leader";
        long x$27 = 1L;
        long x$28 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$25, (Function0<String>)x$26, x$28, x$27);
        Assert.assertEquals((long)100L, (long)newLeaderServer.replicaManager().getReplicaOrException(topicPartition).highWatermark().messageOffset());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> server.replicaManager().getReplicaOrException(topicPartition$1).highWatermark().messageOffset() == 100L, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldMoveSinglePartition() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        int partition = 0;
        String expectedLogDir = this.getRandomLogDirAssignment(101);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"", "\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName(), expectedLogDir}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})), (Object)((MapLike)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).get((Object)this.topicName()).get()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        TopicPartitionReplica replica = new TopicPartitionReplica(this.topicName(), 0, 101);
        Assert.assertEquals((Object)expectedLogDir, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica)).all().get()).get(replica)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldMoveSinglePartitionWithinBroker() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String expectedLogDir = this.getRandomLogDirAssignment(100);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[100],\"log_dirs\":[\"", "\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName(), expectedLogDir}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        TopicPartitionReplica replica = new TopicPartitionReplica(this.topicName(), 0, 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = expectedLogDir;
            String string2 = ((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica)).all().get()).get(replica)).getCurrentReplicaLogDir();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition should have been moved to the expected log directory", 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void shouldExpandCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(brokers), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        int partition1 = ((TopicPartition)((Tuple2)newAssignment.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$shouldExpandCluster$1(x0$1))).get())._1()).partition();
        TopicPartitionReplica replica1 = new TopicPartitionReplica(this.topicName(), partition1, 102);
        String expectedLogDir1 = this.getRandomLogDirAssignment(102);
        int partition2 = ((TopicPartition)((Tuple2)newAssignment.find((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$shouldExpandCluster$2(x0$2))).get())._1()).partition();
        TopicPartitionReplica replica2 = new TopicPartitionReplica(this.topicName(), partition2, 100);
        String expectedLogDir2 = this.getRandomLogDirAssignment(100);
        Map newReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica1), (Object)expectedLogDir1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica2), (Object)expectedLogDir2)}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, newReplicaAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = expectedLogDir1;
            String string2 = ((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica1)).all().get()).get(replica1)).getCurrentReplicaLogDir();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition should have been moved to the expected log directory on broker 102", 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = expectedLogDir2;
            String string2 = ((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica2)).all().get()).get(replica2)).getCurrentReplicaLogDir();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition should have been moved to the expected log directory on broker 100", 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void shouldShrinkCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test
    public void shouldMoveSubsetOfPartitions() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map proposed = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})))}));
        TopicPartitionReplica replica1 = new TopicPartitionReplica("topic1", 0, 102);
        TopicPartitionReplica replica2 = new TopicPartitionReplica("topic2", 1, 100);
        Map proposedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica1), (Object)this.getRandomLogDirAssignment(102)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica2), (Object)this.getRandomLogDirAssignment(100))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(proposed, proposedReplicaAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        scala.collection.immutable.Map actual = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "topic2"})));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        java.util.Map replicaDirs = (java.util.Map)this.adminClient().describeReplicaLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{replica1, replica2}))).asJava()).all().get();
        Assert.assertEquals((Object)proposedReplicaAssignment.apply((Object)replica1), (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirs.get(replica1)).getCurrentReplicaLogDir());
        Assert.assertEquals((Object)proposedReplicaAssignment.apply((Object)replica2), (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirs.get(replica2)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldExecuteThrottledReassignment() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        ReassignPartitionsCommand.Throttle initialThrottle = new ReassignPartitionsCommand.Throttle(10000000L, -1L, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUpdateDelay());
        int expectedDurationSecs = 5;
        int numMessages = 500;
        int msgSize = 100000;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), numMessages, 0, msgSize);
        Assert.assertEquals((long)expectedDurationSecs, (long)((long)(numMessages * msgSize) / initialThrottle.interBrokerLimit()));
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        long start = System.currentTimeMillis();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), initialThrottle, ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), initialThrottle.interBrokerLimit(), this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        long took = System.currentTimeMillis() - start - (long)this.delayMs();
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be > ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)expectedDurationSecs * 0.9 * (double)1000)), BoxesRunTime.boxToLong((long)took)})), ((double)took > (double)expectedDurationSecs * 0.9 * (double)1000 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be < ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(expectedDurationSecs * 2 * 1000)), BoxesRunTime.boxToLong((long)took)})), (took < (long)(expectedDurationSecs * 2 * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void shouldOnlyThrottleMovingReplicas() {
        int[] brokers = new int[]{100, 101, 102, 103, 104, 105};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        long throttle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic1", 100, 0, 100000);
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic2", 100, 0, 100000);
        Map newAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(throttle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), throttle, this.servers(), "topic1", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:100", "1:101", "0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:102", "0:102"}))));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), throttle, this.servers(), "topic2", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:104", "1:105", "0:104", "0:105"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:103", "0:103"}))));
    }

    @Test
    public void shouldChangeThrottleOnRerunAndRemoveOnVerify() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        long initialThrottle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), 200, 0, 100000);
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(initialThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), initialThrottle, this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), initialThrottle, this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        long newThrottle = initialThrottle * 1000L;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(newThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), newThrottle, this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigRemovedFromZK(this.adminZkClient(), this.topicName(), this.servers());
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedDoesNotMatchExisting() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":1,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasEmptyReplicaList() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidBrokerID() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101, 102]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidLogDir() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"invalidDir\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInconsistentReplicasAndLogDirs() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String logDir = this.getRandomLogDirAssignment(100);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"", "\", \"", "\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName(), logDir, logDir}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test
    public void shouldPerformThrottledReassignmentOverVariousTopics() {
        ReassignPartitionsCommand.Throttle throttle = new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3());
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "payments", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "deliveries", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "customers", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), this.servers());
        Map move = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        KafkaZkClient x$29 = this.zkClient();
        None$ x$30 = None$.MODULE$;
        Map x$31 = move;
        AdminZkClient x$32 = this.adminZkClient();
        Map x$33 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$1 = new ReassignPartitionsCommand(x$29, (Option)x$30, x$31, x$33, x$32);
        ReassignPartitionsCommand.Throttle x$34 = throttle;
        long x$35 = qual$1.reassignPartitions$default$2();
        qual$1.reassignPartitions(x$34, x$35);
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
    }

    @Test
    public void shouldPerformMultipleReassignmentOperationsOverVariousTopics() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "payments", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "deliveries", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "customers", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), this.servers());
        Map firstMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        KafkaZkClient x$36 = this.zkClient();
        None$ x$37 = None$.MODULE$;
        Map x$38 = firstMove;
        AdminZkClient x$39 = this.adminZkClient();
        Map x$40 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$2 = new ReassignPartitionsCommand(x$36, (Option)x$37, x$38, x$40, x$39);
        ReassignPartitionsCommand.Throttle x$41 = qual$2.reassignPartitions$default$1();
        long x$42 = qual$2.reassignPartitions$default$2();
        qual$2.reassignPartitions(x$41, x$42);
        this.waitForReassignmentToComplete(1L);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
        Map secondMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        KafkaZkClient x$43 = this.zkClient();
        None$ x$44 = None$.MODULE$;
        Map x$45 = secondMove;
        AdminZkClient x$46 = this.adminZkClient();
        Map x$47 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$3 = new ReassignPartitionsCommand(x$43, (Option)x$44, x$45, x$47, x$46);
        ReassignPartitionsCommand.Throttle x$48 = qual$3.reassignPartitions$default$1();
        long x$49 = qual$3.reassignPartitions$default$2();
        qual$3.reassignPartitions(x$48, x$49);
        this.waitForReassignmentToComplete(1L);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
        Map thirdMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        KafkaZkClient x$50 = this.zkClient();
        None$ x$51 = None$.MODULE$;
        Map x$52 = thirdMove;
        AdminZkClient x$53 = this.adminZkClient();
        Map x$54 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$4 = new ReassignPartitionsCommand(x$50, (Option)x$51, x$52, x$54, x$53);
        ReassignPartitionsCommand.Throttle x$55 = qual$4.reassignPartitions$default$1();
        long x$56 = qual$4.reassignPartitions$default$2();
        qual$4.reassignPartitions(x$55, x$56);
        Map fourthMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))}));
        package$.MODULE$.Iterator().continually((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try {
                KafkaZkClient x$57 = this.zkClient();
                None$ x$58 = None$.MODULE$;
                Map x$59 = fourthMove;
                AdminZkClient x$60 = this.adminZkClient();
                Map x$61 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
                ReassignPartitionsCommand qual$5 = new ReassignPartitionsCommand(x$57, (Option)x$58, x$59, x$61, x$60);
                ReassignPartitionsCommand.Throttle x$62 = qual$5.reassignPartitions$default$1();
                long x$63 = qual$5.reassignPartitions$default$2();
                bl = qual$5.reassignPartitions(x$62, x$63);
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                bl = false;
            }
            return bl;
        }).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$shouldPerformMultipleReassignmentOperationsOverVariousTopics$2(BoxesRunTime.unboxToBoolean((Object)x))));
        this.waitForReassignmentToComplete(1L);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
    }

    @Test
    public void shouldTriggerReassignmentOnControllerStartup() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))), this.servers());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Map firstMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("customers", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        this.zkClient().setOrCreatePartitionReassignment(firstMove);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.startup();
            return BoxedUnit.UNIT;
        });
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
    }

    public void waitForReassignmentToComplete(long pause) {
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$64 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress();
        Function0 & Serializable & scala.Serializable x$65 = (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReassignPartitionsZNode$.MODULE$.path()}));
        long x$66 = pause;
        long x$67 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$64, (Function0<String>)x$65, x$67, x$66);
    }

    public long waitForReassignmentToComplete$default$1() {
        return 100L;
    }

    public String json(Seq<String> topic) {
        String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> "{\"topic\": \"" + t + "\"}", Seq$.MODULE$.canBuildFrom())).mkString(",");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"topics\": [", "],\"version\":1}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicStr}));
    }

    public static final /* synthetic */ Properties $anonfun$startBrokers$1(ReassignPartitionsClusterTest $this, int i) {
        int x$7 = i;
        String x$8 = $this.zkConnect();
        boolean x$9 = false;
        int x$10 = 3;
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$13 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$14 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$15 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$20 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$22 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$23 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        return TestUtils$.MODULE$.createBrokerConfig(x$7, x$8, x$9, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$10, x$24);
    }

    public static final /* synthetic */ boolean $anonfun$getRandomLogDirAssignment$1(int brokerId$1, KafkaServer x$1) {
        return x$1.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testHwAfterPartitionReassignment$1(KafkaServer x$2) {
        return x$2.config().brokerId() == 100;
    }

    public static final /* synthetic */ boolean $anonfun$testHwAfterPartitionReassignment$2(KafkaServer x$3) {
        return x$3.config().brokerId() == 101;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExpandCluster$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq brokerIds = (Seq)tuple2._2();
        boolean bl = brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)102));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExpandCluster$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq brokerIds = (Seq)tuple2._2();
        boolean bl = brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)100));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$shouldPerformMultipleReassignmentOperationsOverVariousTopics$2(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public ReassignPartitionsClusterTest() {
        this.partitionId = 0;
        this.topicName = "my-topic";
        this.delayMs = 1000;
    }
}

