/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.include;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SCSSFileType;

public class SassScssFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    private static final String SASS_EXT = "sass";
    private static final String SCSS_EXT = "scss";

    @NotNull
    public String getId() {
        if ("SASS/SCSS" == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return "SASS/SCSS";
    }

    public boolean acceptFile(VirtualFile file) {
        return file.getFileType() == SASSFileType.SASS || file.getFileType() == SCSSFileType.SCSS;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)SASSFileType.SASS);
        fileTypeSink.consume((Object)SCSSFileType.SCSS);
    }

    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(2);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(3);
        }
        if (hostFileExt == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(4);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(5);
        }
        if (importUriExt == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(6);
        }
        if (SASS_EXT.equalsIgnoreCase(importUriExt) || SCSS_EXT.equalsIgnoreCase(importUriExt)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri);
        } else if (!SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + "." + SCSS_EXT)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + "." + SASS_EXT);
        }
    }

    @NotNull
    protected Language getLanguage() {
        SASSLanguage sASSLanguage = SASSLanguage.INSTANCE;
        if (sASSLanguage == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(7);
        }
        return sASSLanguage;
    }

    private static boolean tryAddImport(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String importUri) {
        String path;
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(8);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(9);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(10);
        }
        VirtualFile file = SassScssFileIncludeProvider.resolveImport(hostFile, importUri);
        VirtualFile hostFileDir = hostFile.getParent();
        if (file != null && hostFileDir != null && (path = SassScssFileIncludeProvider.getRelativePath(hostFileDir, file)) != null) {
            result.add(new FileIncludeInfo(path));
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile hostFileDir, @NotNull VirtualFile importedFile) {
        VirtualFile commonAncestor;
        if (hostFileDir == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(11);
        }
        if (importedFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(12);
        }
        if ((commonAncestor = VfsUtilCore.getCommonAncestor((VirtualFile)hostFileDir, (VirtualFile)importedFile)) == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        VirtualFile dir = hostFileDir;
        while (!commonAncestor.equals(dir)) {
            buffer.append("../");
            if ((dir = dir.getParent()) != null) continue;
            return null;
        }
        buffer.append(VfsUtilCore.getRelativePath((VirtualFile)importedFile, (VirtualFile)commonAncestor, (char)'/'));
        return buffer.toString();
    }

    @Nullable
    private static VirtualFile resolveImport(@NotNull VirtualFile hostFile, @NotNull String importUri) {
        String systemIndependentImportUri;
        VirtualFile importedFile;
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(13);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(14);
        }
        if ((importedFile = SassScssFileIncludeProvider.findFile(hostFile, systemIndependentImportUri = FileUtil.toSystemIndependentName((String)importUri))) != null && importedFile.isValid()) {
            return importedFile;
        }
        String partialImportUri = SassScssFileIncludeProvider.createPartialImportUri(systemIndependentImportUri);
        VirtualFile partialImportedFile = SassScssFileIncludeProvider.findFile(hostFile, partialImportUri);
        if (partialImportedFile != null && partialImportedFile.isValid()) {
            return partialImportedFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull VirtualFile hostFile, @NotNull String systemIndependentImportUri) {
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(15);
        }
        if (systemIndependentImportUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(16);
        }
        if (FileUtil.isAbsolutePlatformIndependent((String)systemIndependentImportUri)) {
            return hostFile.getFileSystem().findFileByPath(systemIndependentImportUri);
        }
        VirtualFile hostFileDir = hostFile.getParent();
        if (hostFileDir == null) {
            return null;
        }
        return hostFileDir.findFileByRelativePath(systemIndependentImportUri);
    }

    private static String createPartialImportUri(@NotNull String systemIndependentImportUri) {
        int pos;
        if (systemIndependentImportUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(17);
        }
        if ((pos = systemIndependentImportUri.lastIndexOf(47)) == -1) {
            return "_" + systemIndependentImportUri;
        }
        String baseName = systemIndependentImportUri.substring(pos + 1);
        String dirName = systemIndependentImportUri.substring(0, pos);
        return dirName + "/_" + baseName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileExt";
                break;
            }
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importUri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importUriExt";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemIndependentImportUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addImports";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryAddImport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPartialImportUri";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

