/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StatusBar
extends StatusBarInfo,
Disposable {
    public void addWidget(@NotNull StatusBarWidget var1);

    public void addWidget(@NotNull StatusBarWidget var1, @NotNull String var2);

    public void addWidget(@NotNull StatusBarWidget var1, @NotNull Disposable var2);

    public void addWidget(@NotNull StatusBarWidget var1, @NotNull String var2, @NotNull Disposable var3);

    @Deprecated
    public void addCustomIndicationComponent(@NotNull JComponent var1);

    @Deprecated
    public void removeCustomIndicationComponent(@NotNull JComponent var1);

    public void removeWidget(@NotNull String var1);

    public void updateWidget(@NotNull String var1);

    @Nullable
    public StatusBarWidget getWidget(String var1);

    public void fireNotificationPopup(@NotNull JComponent var1, Color var2);

    public StatusBar createChild();

    public JComponent getComponent();

    public StatusBar findChild(Component var1);

    public IdeFrame getFrame();

    public void install(IdeFrame var1);

    public static class StandardWidgets {
        public static final String ENCODING_PANEL = "Encoding";
        public static final String COLUMN_SELECTION_MODE_PANEL = "InsertOverwrite";
        public static final String READONLY_ATTRIBUTE_PANEL = "ReadOnlyAttribute";
        public static final String POSITION_PANEL = "Position";
    }

    public static class Anchors {
        public static final String DEFAULT_ANCHOR = Anchors.after("InsertOverwrite");

        public static String before(String widgetId) {
            return "before " + widgetId;
        }

        public static String after(String widgetId) {
            return "after " + widgetId;
        }
    }

    public static abstract class Info
    implements StatusBarInfo {
        public static final Topic<StatusBarInfo> TOPIC = Topic.create((String)"IdeStatusBar.Text", StatusBarInfo.class);

        private Info() {
        }

        public static void set(@Nullable String text, @Nullable Project project) {
            Info.set(text, project, null);
        }

        public static void set(@Nullable String text, @Nullable Project project, @Nullable String requestor) {
            if (project != null) {
                if (project.isDisposed()) {
                    return;
                }
                if (!project.isInitialized()) {
                    StartupManager.getInstance(project).runWhenProjectIsInitialized(() -> ((StatusBarInfo)project.getMessageBus().syncPublisher(TOPIC)).setInfo(text, requestor));
                    return;
                }
            }
            MessageBus bus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
            ((StatusBarInfo)bus.syncPublisher(TOPIC)).setInfo(text, requestor);
        }
    }
}

