/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.jetbrains.performancePlugin.commands.Waiter;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.ide.PooledThreadExecutor;

public class ReplaceTextCommand
extends AbstractCommand {
    public static final String PREFIX = "%replaceText";
    public static final char NEWLINE = '\u32e1';
    private final Project myProject;

    public ReplaceTextCommand(@NotNull String command, int line, Project project) {
        if (command == null) {
            ReplaceTextCommand.$$$reportNull$$$0(0);
        }
        super(command, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        AsyncPromise result = new AsyncPromise();
        String text = this.getText().substring(PREFIX.length() + 1).replace('\u32e1', '\n');
        PooledThreadExecutor.INSTANCE.execute(() -> {
            try {
                Waiter.checkCondition(() -> AlphaNumericTypeCommand.findTarget((PlaybackContext)context) != null).await(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                result.setError((Throwable)e);
                return;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                TypingTarget target = AlphaNumericTypeCommand.findTarget((PlaybackContext)context);
                if (target instanceof EditorComponentImpl) {
                    DocumentEx document = ((EditorComponentImpl)target).getEditor().getDocument();
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> document.replaceText((CharSequence)text, document.getModificationStamp() + 1L));
                    result.setResult(null);
                } else {
                    result.setError("Cannot replace text on non-Editor component");
                }
            });
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/performancePlugin/commands/ReplaceTextCommand", "<init>"));
    }
}

