/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregateDifferenceEmphasizer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregatesDiffTableModel;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregatesViewDiff;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.DiffCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.MarkUnmarkDiffAction;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.NavigateInSourceSnapshotAction;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class V8HeapSummaryDiffComponent
implements ProfilingView<V8HeapTreeTable> {
    public static final DataKey<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> SELECTED_PAIR = DataKey.create((String)"Node.Js.Profiling.Heap.Diff.Selected.Pair");
    private final V8HeapTreeTable myTable;
    private final Project myProject;
    private final V8DiffCachingReader myReader;
    private final String myBaseName;
    private final String myChangedName;

    public V8HeapSummaryDiffComponent(Project project, V8DiffCachingReader reader, String baseName, String changedName) {
        this.myProject = project;
        this.myReader = reader;
        this.myBaseName = baseName;
        this.myChangedName = changedName;
        this.myTable = new V8HeapTreeTable((TreeTableModel)new AggregatesDiffTableModel(project, reader), reader.getResourses());
        TreeTableSpeedSearch search = new TreeTableSpeedSearch((TreeTable)this.myTable, o -> {
            Object component = o.getLastPathComponent();
            if (component instanceof AggregatesViewDiff.AggregateDifference) {
                return ((AggregatesViewDiff.AggregateDifference)component).getClassIdx();
            }
            if (component instanceof BeforeAfter) {
                BeforeAfter beforeAfter = (BeforeAfter)component;
                if (beforeAfter.getAfter() != null) {
                    return ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getName();
                }
                return ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getName();
            }
            return component.toString();
        });
        search.setComparator(new SpeedSearchComparator(false, true));
        V8Utils.afterModelReset(this.myTable, null, reader.getResourses(), (TreeCellRenderer)((Object)new DiffCellRenderer(project, reader.getBaseReader(), reader.getChangedReader(), AggregateDifferenceEmphasizer.getInstance())));
    }

    @Override
    public JComponent getMainComponent() {
        DataProviderPanel panel = DataProviderPanel.wrap((JComponent)new JBScrollPane((Component)((Object)this.myTable)));
        panel.register(SELECTED_PAIR.getName(), (Getter<Object>)((Getter)() -> {
            TreePath value = this.myTable.getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof BeforeAfter) {
                return value.getLastPathComponent();
            }
            return null;
        }));
        return panel;
    }

    @Override
    public String getName() {
        return "Summary Diff";
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        MarkUnmarkDiffAction markUnmarkDiffAction = new MarkUnmarkDiffAction(this.myProject, this.myBaseName, this.myChangedName, this.myReader.getBaseReader().getDigest(), this.myReader.getChangedReader().getDigest());
        NavigateInSourceSnapshotAction navigateInSourceSnapshotAction = new NavigateInSourceSnapshotAction(this.myProject, this.myBaseName, this.myChangedName, this.myReader.getBaseReader().getDigest(), this.myReader.getChangedReader().getDigest());
        group.add((AnAction)markUnmarkDiffAction);
        group.add((AnAction)navigateInSourceSnapshotAction);
        DefaultActionGroup popupGroup = new DefaultActionGroup();
        popupGroup.add((AnAction)markUnmarkDiffAction);
        popupGroup.add((AnAction)navigateInSourceSnapshotAction);
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTable), (ActionGroup)popupGroup, (String)"V8_HEAP_DIFF_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8HeapTreeTable getTreeTable() {
        return this.myTable;
    }

    @Override
    public void defaultExpand() {
    }

    static void selectSourceProfile(String baseName, String changedName, AnActionEvent e, Consumer<? super Boolean> consumer) {
        String before = "Before: " + baseName;
        String after = "After: " + changedName;
        IPopupChooserBuilder popupChooserBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])new String[]{before, after})).setTitle("Select source profile:").setMovable(true).setResizable(true).setCancelKeyEnabled(true).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).setItemChosenCallback(v -> consumer.consume((Object)v.equals(before)));
        JBPopup popup = popupChooserBuilder.createPopup();
        V8Utils.showPopup(e, popup);
    }
}

