/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapProcessor;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import com.jetbrains.nodejs.util.CloseableThrowableProcessor;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class SequentialRawReader<T>
implements Closeable {
    private final File myFile;
    private final RawSerializer<? extends T> mySerializer;
    private InputStream myStream;
    private DataInputStream myDataInputStream;
    private final long mySize;
    private long myCnt;

    public SequentialRawReader(File file, RawSerializer<? extends T> serializer, long size) throws FileNotFoundException {
        this.myFile = file;
        this.mySerializer = serializer;
        this.myStream = new BufferedInputStream(new FileInputStream(file));
        this.myDataInputStream = new DataInputStream(this.myStream);
        this.mySize = size;
        this.myCnt = 0L;
    }

    public SequentialRawReader(File file, RawSerializer<? extends T> serializer) throws FileNotFoundException {
        this.myFile = file;
        this.mySerializer = serializer;
        this.myStream = new BufferedInputStream(new FileInputStream(file));
        this.myDataInputStream = new DataInputStream(this.myStream);
        this.mySize = -1L;
        this.myCnt = 0L;
    }

    @Override
    public void close() {
        if (this.myStream != null) {
            try {
                this.myStream.close();
            }
            catch (IOException e) {
                V8HeapProcessor.LOG.info((Throwable)e);
            }
            this.myStream = null;
        }
    }

    public boolean hasNext() throws IOException {
        return this.mySize >= 0L ? this.myCnt < this.mySize : this.myStream.available() > 0;
    }

    public T read() throws IOException {
        ++this.myCnt;
        return this.mySerializer.read(this.myDataInputStream);
    }

    public void skipBytes(int offset, int elements) throws IOException {
        this.myDataInputStream.skipBytes(offset);
        this.myCnt = elements;
    }

    public void skip(long numElements) throws IOException {
        this.myDataInputStream.skipBytes((int)(this.mySerializer.getRecordSize() * numElements));
        this.myCnt = numElements;
    }

    public void reset() throws IOException {
        this.myDataInputStream.close();
        this.myStream = new BufferedInputStream(new FileInputStream(this.myFile));
        this.myDataInputStream = new DataInputStream(this.myStream);
        this.myCnt = 0L;
    }

    public void iterate(@NotNull CloseableThrowableProcessor<T, IOException> processor) throws IOException {
        if (processor == null) {
            SequentialRawReader.$$$reportNull$$$0(0);
        }
        try {
            while (this.hasNext() && processor.process(this.read())) {
            }
        }
        finally {
            processor.close();
            this.close();
        }
    }

    public void iterate(@NotNull CloseableThrowableConsumer<T, IOException> consumer) throws IOException {
        if (consumer == null) {
            SequentialRawReader.$$$reportNull$$$0(1);
        }
        try {
            while (this.hasNext()) {
                consumer.consume(this.read());
            }
        }
        finally {
            consumer.close();
            this.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/io/SequentialRawReader";
        objectArray[2] = "iterate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

