/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlPropertiesPanel
extends JPanel
implements Disposable {
    public static final int ROW_LENGTH = 6;
    private final Map<String, TypesRegistry.ParamEditor> myFields;
    private final List<TypesRegistry.ParamEditor> myAllFields;
    private final DataInterchange myDataInterchange;
    private final boolean myAuthSupported;
    private final boolean myEmpty;

    public UrlPropertiesPanel(@NotNull StatelessParametersHolder parametersHolder, @NotNull DataInterchange dataInterchange, final @NotNull Runnable focusCallback) {
        boolean bl;
        if (parametersHolder == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (dataInterchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(1);
        }
        if (focusCallback == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(2);
        }
        this.myFields = ContainerUtil.newHashMap();
        this.myAllFields = ContainerUtil.newArrayList();
        this.myDataInterchange = dataInterchange;
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                focusCallback.run();
            }

            @Override
            public void focusLost(FocusEvent e) {
                focusCallback.run();
            }
        };
        ArrayList parameters = ContainerUtil.newArrayList(parametersHolder.getParameters());
        List<List<TypesRegistry.ParamEditor>> layoutData = UrlPropertiesPanel.getLayout(parametersHolder, UrlPropertiesPanel.pruneParameters(parameters), this.myDataInterchange, this.myFields);
        for (List<TypesRegistry.ParamEditor> list : layoutData) {
            for (TypesRegistry.ParamEditor paramEditor : list) {
                Disposer.register((Disposable)this, (Disposable)paramEditor);
                paramEditor.addFocusListener(focusListener);
            }
        }
        this.myDataInterchange.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TypesRegistry.ParamEditor editor = (TypesRegistry.ParamEditor)UrlPropertiesPanel.this.myFields.get(evt.getPropertyName());
                String value = StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class)));
                if (editor != null && !editor.getText().equals(value)) {
                    editor.setText(value);
                }
            }
        }, this);
        for (Map.Entry entry : this.myFields.entrySet()) {
            ((TypesRegistry.ParamEditor)entry.getValue()).setChangeListener(() -> this.myDataInterchange.putProperty((String)entry.getKey(), ((TypesRegistry.ParamEditor)entry.getValue()).getText()));
        }
        this.myAuthSupported = JdbcUrlParserUtil.isAuthSupported(parametersHolder);
        this.myEmpty = layoutData.isEmpty();
        if (!layoutData.isEmpty()) {
            this.setLayout((LayoutManager)new GridLayoutManager(layoutData.size(), 6));
        }
        int row = 0;
        boolean bl2 = true;
        for (List list : layoutData) {
            if (list.size() <= 1) continue;
            bl = false;
            break;
        }
        for (List list : layoutData) {
            int column2 = 0;
            for (TypesRegistry.ParamEditor editor : list) {
                int span;
                this.myAllFields.add(editor);
                if (editor.getCaption() != null) {
                    JBLabel label = new JBLabel(editor.getCaption());
                    if (column2 != 0) {
                        label.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                    }
                    this.add((Component)label, UrlPropertiesPanel.createLabelConstraints(row, column2, label.getPreferredSize().getWidth()));
                }
                if (column2 == 0) {
                    ++column2;
                    span = bl ? 5 : 3;
                } else if (editor.getCaption() != null) {
                    ++column2;
                    span = 1;
                } else {
                    span = 2;
                }
                this.add((Component)editor.getComponent(), UrlPropertiesPanel.createSimpleConstraints(row, column2, span));
                column2 += span;
            }
            ++row;
        }
    }

    public void dispose() {
    }

    public static GridConstraints createLabelConstraints(int row, int col, double width) {
        return UrlPropertiesPanel.createConstraints(row, col, 1, 0, 3, (int)width, false);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int colSpan) {
        return UrlPropertiesPanel.createConstraints(row, col, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int rowSpan, int colSpan) {
        return UrlPropertiesPanel.createConstraints(row, col, rowSpan, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createRowConstraints(int row) {
        return UrlPropertiesPanel.createConstraints(row, 0, 6, 1, 1, -1, false);
    }

    public static GridConstraints createAlignedConstraints(int row, int col, int colSpan, int anchor) {
        return UrlPropertiesPanel.createConstraints(row, col, colSpan, anchor, 0, -1, false);
    }

    public static GridConstraints notUseParent(GridConstraints c2) {
        c2.setUseParentLayout(false);
        return c2;
    }

    public static void drawLayout(GridLayoutManager l, Component comp, Graphics g, Color c2) {
        g.setColor(c2);
        for (int x : l.getVerticalGridLines()) {
            g.drawLine(x, 0, x, comp.getHeight());
        }
        for (int y : l.getHorizontalGridLines()) {
            g.drawLine(0, y, comp.getWidth(), y);
        }
    }

    public static GridConstraints createConstraints(int row, int col, int colSpan, int anchor, int fill, int prefWidth, boolean rubber) {
        return UrlPropertiesPanel.createConstraints(row, col, 1, colSpan, anchor, fill, prefWidth, rubber);
    }

    public static GridConstraints createConstraints(int row, int col, int rowSpan, int colSpan, int anchor, int fill, int prefWidth, boolean rubber) {
        Dimension nonPref = new Dimension(-1, -1);
        Dimension pref = new Dimension(prefWidth == -1 ? 100 : prefWidth, -1);
        int hpolicy = rubber ? 7 : 0;
        return new GridConstraints(row, col, rowSpan, colSpan, anchor, fill, hpolicy, 0, nonPref, pref, nonPref, 0, true);
    }

    private static boolean isPair(@Nullable String param1, @Nullable String param2, Map<String, TypesRegistry.ParamEditor> fields) {
        if (param1 == null || param2 == null) {
            return false;
        }
        if (param1.equals("host") && param2.equals("port")) {
            return true;
        }
        return fields.get(param2).getFieldSize() == TypesRegistry.ParamEditor.FieldSize.SMALL;
    }

    private static void moveTo(@NotNull String param, @NotNull List<String> params, boolean begin) {
        if (param == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(3);
        }
        if (params == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(4);
        }
        if (params.contains(param)) {
            params.remove(param);
            params.add(begin ? 0 : params.size(), param);
        }
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    @NotNull
    private static List<String> pruneParameters(@NotNull List<String> params) {
        if (params == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(5);
        }
        params.remove("user");
        params.remove("password");
        UrlPropertiesPanel.moveTo("database", params, true);
        UrlPropertiesPanel.moveTo("instance", params, true);
        UrlPropertiesPanel.moveTo("port", params, true);
        UrlPropertiesPanel.moveTo("host", params, true);
        UrlPropertiesPanel.moveTo("file", params, true);
        UrlPropertiesPanel.moveTo("path", params, true);
        UrlPropertiesPanel.moveTo("driver", params, false);
        List<String> list = params;
        if (list == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean isAuthSupported() {
        return this.myAuthSupported;
    }

    private static List<List<TypesRegistry.ParamEditor>> getLayout(@NotNull StatelessParametersHolder parser, @NotNull List<String> params, @NotNull DataInterchange interchange, @NotNull Map<String, TypesRegistry.ParamEditor> fields) {
        if (parser == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(7);
        }
        if (params == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(8);
        }
        if (interchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(9);
        }
        if (fields == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(10);
        }
        ArrayList editors = ContainerUtil.newArrayList();
        HashMap paramNames = ContainerUtil.newHashMap();
        for (String param : params) {
            TypesRegistry.TypeDescriptor descriptor = TypesRegistry.INSTANCE.get((String)ObjectUtils.assertNotNull((Object)parser.getParameterType(param)));
            if (descriptor == null) continue;
            editors.addAll(descriptor.createSatellites(interchange));
            TypesRegistry.ParamEditor field = descriptor.createField(param, parser.getParameterConfig(param), interchange);
            editors.add(field);
            fields.put(param, field);
            paramNames.put(field, param);
        }
        ArrayList res2 = ContainerUtil.newArrayList();
        for (TypesRegistry.ParamEditor editor : editors) {
            boolean append;
            List curRow = (List)ContainerUtil.getLastItem((List)res2);
            TypesRegistry.ParamEditor prev = (TypesRegistry.ParamEditor)ContainerUtil.getLastItem((List)curRow);
            assert (prev == null || curRow != null);
            boolean bl = append = prev != null && curRow.size() < 2 && UrlPropertiesPanel.isPair((String)paramNames.get(prev), (String)paramNames.get(editor), fields);
            if (curRow == null || !append) {
                curRow = ContainerUtil.newArrayListWithCapacity((int)1);
                res2.add(curRow);
            }
            curRow.add(editor);
        }
        return res2;
    }

    public void setFieldsActive(boolean isActive) {
        for (TypesRegistry.ParamEditor panel : this.myAllFields) {
            panel.setActive(isActive);
        }
    }

    @Nullable
    public String getActiveParameter() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return null;
        }
        for (Map.Entry<String, TypesRegistry.ParamEditor> entry : this.myFields.entrySet()) {
            if (!entry.getValue().getComponent().isAncestorOf(owner)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    public DataInterchange getDataInterchange() {
        DataInterchange dataInterchange = this.myDataInterchange;
        if (dataInterchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(11);
        }
        return dataInterchange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataInterchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pruneParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataInterchange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pruneParameters";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLayout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

