/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public enum TableOrganization {
    DEFAULT(null),
    HEAP("E"),
    INDEX("I"),
    ORA_CLUSTERED_BY_INDEX("OCI"),
    ORA_CLUSTERED_BY_HASH("OCH"),
    EXTERNAL("X");

    public final String code;
    @NotNull
    private static final Map<String, TableOrganization> MAP_BY_CODES;

    private TableOrganization(String code) {
        this.code = code;
    }

    @NotNull
    public static TableOrganization byCode(String code) {
        TableOrganization organization = MAP_BY_CODES.get(code);
        TableOrganization tableOrganization = organization != null ? organization : DEFAULT;
        if (tableOrganization == null) {
            TableOrganization.$$$reportNull$$$0(0);
        }
        return tableOrganization;
    }

    static {
        TreeMap<String, TableOrganization> mbc = new TreeMap<String, TableOrganization>(String.CASE_INSENSITIVE_ORDER);
        mbc.put(TableOrganization.HEAP.code, HEAP);
        mbc.put(TableOrganization.INDEX.code, INDEX);
        mbc.put(TableOrganization.ORA_CLUSTERED_BY_INDEX.code, ORA_CLUSTERED_BY_INDEX);
        mbc.put(TableOrganization.ORA_CLUSTERED_BY_HASH.code, ORA_CLUSTERED_BY_HASH);
        mbc.put(TableOrganization.EXTERNAL.code, EXTERNAL);
        MAP_BY_CODES = Collections.unmodifiableMap(mbc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/TableOrganization", "byCode"));
    }
}

