/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlDeclareSectionBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlVariableDefinitionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/formatter/model/SqlDeclareSectionBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "countOfElements", "", "getCountOfElements", "()I", "setCountOfElements", "(I)V", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "intellij.database.sql.impl"})
final class SqlDeclareSectionBlock
extends SqlRangeBlock {
    private int countOfElements;

    public final int getCountOfElements() {
        return this.countOfElements;
    }

    public final void setCountOfElements(int n) {
        this.countOfElements = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION))) {
            void $receiver$iv;
            int n = this.countOfElements;
            this.countOfElements = n + 1;
            SqlNodeBlock sqlNodeBlock = new SqlVariableDefinitionBlock();
            SqlBlock parent$iv = this;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
            sqlBlock = SqlBlockKt.withRole((SqlBlock)sqlNodeBlock, BlockRole.ELEMENT);
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s = this.getContext().getSql();
        Wrap w1 = s.IMP_DECLARE_CONTENT_WRAP ? SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.ALWAYS, false, 2, null) : null;
        boolean several = this.countOfElements >= 2;
        Wrap w2 = several ? this.makeWrap$intellij_database_sql_impl(w1, s.IMP_DECLARE_EL_WRAP) : null;
        Alignment a = several ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        SqlBlock sqlBlock = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
        if (sqlBlock != null) {
            SqlBlock sqlBlock2 = sqlBlock;
            SqlBlock it = sqlBlock2;
            it.setMyWrap(w1);
            it.setMyAlign(a);
        }
        if (several) {
            JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"nestedBlocks.filter(ELEMENT).skip(1)");
            Iterable $receiver$iv = (Iterable)jBIterable;
            for (Object element$iv : $receiver$iv) {
                SqlBlock it = (SqlBlock)element$iv;
                it.setMyWrap(w2);
                it.setMyAlign(a);
            }
            if (s.IMP_DECLARE_ALIGN_TYPE || s.IMP_DECLARE_ALIGN_EQ || s.IMP_DECLARE_ALIGN_DEFAULT) {
                Alignment a1 = s.IMP_DECLARE_ALIGN_TYPE ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
                Alignment a2 = s.IMP_DECLARE_ALIGN_EQ ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
                Alignment a3 = s.IMP_DECLARE_ALIGN_DEFAULT ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
                Iterable $receiver$iv2 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                for (Object element$iv : $receiver$iv2) {
                    SqlBlock variable;
                    SqlBlock sqlBlock3 = variable = (SqlBlock)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlBlock3, (String)"variable");
                    for (SqlBlock b2 : sqlBlock3.getSubBlocks()) {
                        switch (SqlDeclareSectionBlock$WhenMappings.$EnumSwitchMapping$0[b2.getRole().ordinal()]) {
                            case 1: {
                                b2.setMyAlign(a1);
                                break;
                            }
                            case 2: {
                                b2.setMyAlign(a2);
                                break;
                            }
                            case 3: {
                                b2.setMyAlign(a3);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        BlockRole r2 = block2.getRole();
        if (r2 == BlockRole.ELEMENT) {
            int elw = this.getContext().getSql().IMP_DECLARE_EL_WRAP;
            spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, elw == 0 || elw == 3, 1, null);
        } else {
            spacing = super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean userRequiresExpand() {
        SqlCodeStyleSettings s = this.getContext().getSql();
        return s.IMP_DECLARE_CONTENT_WRAP || s.IMP_DECLARE_EL_WRAP == 1 && this.countOfElements >= 2 || s.IMP_DECLARE_EL_WRAP == 0 && this.contains('\n');
    }
}

