/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlQueryValidatorInspectionBase;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlWithoutWhereInspection
extends SqlQueryValidatorInspectionBase {
    private static final String UPDATE_KEY = "update";
    private static final String DELETE_KEY = "delete";
    public boolean myDontWarnForSelfRefs = true;
    public boolean myDontWarnForLimit = true;

    @Override
    protected SqlQueryValidatorInspectionBase.Visitor createVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly, boolean isQueryValidationPass) {
        if (dialect == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(2);
        }
        return new SqlQueryValidatorInspectionBase.Visitor(manager, dialect, result2, onTheFly, isQueryValidationPass){

            public void visitSqlUpdateStatement(SqlUpdateStatement o) {
                this.checkWherePresence((SqlStatement)o, SqlWithoutWhereInspection.UPDATE_KEY);
            }

            public void visitSqlDeleteStatement(SqlDeleteStatement o) {
                this.checkWherePresence((SqlStatement)o, SqlWithoutWhereInspection.DELETE_KEY);
            }

            private void checkWherePresence(SqlStatement o, String key2) {
                PsiElement root2 = this.findRootElement(o);
                if (root2 == null) {
                    return;
                }
                boolean hasSet = false;
                for (PsiElement child = root2.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof SqlWhereClause) {
                        return;
                    }
                    if (key2 == SqlWithoutWhereInspection.DELETE_KEY && child instanceof SqlReturningClause) {
                        return;
                    }
                    if (SqlWithoutWhereInspection.this.myDontWarnForLimit && child instanceof SqlClause && PsiUtilCore.getElementType((PsiElement)child.getFirstChild()) == SqlCommonKeywords.SQL_LIMIT) {
                        return;
                    }
                    if (key2 == SqlWithoutWhereInspection.UPDATE_KEY && (child instanceof SqlFromClause || SqlWithoutWhereInspection.this.myDontWarnForSelfRefs && child instanceof SqlSetClause && SqlImplUtil.sqlTraverser(child).children((Object)child).filter(x$0 -> SqlWithoutWhereInspection.hasOwnOrComplexRefs(x$0)).isNotEmpty())) {
                        return;
                    }
                    if (!(child instanceof SqlSetClause)) continue;
                    hasSet = true;
                }
                if (key2 == SqlWithoutWhereInspection.UPDATE_KEY && !hasSet) {
                    return;
                }
                this.reportIssue(o.getFirstChild(), SqlMessages.message(key2 + ".without.where", new Object[0]));
            }

            @Nullable
            private PsiElement findRootElement(SqlStatement o) {
                SqlDmlInstruction dmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)o, SqlDmlInstruction.class);
                return dmlInstruction != null ? dmlInstruction : o;
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(SqlMessages.message("update.without.where.skip.limit", new Object[0]), "myDontWarnForLimit");
        optionsPanel.addCheckbox(SqlMessages.message("update.without.where.skip.self.refs", new Object[0]), "myDontWarnForSelfRefs");
        return optionsPanel;
    }

    private static boolean hasReferencesTo(@NotNull PsiElement element2, @NotNull PsiElement leftElement) {
        PsiReference psiReference;
        if (element2 == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(3);
        }
        if (leftElement == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(4);
        }
        return (psiReference = element2.getReference()) != null && psiReference.isReferenceTo(leftElement);
    }

    private static boolean hasOwnOrComplexRefs(@Nullable PsiElement assignment) {
        if (!(assignment instanceof SqlSetAssignment)) {
            return false;
        }
        SqlElement lvalue = ((SqlSetAssignment)assignment).getLValue();
        SqlElement rvalue = ((SqlSetAssignment)assignment).getRValue();
        if (rvalue == null) {
            return false;
        }
        if (!(lvalue instanceof SqlReferenceExpression)) {
            return true;
        }
        PsiReference reference = lvalue.getReference();
        if (reference == null) {
            return false;
        }
        PsiElement leftElement = reference.resolve();
        if (leftElement == null) {
            return true;
        }
        return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)rvalue).filterTypes(e -> e == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE).filter(e -> SqlWithoutWhereInspection.hasReferencesTo(e, leftElement))).iterator().hasNext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/SqlWithoutWhereInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReferencesTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

