/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.actions.ruleset.CssSelectTargetPopupFactory;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSelectorAction
extends BaseRefactoringIntentionAction {
    private static final String CREATE_SELECTOR_ID_STRING = "createCssSelectorIntention";

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"create.selector.action", (Object[])new Object[0]);
        if (string == null) {
            CreateSelectorAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"create.selector.family", (Object[])new Object[0]);
        if (string == null) {
            CreateSelectorAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile containingFile;
        if (project == null) {
            CreateSelectorAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CreateSelectorAction.$$$reportNull$$$0(3);
        }
        if (!CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)(containingFile = element.getContainingFile()))) {
            return false;
        }
        HtmlCssClassOrIdReference reference = CreateSelectorAction.getClassOrIdReference(element, editor);
        if (reference != null && containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            return document != null && reference.multiResolve(false).length == 0;
        }
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            CreateSelectorAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CreateSelectorAction.$$$reportNull$$$0(5);
        }
        final PsiFile containingFile = element.getContainingFile();
        final HtmlCssClassOrIdReference classOrIdReference = CreateSelectorAction.getClassOrIdReference(element, editor);
        if (classOrIdReference != null) {
            Pass<StyleCreator> chooseCreatorCallback = new Pass<StyleCreator>(){

                public void pass(StyleCreator styleCreator) {
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        CssRuleset createdRuleset = styleCreator.createStyleDeclaration(classOrIdReference, new CssDeclaration[0]);
                        if (createdRuleset != null) {
                            CssBlock block = createdRuleset.getBlock();
                            if (block != null && block.isValid() && containingFile == block.getContainingFile()) {
                                CreateSelectorAction.navigateInBlock(block, editor);
                            } else if (createdRuleset.canNavigate()) {
                                createdRuleset.navigate(true);
                            }
                        }
                    }, CreateSelectorAction.this.getText(), (Object)CreateSelectorAction.CREATE_SELECTOR_ID_STRING, editor.getDocument());
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StyleCreator styleCreator = (StyleCreator)project.getUserData(StyleCreator.EXPLICITLY_CHOSEN_STYLE_CREATOR);
                assert (styleCreator != null);
                chooseCreatorCallback.pass((Object)styleCreator);
            } else {
                CssSelectTargetPopupFactory.createSelectTargetPopup(this.getText(), containingFile, true, chooseCreatorCallback).showInBestPositionFor(editor);
            }
        }
    }

    @Nullable
    private static HtmlCssClassOrIdReference getClassOrIdReference(PsiElement element, Editor editor) {
        PsiReference[] references;
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)false);
        PsiReference[] psiReferenceArray = references = xmlAttributeValue != null ? xmlAttributeValue.getReferences() : PsiReference.EMPTY_ARRAY;
        if (xmlAttributeValue != null && references.length > 0) {
            int inElementOffset = editor.getCaretModel().getOffset() - xmlAttributeValue.getTextOffset();
            for (PsiReference each : references) {
                TextRange range;
                UnfairTextRange textRange;
                if (!(each instanceof HtmlCssClassOrIdReference) || !(textRange = new UnfairTextRange((range = each.getRangeInElement()).getStartOffset() - 1, range.getEndOffset())).contains(inElementOffset)) continue;
                return (HtmlCssClassOrIdReference)each;
            }
        }
        return null;
    }

    private static void navigateInBlock(CssBlock block, Editor editor) {
        Object[] declarations = block.getDeclarations();
        CssDeclaration firstDeclaration = (CssDeclaration)ArrayUtil.getFirstElement((Object[])declarations);
        if (firstDeclaration != null && firstDeclaration.canNavigate()) {
            firstDeclaration.navigate(true);
        } else {
            PsiElement lBrace = block.getLBrace();
            if (lBrace != null) {
                editor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CreateSelectorAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CreateSelectorAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

