/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssOverwrittenPropertiesInspection
extends CssBaseInspection {
    private static final RemoveOverwrittenPropertyQuickfix[] OVERWRITTEN_PROPERTY_QUICKFIX = new RemoveOverwrittenPropertyQuickfix[]{new RemoveOverwrittenPropertyQuickfix()};
    private static final Set<String> PROPERTIES_ALLOWING_DUPLICATES = ContainerUtil.set((Object[])new String[]{"src", "composes"});

    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.overwritten.properties", (Object[])new Object[0]);
        if (string == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CssOverwrittenProperties" == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(1);
        }
        return "CssOverwrittenProperties";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(2);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssBlock(CssBlock block) {
                super.visitCssBlock(block);
                HashMap name2decls = new HashMap();
                CssDeclaration[] declarations = block.getDeclarations();
                for (CssDeclaration decl : declarations) {
                    if (!CssInspectionsUtil.isPureCssPropertyName(decl.getPropertyNameElement())) continue;
                    if (decl.isShorthandProperty()) {
                        String[] names;
                        for (String name : names = decl.expandShorthandProperty()) {
                            CssOverwrittenPropertiesInspection.updateDecls(name2decls, name, decl);
                        }
                        continue;
                    }
                    String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)decl);
                    if (decl.isHack()) {
                        propertyName = "*" + propertyName;
                    }
                    CssOverwrittenPropertiesInspection.updateDecls(name2decls, propertyName, decl);
                }
                for (String propertyName : name2decls.keySet()) {
                    List decls;
                    if (PROPERTIES_ALLOWING_DUPLICATES.contains(propertyName) || (decls = (List)name2decls.get(propertyName)).size() <= 1) continue;
                    for (int i = 1; i < decls.size(); ++i) {
                        String messageId;
                        CssDeclaration duplicateProperty;
                        String duplicatePropertyName;
                        String duplicatedDeclaration;
                        String currName;
                        CssDeclaration prev = (CssDeclaration)decls.get(i - 1);
                        CssDeclaration curr = (CssDeclaration)decls.get(i);
                        boolean prevIsShorthand = prev.isShorthandProperty();
                        int prevShorthandPropNum = -1;
                        if (prevIsShorthand) {
                            String[] properties = prev.expandShorthandProperty();
                            Map<String, String> expandedValues = CssPropertyUtil.getExpandedShorthandValues(prev, properties);
                            prevShorthandPropNum = expandedValues.size();
                        }
                        boolean currIsShorthand = curr.isShorthandProperty();
                        String prevPropName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)prev);
                        String currPropName = curr.getPropertyName();
                        boolean prevPropertyIsOverwritten = !prev.isImportant() || curr.isImportant();
                        boolean problem = false;
                        if (CssOverwrittenPropertiesInspection.isOverwrittenValues(propertyName, prev, curr)) {
                            if (prevIsShorthand && currIsShorthand) {
                                currName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)curr);
                                if (!(currName.contains("left") || currName.contains("right") || currName.contains("top") || currName.contains("bottom"))) {
                                    problem = true;
                                }
                            } else if (!prevIsShorthand && currIsShorthand) {
                                problem = true;
                            } else if (!prevIsShorthand && !currIsShorthand) {
                                problem = true;
                            } else if (prevShorthandPropNum == 1 && !currIsShorthand) {
                                problem = true;
                            }
                            if (!problem) continue;
                            String messageForPreviousProperty = prevPropertyIsOverwritten ? CssBundle.message((String)"css.overwritten.properties.message", (Object[])new Object[]{prevPropName}) : CssBundle.message((String)"css.overwriting.properties.message", (Object[])new Object[]{prevPropName, currPropName});
                            String messageForCurrentProperty = prevPropertyIsOverwritten ? CssBundle.message((String)"css.overwriting.properties.message", (Object[])new Object[]{currPropName, prevPropName}) : CssBundle.message((String)"css.overwritten.properties.message", (Object[])new Object[]{currPropName});
                            holder.registerProblem((PsiElement)prev, messageForPreviousProperty, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? OVERWRITTEN_PROPERTY_QUICKFIX : LocalQuickFix.EMPTY_ARRAY));
                            if (prevIsShorthand) {
                                String[] properties;
                                for (String property : properties = prev.expandShorthandProperty()) {
                                    ((List)name2decls.get(property)).remove(prev);
                                }
                            } else {
                                ((List)name2decls.get(propertyName)).remove(prev);
                            }
                            holder.registerProblem((PsiElement)curr, messageForCurrentProperty, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? OVERWRITTEN_PROPERTY_QUICKFIX : LocalQuickFix.EMPTY_ARRAY));
                            continue;
                        }
                        if (!CssOverwrittenPropertiesInspection.hasEqualValues(propertyName, prev, curr) || currIsShorthand && prevIsShorthand && ((currName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)curr)).contains("left") || currName.contains("right") || currName.contains("top") || currName.contains("bottom"))) continue;
                        if (!prevIsShorthand && currIsShorthand) {
                            duplicatedDeclaration = currPropName;
                            duplicatePropertyName = prevPropName;
                            duplicateProperty = prev;
                            messageId = "css.overwriting.properties.duplicated.message";
                        } else {
                            duplicatedDeclaration = prevPropertyIsOverwritten ? prevPropName : currPropName;
                            duplicatePropertyName = prevPropertyIsOverwritten ? currPropName : prevPropName;
                            duplicateProperty = prevPropertyIsOverwritten ? curr : prev;
                            messageId = "css.overwriting.properties.duplicates.message";
                        }
                        String message = CssBundle.message((String)messageId, (Object[])new Object[]{duplicatePropertyName, duplicatedDeclaration});
                        holder.registerProblem((PsiElement)duplicateProperty, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? OVERWRITTEN_PROPERTY_QUICKFIX : LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(3);
        }
        return cssElementVisitor;
    }

    private static boolean hasEqualValues(@NotNull @NonNls String propertyName, @NotNull CssDeclaration decl1, @NotNull CssDeclaration decl2) {
        if (propertyName == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(4);
        }
        if (decl1 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(5);
        }
        if (decl2 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(6);
        }
        PsiElement[] value1 = CssOverwrittenPropertiesInspection.declarationValue(decl1, propertyName);
        PsiElement[] value2 = CssOverwrittenPropertiesInspection.declarationValue(decl2, propertyName);
        if (value1.length == 0 && value2.length == 0) {
            return false;
        }
        String stringValue1 = CssOverwrittenPropertiesInspection.joinedText(value1);
        String stringValue2 = CssOverwrittenPropertiesInspection.joinedText(value2);
        return stringValue2.equalsIgnoreCase(stringValue1);
    }

    private static boolean isOverwrittenValues(@NotNull @NonNls String propertyName, @NotNull CssDeclaration decl1, @NotNull CssDeclaration decl2) {
        if (propertyName == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(7);
        }
        if (decl1 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(8);
        }
        if (decl2 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(9);
        }
        if (decl1.isHack() ^ decl2.isHack()) {
            return false;
        }
        PsiElement[] value1 = CssOverwrittenPropertiesInspection.declarationValue(decl1, propertyName);
        PsiElement[] value2 = CssOverwrittenPropertiesInspection.declarationValue(decl2, propertyName);
        if (value1.length > 0 && value2.length > 0) {
            String stringValue2;
            if (value1.length == 1 && value2.length == 1 && value1[0] instanceof CssTerm && value2[0] instanceof CssTerm) {
                CssTerm term1 = (CssTerm)value1[0];
                CssTerm term2 = (CssTerm)value2[0];
                if (term1.getTermType() == CssTermTypes.COLOR && term2.getTermType() == CssTermTypes.COLOR) {
                    ColorDeclarationType color1Type = ColorDeclarationType.fromColorTerm((PsiElement)term1);
                    ColorDeclarationType color2Type = ColorDeclarationType.fromColorTerm((PsiElement)term2);
                    return !term1.getText().equalsIgnoreCase(term2.getText()) && !(color1Type.withAlphaChannel() ^ color2Type.withAlphaChannel());
                }
                if (term1.getTermType() == CssTermTypes.RECT && term2.getTermType() == CssTermTypes.RECT) {
                    boolean commaSeparatorInTerm1 = StringUtil.containsChar((String)term1.getText(), (char)',');
                    boolean commaSeparatorInTerm2 = StringUtil.containsChar((String)term2.getText(), (char)',');
                    return !term1.getText().equalsIgnoreCase(term2.getText()) && !(commaSeparatorInTerm1 ^ commaSeparatorInTerm2);
                }
                PsiElement firstTermChild = term1.getFirstChild();
                PsiElement secondTermChild = term2.getFirstChild();
                boolean bothTermsAreFunctions = firstTermChild instanceof CssFunction && secondTermChild instanceof CssFunction;
                boolean oneOfTermsIsExpression = firstTermChild instanceof CssExpression ^ secondTermChild instanceof CssExpression;
                String term1Text = term1.getText();
                String term2Text = term2.getText();
                return !term1Text.equalsIgnoreCase(term2Text) && !oneOfTermsIsExpression && (!CssPropertyUtil.isVendorSpecificElement(term1Text) && !CssPropertyUtil.isVendorSpecificElement(term2Text) || bothTermsAreFunctions && ((CssFunction)firstTermChild).getName().equalsIgnoreCase(((CssFunction)secondTermChild).getName()));
            }
            String stringValue1 = CssOverwrittenPropertiesInspection.joinedText(value1);
            return !stringValue1.equalsIgnoreCase(stringValue2 = CssOverwrittenPropertiesInspection.joinedText(value2)) && !CssPropertyUtil.isVendorSpecificElement(stringValue1) && !CssPropertyUtil.isVendorSpecificElement(stringValue2);
        }
        return false;
    }

    private static String joinedText(PsiElement[] elements) {
        StringBuilder builder = new StringBuilder();
        for (PsiElement element : elements) {
            builder.append(element.getText()).append(" ");
        }
        return builder.toString().trim();
    }

    @NotNull
    private static PsiElement[] declarationValue(CssDeclaration declaration, String propertyName) {
        if (declaration.isShorthandProperty()) {
            PsiElement[] value = declaration.getShorthandPsiValue(propertyName);
            if (value != null) {
                if (value == null) {
                    CssOverwrittenPropertiesInspection.$$$reportNull$$$0(10);
                }
                return value;
            }
        } else {
            CssTermList termList = declaration.getValue();
            if (termList != null) {
                PsiElement[] psiElementArray = termList.getChildren();
                if (psiElementArray == null) {
                    CssOverwrittenPropertiesInspection.$$$reportNull$$$0(11);
                }
                return psiElementArray;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(12);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static void updateDecls(Map<String, List<CssDeclaration>> name2decls, String name, CssDeclaration decl) {
        List<CssDeclaration> decls = name2decls.get(name);
        if (decls == null) {
            decls = new ArrayList<CssDeclaration>();
            name2decls.put(name, decls);
        }
        decls.add(decl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl1";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasEqualValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isOverwrittenValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveOverwrittenPropertyQuickfix
    extends LocalQuickFixBase {
        protected RemoveOverwrittenPropertyQuickfix() {
            super(CssBundle.message((String)"css.overwritten.properties.fix.message", (Object[])new Object[0]));
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement myPsiElement;
            if (project == null) {
                RemoveOverwrittenPropertyQuickfix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RemoveOverwrittenPropertyQuickfix.$$$reportNull$$$0(1);
            }
            if ((myPsiElement = descriptor.getPsiElement()) == null) {
                return;
            }
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{myPsiElement.getContainingFile()}).run(() -> {
                CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)myPsiElement, (Class[])new Class[]{CssDeclaration.class});
                CssBlock block = (CssBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)myPsiElement, (Class[])new Class[]{CssBlock.class});
                if (declaration != null && block != null) {
                    block.removeDeclaration(declaration);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection$RemoveOverwrittenPropertyQuickfix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

