/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetFormatter
extends FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetFormatter.class);
    private static final String PROJECT_DIR_PREFIX = PlatformUtils.getPlatformPrefix() + ".format.";
    private static final String PROJECT_DIR_SUFFIX = ".tmp";
    private static final String RESULT_MESSAGE_OK = "OK";
    private static final String RESULT_MESSAGE_FAILED = "Failed";
    private static final String RESULT_MESSAGE_NOT_SUPPORTED = "Skipped, not supported.";
    private static final String RESULT_MESSAGE_BINARY_FILE = "Skipped, binary file.";
    @NotNull
    private final String myProjectUID;
    @Nullable
    private Project myProject;
    private final MessageOutput myMessageOutput;
    @NotNull
    private CodeStyleSettings mySettings;

    public FileSetFormatter(@NotNull MessageOutput messageOutput) {
        if (messageOutput == null) {
            FileSetFormatter.$$$reportNull$$$0(0);
        }
        this.myMessageOutput = messageOutput;
        this.mySettings = new CodeStyleSettings();
        this.myProjectUID = UUID.randomUUID().toString();
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            FileSetFormatter.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
    }

    private void createProject() throws IOException {
        ProjectManagerEx projectManager2 = (ProjectManagerEx)ProjectManager.getInstance();
        File projectDir = this.createProjectDir();
        this.myProject = projectManager2.createProject(this.myProjectUID, projectDir.getPath());
        if (this.myProject != null) {
            projectManager2.openProject(this.myProject);
            CodeStyle.setMainProjectSettings((Project)this.myProject, (CodeStyleSettings)this.mySettings);
        }
    }

    private File createProjectDir() throws IOException {
        File tempDir = FileUtil.createTempDirectory((String)PROJECT_DIR_PREFIX, (String)(this.myProjectUID + PROJECT_DIR_SUFFIX));
        File projectDir = new File(tempDir.getPath() + File.separator + ".idea");
        if (projectDir.mkdirs()) {
            return projectDir;
        }
        throw new IOException("Cannot create a temporary project at " + projectDir);
    }

    private void closeProject() {
        if (this.myProject != null) {
            ProjectUtil.closeAndDispose(this.myProject);
        }
    }

    @Override
    public void processFiles() throws IOException {
        this.createProject();
        if (this.myProject != null) {
            super.processFiles();
            this.closeProject();
        }
    }

    @Override
    protected boolean processFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSetFormatter.$$$reportNull$$$0(2);
        }
        String resultMessage = RESULT_MESSAGE_OK;
        assert (this.myProject != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
        this.myMessageOutput.info("Formatting " + virtualFile.getCanonicalPath() + "...");
        if (!virtualFile.getFileType().isBinary()) {
            VirtualFile[] openFiles;
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                NonProjectFileWritingAccessProvider.allowWriting(virtualFile);
                if (psiFile != null) {
                    if (FileSetFormatter.isFormattingSupported(psiFile)) {
                        FileSetFormatter.reformatFile(this.myProject, psiFile, document);
                        FileDocumentManager.getInstance().saveDocument(document);
                    } else {
                        resultMessage = RESULT_MESSAGE_NOT_SUPPORTED;
                    }
                } else {
                    LOG.warn("Unable to get a PSI file for " + virtualFile.getPath());
                    resultMessage = RESULT_MESSAGE_FAILED;
                }
            } else {
                LOG.warn("No document available for " + virtualFile.getPath());
                resultMessage = RESULT_MESSAGE_FAILED;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
            for (VirtualFile openFile2 : openFiles = editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
        } else {
            resultMessage = RESULT_MESSAGE_BINARY_FILE;
        }
        this.myMessageOutput.info(resultMessage + "\n");
        return RESULT_MESSAGE_OK.equals(resultMessage);
    }

    private static void reformatFile(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document) {
        if (project == null) {
            FileSetFormatter.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FileSetFormatter.$$$reportNull$$$0(4);
        }
        if (document == null) {
            FileSetFormatter.$$$reportNull$$$0(5);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            if (project == null) {
                FileSetFormatter.$$$reportNull$$$0(7);
            }
            if (file2 == null) {
                FileSetFormatter.$$$reportNull$$$0(8);
            }
            if (document == null) {
                FileSetFormatter.$$$reportNull$$$0(9);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformatText(file2, 0, file2.getTextLength());
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        });
    }

    private static boolean isFormattingSupported(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileSetFormatter.$$$reportNull$$$0(6);
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageOutput";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/commandLine/FileSetFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCodeStyleSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFormattingSupported";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$reformatFile$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

