/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFilterCollectionImpl
implements VcsLogFilterCollection {
    @NotNull
    public static final VcsLogFilterCollection EMPTY = new VcsLogFilterCollectionBuilder().build();
    @NotNull
    private final Map<VcsLogFilterCollection.FilterKey, VcsLogFilter> myFilters;

    public VcsLogFilterCollectionImpl(@Nullable VcsLogBranchFilter branchFilter, @Nullable VcsLogUserFilter userFilter, @Nullable VcsLogHashFilter hashFilter, @Nullable VcsLogDateFilter dateFilter, @Nullable VcsLogTextFilter textFilter, @Nullable VcsLogStructureFilter structureFilter, @Nullable VcsLogRootFilter rootFilter) {
        this(ContainerUtil.skipNulls(Arrays.asList(branchFilter, userFilter, hashFilter, dateFilter, textFilter, structureFilter, rootFilter)));
    }

    public VcsLogFilterCollectionImpl(@NotNull Collection<? extends VcsLogFilter> filters) {
        if (filters == null) {
            VcsLogFilterCollectionImpl.$$$reportNull$$$0(0);
        }
        this.myFilters = new TreeMap<VcsLogFilterCollection.FilterKey, VcsLogFilter>(Comparator.comparing(key -> key.getName()));
        for (VcsLogFilter vcsLogFilter : filters) {
            this.myFilters.put(vcsLogFilter.getKey(), vcsLogFilter);
        }
    }

    @Nullable
    public <T extends VcsLogFilter> T get(@NotNull VcsLogFilterCollection.FilterKey<T> key) {
        if (key == null) {
            VcsLogFilterCollectionImpl.$$$reportNull$$$0(1);
        }
        return (T)this.myFilters.get(key);
    }

    @NotNull
    public Collection<VcsLogFilter> getFilters() {
        Collection<VcsLogFilter> collection = this.myFilters.values();
        if (collection == null) {
            VcsLogFilterCollectionImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public String toString() {
        return "filters: (" + this.myFilters + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VcsLogFilterCollectionBuilder {
        @NotNull
        private final Collection<VcsLogFilter> myFilters;

        public VcsLogFilterCollectionBuilder() {
            this.myFilters = new OpenTHashSet((TObjectHashingStrategy)new FilterByKeyHashingStrategy());
        }

        public VcsLogFilterCollectionBuilder(@NotNull VcsLogFilterCollection filterCollection) {
            if (filterCollection == null) {
                VcsLogFilterCollectionBuilder.$$$reportNull$$$0(0);
            }
            this.myFilters = new OpenTHashSet((TObjectHashingStrategy)new FilterByKeyHashingStrategy());
            this.myFilters.addAll(filterCollection.getFilters());
        }

        public VcsLogFilterCollectionBuilder(VcsLogFilter ... filters) {
            this.myFilters = new OpenTHashSet((TObjectHashingStrategy)new FilterByKeyHashingStrategy());
            this.myFilters.addAll(ContainerUtil.skipNulls(Arrays.asList(filters)));
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogFilter filter) {
            if (filter != null) {
                this.myFilters.remove(filter);
                this.myFilters.add(filter);
            }
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                VcsLogFilterCollectionBuilder.$$$reportNull$$$0(1);
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public <T extends VcsLogFilter> VcsLogFilterCollectionBuilder without(@NotNull VcsLogFilterCollection.FilterKey<T> key) {
            if (key == null) {
                VcsLogFilterCollectionBuilder.$$$reportNull$$$0(2);
            }
            this.myFilters.removeIf(filter -> {
                if (key == null) {
                    VcsLogFilterCollectionBuilder.$$$reportNull$$$0(5);
                }
                return filter.getKey().equals((Object)key);
            });
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                VcsLogFilterCollectionBuilder.$$$reportNull$$$0(3);
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollection build() {
            VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl(this.myFilters);
            if (vcsLogFilterCollectionImpl == null) {
                VcsLogFilterCollectionBuilder.$$$reportNull$$$0(4);
            }
            return vcsLogFilterCollectionImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterCollection";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "with";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "without";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "without";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$without$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class FilterByKeyHashingStrategy
        implements TObjectHashingStrategy<VcsLogFilter> {
            private FilterByKeyHashingStrategy() {
            }

            public int computeHashCode(@NotNull VcsLogFilter object) {
                if (object == null) {
                    FilterByKeyHashingStrategy.$$$reportNull$$$0(0);
                }
                return object.getKey().hashCode();
            }

            public boolean equals(@NotNull VcsLogFilter o1, @NotNull VcsLogFilter o2) {
                if (o1 == null) {
                    FilterByKeyHashingStrategy.$$$reportNull$$$0(1);
                }
                if (o2 == null) {
                    FilterByKeyHashingStrategy.$$$reportNull$$$0(2);
                }
                return o1.getKey().equals((Object)o2.getKey());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o2";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder$FilterByKeyHashingStrategy";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeHashCode";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "equals";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

