/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringInjectionsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.NotNull;

public abstract class JSStringTemplateConvertVisibilityOfLineSeparatorsIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    protected abstract boolean isAvailableForSeparatorsCheckResult(@NotNull SeparatorsChecker var1);

    protected abstract Convertor<String, String> createConvertor();

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(1);
        }
        JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.convert(element, this.createConvertor());
    }

    public static void convert(@NotNull PsiElement element, @NotNull Convertor<? super String, String> convertor) {
        JSStringTemplateExpression stringTemplateExpression;
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(2);
        }
        if (convertor == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(3);
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return;
        }
        if ((element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) && (stringTemplateExpression = JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.getStringTemplate(element)) != null) {
            String result2 = new NonInterpolationFragments(stringTemplateExpression.getText(), convertor).getResult();
            stringTemplateExpression.replace(JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.createReplacement(result2, (JSElement)stringTemplateExpression));
        }
    }

    private static JSStringTemplateExpression getStringTemplate(@NotNull PsiElement element) {
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(4);
        }
        return element instanceof JSStringTemplateExpression ? (JSStringTemplateExpression)element : (JSStringTemplateExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSStringTemplateExpression.class);
    }

    private static PsiElement createReplacement(@NotNull String text, JSElement context) {
        if (text == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(5);
        }
        JSVarStatement statement = JSChangeUtil.createStatementPsiFromTextWithContext("var me = " + text + ";", (PsiElement)context, JSVarStatement.class);
        return statement.getVariables()[0].getInitializer();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSStringTemplateExpression stringTemplateExpression;
        if (project == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(7);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        if ((element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) && (stringTemplateExpression = JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.getStringTemplate(element)) != null) {
            return this.isAvailableForSeparatorsCheckResult(new SeparatorsChecker(stringTemplateExpression.getText()));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createReplacement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NonInterpolationFragments
    extends StringInjectionsProcessor {
        private final StringBuilder mySb;
        @NotNull
        private final Convertor<? super String, String> myConvertor;

        NonInterpolationFragments(@NotNull String text, @NotNull Convertor<? super String, String> convertor) {
            if (text == null) {
                NonInterpolationFragments.$$$reportNull$$$0(0);
            }
            if (convertor == null) {
                NonInterpolationFragments.$$$reportNull$$$0(1);
            }
            super("${", "}", text);
            this.myConvertor = convertor;
            this.mySb = new StringBuilder();
            this.process();
        }

        protected boolean onText(@NotNull String text) {
            if (text == null) {
                NonInterpolationFragments.$$$reportNull$$$0(2);
            }
            this.mySb.append((String)this.myConvertor.convert((Object)text));
            return true;
        }

        protected boolean onInjection(@NotNull String injection) {
            if (injection == null) {
                NonInterpolationFragments.$$$reportNull$$$0(3);
            }
            this.mySb.append(injection);
            return true;
        }

        public String getResult() {
            return this.mySb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$NonInterpolationFragments";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onInjection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class SeparatorsChecker
    extends StringInjectionsProcessor {
        private boolean myHaveVisible;
        private boolean myHaveInvisible;

        public SeparatorsChecker(@NotNull String text) {
            if (text == null) {
                SeparatorsChecker.$$$reportNull$$$0(0);
            }
            super("${", "}", text);
            this.process();
        }

        protected boolean onText(@NotNull String text) {
            if (text == null) {
                SeparatorsChecker.$$$reportNull$$$0(1);
            }
            this.myHaveInvisible = text.contains("\n");
            this.myHaveVisible = text.contains("\\n");
            return !this.myHaveInvisible || !this.myHaveVisible;
        }

        protected boolean onInjection(@NotNull String injection) {
            if (injection == null) {
                SeparatorsChecker.$$$reportNull$$$0(2);
            }
            return true;
        }

        public boolean isHaveVisible() {
            return this.myHaveVisible;
        }

        public boolean isHaveInvisible() {
            return this.myHaveInvisible;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$SeparatorsChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onInjection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

