/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceProcessConnector;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUsagesCollector;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSAsyncLanguageServiceBase
implements Disposable {
    private static final long ALIVE_CHECK_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final int ALIVE_CHECK_COUNT_BEFORE_LONG_WAITING = 5;
    public static final String CONSOLE_ID = "Console";
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final JSLanguageServiceToolWindowManager myToolWindowManager;
    protected final AtomicLong myFailCount;
    @NotNull
    protected final Alarm myCheckAliveAlarm;
    @NotNull
    private volatile ThreeState myCanStartProcess;
    @Nullable
    protected volatile JSLanguageServiceExecutor myService;
    @NotNull
    private final Object myLock;
    @NotNull
    private final AtomicNullableLazyValue<Void> myInitialization;
    @Nullable
    protected final JSLanguageServiceQueue.ProcessConnector myProcessConnector;

    public JSAsyncLanguageServiceBase(@NotNull Project project) {
        if (project == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(0);
        }
        this(project, CONSOLE_ID);
    }

    public JSAsyncLanguageServiceBase(@NotNull Project project, @NotNull String consoleId) {
        if (project == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(2);
        }
        this.myFailCount = new AtomicLong();
        this.myCanStartProcess = ThreeState.UNSURE;
        this.myLock = new Object();
        this.myInitialization = AtomicNullableLazyValue.createValue(() -> {
            this.initializeOnce();
            return null;
        });
        this.myProject = project;
        this.myToolWindowManager = this.createToolWindow(project);
        this.myCheckAliveAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProcessConnector = this.myToolWindowManager != null ? new JSLanguageServiceProcessConnector(consoleId, this.myToolWindowManager) : null;
    }

    @NotNull
    public ThreeState getCanStartProcessState() {
        ThreeState threeState = this.myCanStartProcess;
        if (threeState == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    public void setCanStartProcessState(@NotNull ThreeState canStartProcess) {
        if (canStartProcess == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(4);
        }
        this.myCanStartProcess = canStartProcess;
    }

    @NotNull
    protected JSLanguageServiceQueue.ServiceInfoReporter createDefaultReporter() {
        if (this.myToolWindowManager != null) {
            JSLanguageServiceToolWindowInfoReporter jSLanguageServiceToolWindowInfoReporter = new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, false);
            if (jSLanguageServiceToolWindowInfoReporter == null) {
                JSAsyncLanguageServiceBase.$$$reportNull$$$0(5);
            }
            return jSLanguageServiceToolWindowInfoReporter;
        }
        JSLanguageServiceQueue.ServiceInfoReporter serviceInfoReporter = new JSLanguageServiceQueue.ServiceInfoReporter(){

            @Override
            @NotNull
            public String getServiceName() {
                String string = JSAsyncLanguageServiceBase.this.getProcessName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void logError(@NotNull String error) {
                if (error == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSLanguageServiceQueue.DEFAULT_REPORTER.logError(error);
            }

            @Override
            public void setProcess(@Nullable String text) {
                JSLanguageServiceQueue.DEFAULT_REPORTER.setProcess(text);
            }

            @Override
            public void logCurrentErrors(@NotNull List<JSAnnotationError> results) {
                if (results == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSLanguageServiceQueue.DEFAULT_REPORTER.logCurrentErrors(results);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "results";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getServiceName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "logError";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "logCurrentErrors";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (serviceInfoReporter == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(6);
        }
        return serviceInfoReporter;
    }

    protected long getAliveCheckTimeout() {
        return ALIVE_CHECK_TIMEOUT;
    }

    protected long getAliveCheckLongTimeout() {
        return this.getAliveCheckTimeout() * 10L;
    }

    protected int getAliveCheckCount() {
        return 5;
    }

    protected void initializeOnce() {
        JSLanguageServiceQueue.LOGGER.trace("Run initialize once");
        JSLanguageServiceUsagesCollector.triggerServiceUsed(this.myProject, this.getClass());
        this.createAliveChecker().run();
        this.initToolWindow();
    }

    public final void initialize() {
        ReadAction.run(() -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myInitialization.getValue();
            }
        });
    }

    @NotNull
    protected final Runnable createAliveChecker() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JSAsyncLanguageServiceBase.this.checkAlive(this);
            }
        };
        if (runnable == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    @NotNull
    protected String getProcessName() {
        if ("Language" == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(8);
        }
        return "Language";
    }

    @Nullable
    protected abstract JSLanguageServiceExecutor createLanguageServiceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkAlive(@NotNull Runnable self) {
        if (self == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(9);
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        JSLanguageServiceQueue.LOGGER.trace("Check alive is called");
        JSLanguageServiceExecutor serviceQueue = this.myService;
        if (serviceQueue != null) {
            Object object = this.myLock;
            synchronized (object) {
                JSLanguageServiceExecutor service = this.myService;
                if (service != null && !this.checkServiceQueueAliveUnderLock(service)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        JSLanguageServiceQueue.LOGGER.trace("Dispose by alive checker");
                        this.terminateStartedProcessImpl(false, false);
                    });
                }
            }
        } else if (!this.checkCanUseService()) {
            if (this.myCanStartProcess == ThreeState.NO) {
                this.myFailCount.incrementAndGet();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                JSLanguageServiceQueue.LOGGER.trace("Initialize by alive checker");
                this.initializeServiceQueue();
            });
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        long timeout = this.getAliveCheckTimeout();
        if (this.myFailCount.get() > (long)this.getAliveCheckCount()) {
            timeout = this.getAliveCheckLongTimeout();
        }
        this.myCheckAliveAlarm.addRequest(self, timeout);
    }

    protected boolean checkServiceQueueAliveUnderLock(@NotNull JSLanguageServiceExecutor serviceQueue) {
        if (serviceQueue == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(10);
        }
        JSLanguageServiceQueue.LOGGER.trace("Check alive process queue " + serviceQueue.hashCode());
        JSLanguageServiceExecutor.State state = serviceQueue.getState();
        if (!serviceQueue.isValid()) {
            this.myFailCount.incrementAndGet();
            return false;
        }
        if (state == JSLanguageServiceExecutor.State.STARTED) {
            this.myFailCount.set(0L);
        }
        return true;
    }

    protected abstract boolean needInitToolWindow();

    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        return null;
    }

    @Nullable
    protected JSLanguageServiceExecutor getProcess() {
        JSLanguageServiceExecutor toReturn = this.myService;
        if (toReturn != null) {
            return toReturn;
        }
        return (JSLanguageServiceExecutor)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return this.computeProcessUnderLocks();
            }
        });
    }

    @Nullable
    protected final JSLanguageServiceExecutor computeProcessUnderLocks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue.LOGGER.trace("Run compute process under locks");
        JSLanguageServiceExecutor service = this.myService;
        if (service == null) {
            if (this.myProject.isDisposed()) {
                return null;
            }
            this.myInitialization.getValue();
            this.myService = service = this.createLanguageServiceQueue();
        }
        return service;
    }

    protected final void initializeServiceQueue() {
        this.getProcess();
    }

    protected JSLanguageServiceExecutor getLSProcess() {
        return this.myService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLanguageService(@Nullable JSLanguageServiceExecutor service) {
        Object object = this.myLock;
        synchronized (object) {
            this.myService = service;
        }
    }

    public final void terminateStartedProcess(boolean recreateToolWindow) {
        this.terminateStartedProcess(recreateToolWindow, false);
    }

    public final void terminateStartedProcess(boolean recreateToolWindow, boolean closeAssociatedConsoleView) {
        this.resetState();
        this.terminateStartedProcessImpl(recreateToolWindow, closeAssociatedConsoleView);
    }

    protected void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed() || !this.myProject.isOpen() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myToolWindowManager.lazyInit((Condition<JSLanguageServiceToolWindowManager>)((Condition)el -> this.needInitToolWindow()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateStartedProcessImpl(boolean recreateToolWindow, boolean closeAssociatedConsoleView) {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceToolWindowManager manager = this.myToolWindowManager;
            if (this.myProcessConnector != null) {
                this.myProcessConnector.disconnectFromProcessHandler(closeAssociatedConsoleView);
                JSLanguageServiceExecutor service = this.myService;
                if (manager != null && service != null && service.getState() == JSLanguageServiceExecutor.State.STARTED) {
                    manager.cleanErrorsPanel();
                }
            }
            if (manager != null) {
                if (recreateToolWindow) {
                    manager.resetToolWindow();
                } else {
                    manager.partiallyResetToolWindow();
                }
            }
            this.disposeQueue();
            this.initToolWindow();
        }
    }

    protected Runnable getDisposeQueueRunnableUnderLock(@NotNull JSLanguageServiceExecutor serviceToDispose) {
        if (serviceToDispose == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(11);
        }
        return () -> {
            if (serviceToDispose == null) {
                JSAsyncLanguageServiceBase.$$$reportNull$$$0(13);
            }
            this.disposeQueueImpl(serviceToDispose);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disposeQueue() {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceExecutor service = this.myService;
            if (service != null) {
                JSLanguageServiceQueue.LOGGER.trace("Dispose queue by direct dispose call " + service.hashCode());
                this.myService = null;
                this.myCanStartProcess = ThreeState.UNSURE;
                Runnable disposeAction = this.getDisposeQueueRunnableUnderLock(service);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    disposeAction.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(disposeAction);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeQueueImpl(@NotNull JSLanguageServiceExecutor service) {
        if (service == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            Disposer.dispose((Disposable)service);
        }
    }

    public boolean checkCanUseService() {
        return this.myCanStartProcess != ThreeState.NO && this.myFailCount.get() < (long)this.getAliveCheckCount();
    }

    protected void resetState() {
        this.myFailCount.set(0L);
        this.myCanStartProcess = ThreeState.UNSURE;
    }

    public void dispose() {
        JSLanguageServiceExecutor queue = this.myService;
        if (queue != null) {
            Disposer.dispose((Disposable)queue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canStartProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceQueue";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceToDispose";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanStartProcessState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultReporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAliveChecker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCanStartProcessState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkAlive";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceQueueAliveUnderLock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDisposeQueueRunnableUnderLock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disposeQueueImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDisposeQueueRunnableUnderLock$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

