/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.ws.actions.OpenInScratchFileAction;
import com.intellij.ws.rest.client.RESTCookiesPanel;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientController;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientCustomActionsProvider;
import com.intellij.ws.rest.client.RestClientDataProvider;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestPanel;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponseListener;
import com.intellij.ws.rest.client.RestClientSerializer;
import com.intellij.ws.rest.client.RestClientSettings;
import com.intellij.ws.rest.client.UsernamePasswordForm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.apache.http.cookie.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RESTClient
implements RestClientResponseListener,
Disposable {
    private final Project myProject;
    private TextFieldWithHistory myHttpMethod;
    private ComboBox myURL;
    private VirtualFile myResponseFile;
    private EditorEx myResponse;
    private FileType mySelectedResponseFileType = PlainTextFileType.INSTANCE;
    private final Ref<FileType> myFileTypeFromResponse = new Ref((Object)PlainTextFileType.INSTANCE);
    private final Set<FileType> myBuiltinFileTypes = new HashSet<FileType>();
    private JPanel myMainPanel;
    private final EditorTextField myHeader;
    private JTextField myURLBase;
    private final JLabel myStatus;
    private final JPanel myResponseTab;
    private JPanel myMainToolbarPlaceholder;
    private JPanel myRequestPanel;
    private JPanel myTabsPlaceholder;
    private JTextField myURLTextField;
    private final RestClientController myController;
    private final JPanel myWrappedMainPanel = new RestHelpWrapper();
    private final RestClientRequestPanel myClientRequestPanel;
    private boolean myHaveURLTemplates;
    private final RESTCookiesPanel myCookiesPanel;
    private final JBTabs myTabs;
    private final DumbAwareAction myReformatAction;

    public RESTClient(Project project) {
        this.myProject = project;
        this.myController = new RestClientControllerImpl(project);
        this.myResponseTab = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myClientRequestPanel = new RestClientRequestPanel(project, this);
        this.myCookiesPanel = new RESTCookiesPanel(project, this);
        this.myReformatAction = new ReformatAction();
        this.layoutMainComponents();
        this.initUIComponents();
        this.myRequestPanel.setBorder((Border)JBUI.Borders.emptyTop((int)2));
        this.myWrappedMainPanel.add(this.myMainPanel);
        this.myHeader = new MyEditorTextField(this.myProject, true);
        this.myTabs = new JBRunnerTabs(project, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project), (Disposable)project);
        this.myTabs.getPresentation().setInnerInsets((Insets)JBUI.emptyInsets()).setPaintBorder(0, 0, 0, 0).setPaintFocus(false).setRequestFocusOnLastFocusedComponent(true);
        this.myTabs.getComponent().setBorder((Border)JBUI.Borders.emptyLeft((int)1));
        this.myTabs.addTab(new TabInfo((JComponent)this.myClientRequestPanel).setText("Request"));
        this.myTabs.addTab(new TabInfo((JComponent)this.myCookiesPanel).setText("Cookies"));
        this.myTabs.addTab(new TabInfo((JComponent)this.myResponseTab).setText("Response"));
        this.myTabs.addTab(new TabInfo((JComponent)this.myHeader).setText("Response Headers"));
        this.myTabsPlaceholder.add((Component)this.myTabs.getComponent(), "Center");
        this.createMainToolbar();
        this.createResponseToolbar();
        this.myStatus = new JLabel();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myStatus);
        this.myResponseTab.add("South", this.myStatus);
        this.myHttpMethod.addActionListener(event -> this.updateBodyEnabled());
        List<RestClientRequest> history = RestClientSettings.getInstance((Project)project).REQUEST_HISTORY;
        if (history.size() > 0) {
            this.loadRequestFromHistory(history.get(0));
        }
        this.updateBodyEnabled();
        this.myClientRequestPanel.updateFileEnabled();
    }

    private void layoutMainComponents() {
        this.myMainPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0, gap 0"));
        this.myURL = new ComboBox();
        this.myURLBase = new JBTextField("http://localhost:8080/resources");
        this.myURLTextField = new JBTextField();
        this.myHttpMethod = this.createHttpMethod();
        this.myTabsPlaceholder = new JPanel(new BorderLayout());
        this.myMainToolbarPlaceholder = new JPanel(new BorderLayout());
        this.myRequestPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0 0 3 0", "[min!][][grow]"));
        this.myMainPanel.add((Component)this.myTabsPlaceholder, "grow");
        this.myMainPanel.add((Component)this.myMainToolbarPlaceholder, "dock west, w pref!");
        JPanel deprecatedPanel = new JPanel(new FlowLayout(1));
        this.myMainPanel.add((Component)deprecatedPanel, "dock north");
        this.myMainPanel.add((Component)this.myRequestPanel, "dock north");
        this.myRequestPanel.add(new JLabel("HTTP method:"));
        this.myRequestPanel.add((Component)this.myHttpMethod);
        JPanel hostPane = new JPanel((LayoutManager)new MigLayout("ins 0 0 0 3, fillx", "[min!][grow]"));
        JPanel pathPane = new JPanel((LayoutManager)new MigLayout("ins 0 3 0 0, fillx", "[min!][grow]"));
        JPanel urlPane = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, hidemode 3"));
        urlPane.add((Component)this.myURLTextField, "growx");
        urlPane.add((Component)this.myURL, "growx");
        hostPane.add(new JLabel("Host/port:"));
        hostPane.add((Component)this.myURLBase, "wmin 100, growx");
        pathPane.add(new JLabel("Path:"));
        pathPane.add((Component)urlPane, "wmin 100, growx");
        OnePixelSplitter onePixelSplitter = new OnePixelSplitter(false, 0.25f);
        onePixelSplitter.setFirstComponent((JComponent)hostPane);
        onePixelSplitter.setSecondComponent((JComponent)pathPane);
        this.myRequestPanel.add((Component)onePixelSplitter, "grow");
        deprecatedPanel.setBorder((Border)IdeBorderFactory.createRoundedBorder((int)0));
        deprecatedPanel.setBackground(UIUtil.getToolTipBackground());
        deprecatedPanel.add(new JLabel(RestClientBundle.message("rest.clien.ui.deprecation.message", new Object[0])));
        ActionLink openInScratch = new ActionLink(RestClientBundle.message("rest.clien.ui.deprecation.convert.action", new Object[0]), (AnAction)new OpenInScratchFileAction((Producer<? extends RestClientRequest>)((Producer)() -> this.createRequest())));
        deprecatedPanel.add((Component)openInScratch);
    }

    private void updateBodyEnabled() {
        String item = (String)this.myHttpMethod.getSelectedItem();
        this.myClientRequestPanel.setCanHasBody("POST".equals(item) || "PUT".equals(item) || "PATCH".equals(item));
    }

    private void createMainToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        DumbAwareAction submitRequestAction = new DumbAwareAction("Submit Request", "", AllIcons.Actions.Execute){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RESTClient.this.onGoToUrlAction(new RestClientRequestProcessor[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$1", "actionPerformed"));
            }
        };
        submitRequestAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, (JComponent)this.myMainPanel);
        group.add((AnAction)submitRequestAction);
        for (RestClientCustomActionsProvider provider : RestClientCustomActionsProvider.EP_NAME.getExtensionList()) {
            group.addAll(provider.getCustomActions(this));
        }
        group.add((AnAction)new DumbAwareAction("Update resource paths from code", "", AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RESTClient.this.updateResourcePaths();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setVisible(RestClientDataProvider.EP_NAME.hasAnyExtensions());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ws/rest/client/RESTClient$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        RequestHistoryAction historyAction = new RequestHistoryAction();
        historyAction.registerCustomShortcutSet(CommonShortcuts.getRecentFiles(), this.myMainPanel);
        group.add((AnAction)historyAction);
        group.add((AnAction)new ExportRequestAction());
        group.add((AnAction)new ImportRequestAction());
        group.add((AnAction)new GenerateAuthAction());
        group.add((AnAction)new ConfigureProxyAction());
        group.add((AnAction)new DumbAwareAction("Close", null, AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)RESTClient.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$3", "actionPerformed"));
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RestClient", (ActionGroup)group, false);
        this.myMainToolbarPlaceholder.add((Component)toolbar.getComponent(), "West");
    }

    private void updateResourcePaths() {
        HashSet<String> allPaths = new HashSet<String>();
        for (RestClientDataProvider provider : RestClientDataProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(allPaths, (Object[])provider.getAllPaths(this.myProject));
        }
        this.setURLTemplates(allPaths);
        this.myClientRequestPanel.updateHeaderEditor();
    }

    private void createResponseToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myReformatAction);
        group.add((AnAction)new OpenInBrowserAction());
        group.add((AnAction)new HighlightAction(this, "View as text", "PLAIN_TEXT", AllIcons.FileTypes.Text));
        group.add((AnAction)new HighlightAction(this, "View as HTML", "HTML", AllIcons.FileTypes.Html));
        group.add((AnAction)new HighlightAction(this, "View as XML", "XML", AllIcons.FileTypes.Xml));
        group.add((AnAction)new HighlightAction(this, "View as JSON", "JSON", AllIcons.FileTypes.Json));
        group.add((AnAction)new HighlightAction(this, "View according to MIME type", this.myFileTypeFromResponse, AllIcons.FileTypes.Custom));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RestClientResponseToolbar", (ActionGroup)group, false);
        this.myResponseTab.add((Component)toolbar.getComponent(), "West");
    }

    @NotNull
    private RestClientRequest createRequest() {
        RestClientRequest request = this.getRequest();
        this.myClientRequestPanel.saveToRequest(request);
        this.myCookiesPanel.saveToRequest(request);
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            RESTClient.$$$reportNull$$$0(0);
        }
        return restClientRequest;
    }

    public String getRequestURL() {
        return this.getRequest().getURL();
    }

    @NotNull
    private RestClientRequest getRequest() {
        RestClientRequest request = new RestClientRequest();
        request.httpMethod = this.getHttpMethod();
        request.urlBase = this.myURLBase.getText();
        request.urlPath = this.getURL();
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            RESTClient.$$$reportNull$$$0(1);
        }
        return restClientRequest;
    }

    private String getURL() {
        if (this.myHaveURLTemplates) {
            return (String)this.myURL.getEditor().getItem();
        }
        return this.myURLTextField.getText();
    }

    private void loadRequestFromHistory(RestClientRequest request) {
        this.myHttpMethod.setSelectedItem((Object)request.httpMethod);
        this.myURLBase.setText(request.urlBase);
        this.setURL(request.urlPath);
        this.myClientRequestPanel.loadFromRequest(request);
        this.myCookiesPanel.loadFromRequest(request);
        this.myTabs.select(this.myTabs.getTabAt(0), false);
    }

    private void setURL(String path) {
        if (this.myHaveURLTemplates) {
            this.myURL.getEditor().setItem(path);
        } else {
            this.myURLTextField.setText(path);
        }
    }

    public void setURLTemplates(Set<String> templates) {
        this.myHaveURLTemplates = !templates.isEmpty();
        this.myURL.setVisible(this.myHaveURLTemplates);
        this.myURLTextField.setVisible(!this.myHaveURLTemplates);
        if (!templates.isEmpty()) {
            this.myURL.removeAllItems();
            for (String template : templates) {
                this.myURL.addItem((Object)template);
            }
            this.myURL.addItem((Object)"/application.wadl");
        }
    }

    private String getResponse() {
        return this.myResponse.getDocument().getText();
    }

    private void updateEditor(Document document, FileType fileType) {
        if (this.myResponse != null) {
            this.myReformatAction.unregisterCustomShortcutSet(this.myResponse.getComponent());
            this.myResponseTab.remove(this.myResponse.getComponent());
            EditorFactory.getInstance().releaseEditor((Editor)this.myResponse);
        }
        this.myResponse = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, fileType, true);
        this.disableHighlighting(document);
        this.myResponse.getSettings().setUseSoftWraps(true);
        this.myResponse.getSettings().setLineMarkerAreaShown(false);
        this.myResponse.getSettings().setLineNumbersShown(false);
        this.myReformatAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ReformatCode").getShortcutSet(), this.myResponse.getComponent(), (Disposable)this);
        this.myResponseTab.add((Component)this.myResponse.getComponent(), "Center");
        this.myResponseTab.validate();
    }

    private void disableHighlighting(Document document) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile != null) {
            HighlightingSettingsPerFile.getInstance((Project)this.myProject).setHighlightingSettingForRoot((PsiElement)psiFile, FileHighlightingSetting.SKIP_INSPECTION);
        }
    }

    public String getHttpMethod() {
        return (String)this.myHttpMethod.getSelectedItem();
    }

    private TextFieldWithHistory createHttpMethod() {
        TextFieldWithStoredHistory textFieldWithHistory = new TextFieldWithStoredHistory("RESTClient.httpMethod");
        textFieldWithHistory.setHistorySize(15);
        ArrayList<String> newHistory = new ArrayList<String>(Arrays.asList("GET", "POST", "PUT", "PATCH", "DELETE", "HEAD", "OPTIONS"));
        for (String method : textFieldWithHistory.getHistory()) {
            if (newHistory.contains(method)) continue;
            newHistory.add(method);
        }
        textFieldWithHistory.setHistory(newHistory);
        textFieldWithHistory.setSelectedIndex(0);
        return textFieldWithHistory;
    }

    private void initUIComponents() {
        this.myURLBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                RESTClient.this.myURLBase.setBackground(RESTClient.this.myController.isValidURL(RESTClient.this.myURLBase.getText()) ? UIUtil.getTextFieldBackground() : new JBColor((Color)JBColor.PINK, new Color(75, 34, 27)));
            }
        });
        KeyAdapter enterListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.getKeyCode() == 10) {
                    RESTClient.this.onGoToUrlAction(new RestClientRequestProcessor[0]);
                }
            }
        };
        this.myURLBase.addKeyListener(enterListener);
        this.myURL.getEditor().getEditorComponent().addKeyListener(enterListener);
        this.myURLTextField.addKeyListener(enterListener);
        this.updateResourcePaths();
        this.myURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int end;
                int start;
                String s = (String)RESTClient.this.myURL.getSelectedItem();
                if (s == null) {
                    return;
                }
                if (s.contains("{") && s.contains("}") && (start = s.indexOf("{")) < (end = s.indexOf("}"))) {
                    ((JTextField)RESTClient.this.myURL.getEditor().getEditorComponent()).setSelectionStart(start);
                    ((JTextField)RESTClient.this.myURL.getEditor().getEditorComponent()).setSelectionEnd(end + 1);
                }
            }
        });
        this.updateEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.mySelectedResponseFileType);
    }

    public void onGoToUrlAction(RestClientRequestProcessor ... processors) {
        if (processors == null) {
            RESTClient.$$$reportNull$$$0(2);
        }
        this.myClientRequestPanel.stopEditing();
        this.splitParameters();
        this.myTabs.select(this.myTabs.getTabAt(2), false);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myResponse.getContentComponent(), true));
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myController.onGoButtonClick(this.createRequest(), true, this, processors);
        this.myHttpMethod.addCurrentTextToHistory();
    }

    private void splitParameters() {
        URI uri;
        try {
            uri = new URI(this.myURLBase.getText());
        }
        catch (URISyntaxException ex) {
            return;
        }
        String path = uri.getPath();
        if (!StringUtil.isEmpty((String)path)) {
            String query;
            if (!"/".equals(path) || StringUtil.isEmpty((String)this.getURL())) {
                this.setURL(path);
            }
            if ((query = uri.getQuery()) != null) {
                this.addParameters(query);
            }
            try {
                URI uriWithoutPath = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null);
                this.myURLBase.setText(uriWithoutPath.toString());
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            path = this.getURL();
            int queryStart = path.indexOf(63);
            if (queryStart > 0) {
                this.addParameters(path.substring(queryStart + 1));
                this.setURL(path.substring(0, queryStart));
            }
        }
    }

    private void addParameters(String query) {
        for (String s : StringUtil.split((String)query, (String)"&")) {
            int pos = s.indexOf(61);
            if (pos <= 0) continue;
            this.myClientRequestPanel.addRequestParameter(s.substring(0, pos), s.substring(pos + 1));
        }
    }

    public JComponent getComponent() {
        return this.myWrappedMainPanel;
    }

    public void dispose() {
        if (this.myResponse != null && !this.myResponse.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myResponse);
        }
        RestClientFileUtil.deleteFile(this.myResponseFile);
    }

    @Override
    public void onStart() {
        this.onResponse(null, "", "text/plain", "");
    }

    @Override
    public void onErrorResponse(String response) {
        this.onResponse(null, response, "text/plain", "");
    }

    @Override
    public void onResponse(@Nullable String header, @NotNull String response, @Nullable String mimeType, @NotNull String status) {
        if (response == null) {
            RESTClient.$$$reportNull$$$0(3);
        }
        if (status == null) {
            RESTClient.$$$reportNull$$$0(4);
        }
        this.myHeader.setText(header == null ? "" : header);
        FileType fileType = RestClientFileUtil.findFileType(mimeType);
        RestClientFileUtil.deleteFile(this.myResponseFile);
        this.myResponseFile = RestClientFileUtil.createFile(response, fileType);
        this.updateEditor(FileDocumentManager.getInstance().getDocument(this.myResponseFile), fileType);
        this.mySelectedResponseFileType = fileType;
        this.myFileTypeFromResponse.set((Object)fileType);
        this.myStatus.setText(status);
    }

    @Override
    public void onSetCookies(Collection<Cookie> cookies) {
        this.myCookiesPanel.setCookies(cookies);
    }

    public void importRequest(VirtualFile file) {
        try {
            this.loadRequestFromHistory(RestClientSerializer.loadFromFile(file));
        }
        catch (RestClientSerializer.RestClientSerializationException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Error Loading Request");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/RESTClient";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/RESTClient";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onGoToUrlAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ReformatAction
    extends DumbAwareAction {
        ReformatAction() {
            super("Reformat response", null, AllIcons.Actions.ToggleSoftWrap);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReformatAction.$$$reportNull$$$0(0);
            }
            PsiFile file = PsiManager.getInstance((Project)RESTClient.this.myProject).findFile(RESTClient.this.myResponseFile);
            new ReformatCodeProcessor(RESTClient.this.myProject, new PsiFile[]{file}, "Reformat response", null, false).run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ReformatAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(e.getProject() != null && RESTClient.this.myResponse.getDocument().getTextLength() > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ws/rest/client/RESTClient$ReformatAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyEditorTextField
    extends EditorTextField {
        MyEditorTextField(Project project, boolean viewer) {
            super(EditorFactory.getInstance().createDocument((CharSequence)""), project, (FileType)PlainTextFileType.INSTANCE, viewer, false);
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.getSettings().setUseSoftWraps(true);
            editor.setVerticalScrollbarVisible(true);
            return editor;
        }
    }

    private class ImportRequestAction
    extends DumbAwareAction {
        private ImportRequestAction() {
            super("Import Request", "Load request from an .xml file", AllIcons.ToolbarDecorator.Import);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportRequestAction.$$$reportNull$$$0(0);
            }
            FileTypeDescriptor descriptor = new FileTypeDescriptor("Select .xml File with REST Client Request", new String[]{"xml"});
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, (Component)RESTClient.this.myMainPanel, (VirtualFile)RESTClient.this.myProject.getBaseDir(), (Consumer)new FileChooser.FileChooserConsumer(){

                public void consume(List<VirtualFile> files) {
                    if (files.size() > 0) {
                        RESTClient.this.importRequest(files.get(0));
                    }
                }

                public void cancelled() {
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ImportRequestAction", "actionPerformed"));
        }
    }

    private class ExportRequestAction
    extends DumbAwareAction {
        private ExportRequestAction() {
            super("Export Request", "Save current request to .xml file", AllIcons.ToolbarDecorator.Export);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileSaverDialog dialog;
            VirtualFileWrapper file;
            if (e == null) {
                ExportRequestAction.$$$reportNull$$$0(0);
            }
            if ((file = (dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Request as XML", "", new String[]{"xml"}), ExportRequestAction.getEventProject((AnActionEvent)e))).save(null, null)) != null) {
                try {
                    RestClientSerializer.saveToFile(RESTClient.this.createRequest(), file.getFile());
                }
                catch (RestClientSerializer.RestClientSerializationException e1) {
                    Messages.showErrorDialog((Project)RESTClient.this.myProject, (String)e1.getMessage(), (String)"Export Request Failed");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ExportRequestAction", "actionPerformed"));
        }
    }

    private class RequestHistoryAction
    extends DumbAwareAction {
        private RequestHistoryAction() {
            super("Replay Recent Requests", "Show and replay recently executed requests", AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Component c;
            if (e == null) {
                RequestHistoryAction.$$$reportNull$$$0(0);
            }
            List<RestClientRequest> history = RestClientSettings.getInstance((Project)((RESTClient)RESTClient.this).myProject).REQUEST_HISTORY;
            BaseListPopupStep<RestClientRequest> step = new BaseListPopupStep<RestClientRequest>("Recent Requests", history){

                public PopupStep onChosen(RestClientRequest selectedValue, boolean finalChoice) {
                    RESTClient.this.loadRequestFromHistory(selectedValue);
                    return FINAL_CHOICE;
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            InputEvent event = e.getInputEvent();
            Component component = c = event != null ? event.getComponent() : null;
            if (c != null) {
                popup.showUnderneathOf(c);
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RequestHistoryAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(RestClientSettings.getInstance((Project)((RESTClient)RESTClient.this).myProject).REQUEST_HISTORY.size() > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ws/rest/client/RESTClient$RequestHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GenerateAuthAction
    extends DumbAwareAction {
        private GenerateAuthAction() {
            super("Generate 'Authorization' Header", "Generates a header for HTTP basic authorization from a username and a password", AllIcons.Nodes.SecurityRole);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            UsernamePasswordForm form;
            if (e == null) {
                GenerateAuthAction.$$$reportNull$$$0(0);
            }
            if ((form = new UsernamePasswordForm(RESTClient.this.myMainPanel)).showAndGet()) {
                String decoded = form.getUsername() + ":" + form.getPassword();
                String encoded = Base64.getEncoder().encodeToString(decoded.getBytes(StandardCharsets.UTF_8));
                RESTClient.this.myClientRequestPanel.setHeader("Authorization", "Basic " + encoded);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$GenerateAuthAction", "actionPerformed"));
        }
    }

    private static class RestHelpWrapper
    extends JPanel
    implements TypeSafeDataProvider {
        RestHelpWrapper() {
            super(new BorderLayout());
        }

        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                RestHelpWrapper.$$$reportNull$$$0(0);
            }
            if (sink == null) {
                RestHelpWrapper.$$$reportNull$$$0(1);
            }
            if (PlatformDataKeys.HELP_ID.equals(key)) {
                sink.put(key, (Object)"reference.tool.windows.rest.client");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sink";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ws/rest/client/RESTClient$RestHelpWrapper";
            objectArray[2] = "calcData";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class OpenInBrowserAction
    extends DumbAwareAction {
        private OpenInBrowserAction() {
            super("Open in Browser", "Open response content in browser", AllIcons.Nodes.PpWeb);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenInBrowserAction.$$$reportNull$$$0(0);
            }
            RESTClient.this.myController.openResponseInBrowser(RESTClient.this.getResponse());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenInBrowserAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(e.getProject() != null && RESTClient.this.myResponse.getDocument().getTextLength() > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ws/rest/client/RESTClient$OpenInBrowserAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HighlightAction
    extends ToggleAction
    implements DumbAware {
        private final Ref<FileType> myFileType;
        final /* synthetic */ RESTClient this$0;

        HighlightAction(RESTClient rESTClient, @NotNull String text, String fileType, Icon icon) {
            if (fileType == null) {
                HighlightAction.$$$reportNull$$$0(0);
            }
            this(rESTClient, text, (Ref<FileType>)Ref.create((Object)FileTypeManager.getInstance().findFileTypeByName(fileType)), icon);
        }

        HighlightAction(RESTClient rESTClient, @NotNull String text, Ref<FileType> fileType, Icon icon) {
            if (fileType == null) {
                HighlightAction.$$$reportNull$$$0(1);
            }
            this.this$0 = rESTClient;
            super(text, null, icon);
            this.myFileType = fileType;
            if (!this.isMimeTypeRef(fileType)) {
                rESTClient.myBuiltinFileTypes.add(fileType.get());
            }
        }

        private FileType getFileType() {
            return (FileType)this.myFileType.get();
        }

        private boolean isMimeTypeRef(Ref<FileType> fileType) {
            return fileType == this.this$0.myFileTypeFromResponse;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HighlightAction.$$$reportNull$$$0(2);
            }
            return this.this$0.mySelectedResponseFileType == this.getFileType();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                HighlightAction.$$$reportNull$$$0(3);
            }
            if (!state) {
                return;
            }
            RestClientFileUtil.deleteFile(this.this$0.myResponseFile);
            FileType fileType = this.getFileType();
            this.this$0.myResponseFile = RestClientFileUtil.createFile(this.this$0.myResponse.getDocument().getText(), fileType);
            this.this$0.updateEditor(FileDocumentManager.getInstance().getDocument(this.this$0.myResponseFile), fileType);
            this.this$0.mySelectedResponseFileType = fileType;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HighlightAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabled(e.getProject() != null && this.this$0.myResponse.getDocument().getTextLength() > 0);
            if (this.isMimeTypeRef(this.myFileType)) {
                e.getPresentation().setVisible(!this.this$0.myBuiltinFileTypes.contains(this.getFileType()));
            }
            super.update(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/rest/client/RESTClient$HighlightAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ConfigureProxyAction
    extends DumbAwareAction {
        private ConfigureProxyAction() {
            super("Configure HTTP Proxy", "Show dialog to configure the HTTP proxy settings", AllIcons.General.Settings);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureProxyAction.$$$reportNull$$$0(0);
            }
            HttpConfigurable.editConfigurable((JComponent)RESTClient.this.myMainPanel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ConfigureProxyAction", "actionPerformed"));
        }
    }
}

