/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.DBLeasedSession;
import org.jetbrains.dekaf.exceptions.DBSessionIsClosedException;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateSession;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSession;

public abstract class DBSessions {
    @NotNull
    public static DBLeasedSession wrap(@NotNull IntegralIntermediateSession intermediateSession) {
        if (intermediateSession.isClosed()) {
            throw new DBSessionIsClosedException("The session is closed.");
        }
        return new BaseSession(intermediateSession);
    }

    @NotNull
    public static DBLeasedSession wrap(@NotNull PrimeIntermediateSession intermediateSession) {
        if (intermediateSession.isClosed()) {
            throw new DBSessionIsClosedException("The session is closed.");
        }
        if (intermediateSession instanceof IntegralIntermediateSession) {
            return DBSessions.wrap((IntegralIntermediateSession)intermediateSession);
        }
        AdaptIntermediateSession adaptedSession = new AdaptIntermediateSession(intermediateSession);
        return DBSessions.wrap(adaptedSession);
    }
}

