/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;

@State(name="TextMateSettings", storages={@Storage(value="textmate.xml")})
public class TextMateSettings
implements PersistentStateComponent<TextMateSettingsState> {
    @NonNls
    public static final String DEFAULT_THEME_NAME = "Mac Classic";
    private TextMateSettingsState myState;

    public static TextMateSettings getInstance() {
        return (TextMateSettings)ServiceManager.getService(TextMateSettings.class);
    }

    @Nullable
    public TextMateSettingsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull TextMateSettingsState state) {
        if (state == null) {
            TextMateSettings.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public Collection<BundleConfigBean> getBundles() {
        return this.myState != null ? this.myState.getBundles() : Collections.emptyList();
    }

    @NotNull
    public String getTextMateThemeName(@NotNull String generalThemeName, @Nullable TextMateService textMateService) {
        String result;
        if (generalThemeName == null) {
            TextMateSettings.$$$reportNull$$$0(1);
        }
        if (textMateService == null) {
            if (DEFAULT_THEME_NAME == null) {
                TextMateSettings.$$$reportNull$$$0(2);
            }
            return DEFAULT_THEME_NAME;
        }
        String string = result = this.myState != null ? this.myState.getThemesMapping().get(generalThemeName) : null;
        if (result != null) {
            String string2 = result;
            if (string2 == null) {
                TextMateSettings.$$$reportNull$$$0(3);
            }
            return string2;
        }
        for (String name : textMateService.getThemeNames()) {
            if (!name.equalsIgnoreCase(generalThemeName)) continue;
            result = name;
            break;
        }
        result = (String)ObjectUtils.notNull((Object)result, (Object)DEFAULT_THEME_NAME);
        if (this.myState != null) {
            this.myState.getThemesMapping().put(generalThemeName, result);
        }
        String string3 = result;
        if (string3 == null) {
            TextMateSettings.$$$reportNull$$$0(4);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalThemeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/configuration/TextMateSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/configuration/TextMateSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextMateThemeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTextMateThemeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextMateSettingsState {
        private Map<String, String> themesMapping;
        private Collection<BundleConfigBean> bundles = ContainerUtil.newArrayList();

        public TextMateSettingsState() {
            this(new HashMap<String, String>());
        }

        public TextMateSettingsState(Map<String, String> themesMapping) {
            this.themesMapping = themesMapping;
        }

        @NotNull
        public Map<String, String> getThemesMapping() {
            Map<String, String> map = this.themesMapping;
            if (map == null) {
                TextMateSettingsState.$$$reportNull$$$0(0);
            }
            return map;
        }

        public Collection<BundleConfigBean> getBundles() {
            return this.bundles;
        }

        public void setBundles(Collection<BundleConfigBean> bundles) {
            ArrayList newList = ContainerUtil.newArrayListWithCapacity((int)bundles.size());
            for (BundleConfigBean bundle : bundles) {
                newList.add(bundle.copy());
            }
            this.bundles = newList;
        }

        public void setThemesMapping(Map<String, String> themesMapping) {
            this.themesMapping = themesMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextMateSettingsState state = (TextMateSettingsState)o;
            return this.bundles.equals(state.bundles);
        }

        public int hashCode() {
            return this.bundles.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/configuration/TextMateSettings$TextMateSettingsState", "getThemesMapping"));
        }
    }
}

