/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring.introduceParameter;

import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.xslt.refactoring.BaseIntroduceDialog;
import org.intellij.lang.xpath.xslt.refactoring.BaseIntroduceForm;
import org.intellij.lang.xpath.xslt.refactoring.introduceParameter.IntroduceParameterOptions;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterDialog
extends BaseIntroduceDialog
implements IntroduceParameterOptions {
    private static final String TITLE = "XSLT - Introduce Parameter";
    private JPanel myContentPane;
    private JCheckBox myCreateWithDefault;
    private BaseIntroduceForm myForm;
    private boolean myIsPreview;
    private final boolean myForceDefault;
    private final MyPreviewAction myPreviewAction;

    public IntroduceParameterDialog(XPathExpression expression, int numberOfExpressions, boolean forceDefault) {
        super(expression.getProject(), (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(expression.getLanguage()));
        this.$$$setupUI$$$();
        this.myPreviewAction = new MyPreviewAction();
        this.myForceDefault = forceDefault;
        this.init(expression, numberOfExpressions, TITLE);
        this.getOKAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    IntroduceParameterDialog.this.myPreviewAction.setEnabled((Boolean)evt.getNewValue() != false && !IntroduceParameterDialog.this.myCreateWithDefault.isSelected());
                }
            }
        });
        if (forceDefault) {
            this.myCreateWithDefault.setSelected(true);
            this.myCreateWithDefault.setVisible(false);
        } else {
            this.myCreateWithDefault.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IntroduceParameterDialog.this.myPreviewAction.setEnabled(IntroduceParameterDialog.this.getOKAction().isEnabled() && !IntroduceParameterDialog.this.myCreateWithDefault.isSelected());
                }
            });
        }
        this.myPreviewAction.setEnabled(false);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        if (this.myForceDefault) {
            actionArray = super.createActions();
        } else {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = this.getOKAction();
            actionArray2[1] = this.getPreviewAction();
            actionArray = actionArray2;
            actionArray2[2] = this.getCancelAction();
        }
        if (actionArray == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Override
    public boolean isCreateDefault() {
        return this.myCreateWithDefault.isSelected();
    }

    @Override
    public boolean isReplaceAll() {
        return this.myForm.isReplaceAll();
    }

    @Override
    public boolean isPreview() {
        return this.myIsPreview;
    }

    @Override
    protected BaseIntroduceForm getForm() {
        return this.myForm;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/refactoring/introduceParameter/IntroduceParameterDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        BaseIntroduceForm baseIntroduceForm;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateWithDefault = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create with default value");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(12);
        jCheckBox.setToolTipText("Assign the extracted expression to the new parameter's default value");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForm = baseIntroduceForm = new BaseIntroduceForm();
        JComponent jComponent = baseIntroduceForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class MyPreviewAction
    extends AbstractAction {
        MyPreviewAction() {
            super("&Preview");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IntroduceParameterDialog.this.myIsPreview = true;
            IntroduceParameterDialog.this.doOKAction();
        }
    }
}

