/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.entities.Angular2Element;
import org.angular2.entities.Angular2Pipe;
import org.angular2.entities.metadata.psi.Angular2MetadataEntity;
import org.angular2.entities.source.Angular2SourceEntity;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.jetbrains.annotations.NotNull;

public class Angular2EntityUtils {
    public static final String TEMPLATE_REF = "TemplateRef";
    private static final String INDEX_ELEMENT_NAME_PREFIX = ">";
    private static final String INDEX_ATTRIBUTE_NAME_PREFIX = "=";

    @NotNull
    public static Collection<? extends TypeScriptFunction> getPipeTransformMethods(@NotNull TypeScriptClass cls) {
        if (cls == null) {
            Angular2EntityUtils.$$$reportNull$$$0(0);
        }
        Collection collection = TypeScriptTypeParser.buildTypeFromClass((JSClass)cls, (boolean)false).getProperties().stream().filter(prop -> "transform".equals(prop.getMemberName()) && prop.getMemberSource().getSingleElement() instanceof TypeScriptFunction).findFirst().map(sig -> sig.getMemberSource().getAllSourceElements().stream().filter(fun -> fun instanceof TypeScriptFunction && !(fun instanceof TypeScriptFunctionSignature)).collect(Collectors.toList())).map(Collections::unmodifiableCollection).orElseGet(Collections::emptyList);
        if (collection == null) {
            Angular2EntityUtils.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static Pair<String, String> parsePropertyMapping(@NotNull String property) {
        int ind;
        if (property == null) {
            Angular2EntityUtils.$$$reportNull$$$0(2);
        }
        if ((ind = property.indexOf(58)) > 0) {
            Pair pair = Pair.pair((Object)property.substring(0, ind).trim(), (Object)property.substring(ind + 1).trim());
            if (pair == null) {
                Angular2EntityUtils.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)property.trim(), (Object)property.trim());
        if (pair == null) {
            Angular2EntityUtils.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    public static String getElementDirectiveIndexName(@NotNull String elementName) {
        if (elementName == null) {
            Angular2EntityUtils.$$$reportNull$$$0(5);
        }
        String string = INDEX_ELEMENT_NAME_PREFIX + elementName;
        if (string == null) {
            Angular2EntityUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean isElementDirectiveIndexName(@NotNull String elementName) {
        if (elementName == null) {
            Angular2EntityUtils.$$$reportNull$$$0(7);
        }
        return elementName.startsWith(INDEX_ELEMENT_NAME_PREFIX);
    }

    @NotNull
    public static String getElementName(@NotNull String elementDirectiveIndexName) {
        if (elementDirectiveIndexName == null) {
            Angular2EntityUtils.$$$reportNull$$$0(8);
        }
        if (!Angular2EntityUtils.isElementDirectiveIndexName(elementDirectiveIndexName)) {
            throw new IllegalArgumentException();
        }
        String string = elementDirectiveIndexName.substring(1);
        if (string == null) {
            Angular2EntityUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getAttributeDirectiveIndexName(@NotNull String attributeName) {
        if (attributeName == null) {
            Angular2EntityUtils.$$$reportNull$$$0(10);
        }
        String string = INDEX_ATTRIBUTE_NAME_PREFIX + attributeName;
        if (string == null) {
            Angular2EntityUtils.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static boolean isAttributeDirectiveIndexName(@NotNull String attributeName) {
        if (attributeName == null) {
            Angular2EntityUtils.$$$reportNull$$$0(12);
        }
        return attributeName.startsWith(INDEX_ATTRIBUTE_NAME_PREFIX);
    }

    @NotNull
    public static String getAttributeName(@NotNull String attributeIndexName) {
        if (attributeIndexName == null) {
            Angular2EntityUtils.$$$reportNull$$$0(13);
        }
        if (!Angular2EntityUtils.isAttributeDirectiveIndexName(attributeIndexName)) {
            throw new IllegalArgumentException();
        }
        String string = attributeIndexName.substring(1);
        if (string == null) {
            Angular2EntityUtils.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static Set<String> getDirectiveIndexNames(@NotNull String selector) {
        List<Angular2DirectiveSimpleSelector> selectors;
        if (selector == null) {
            Angular2EntityUtils.$$$reportNull$$$0(15);
        }
        try {
            selectors = Angular2DirectiveSimpleSelector.parse(selector);
        }
        catch (ParseException e) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                Angular2EntityUtils.$$$reportNull$$$0(16);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        Consumer<Angular2DirectiveSimpleSelector> indexSelector = sel -> {
            String elementName = sel.getElementName();
            if (StringUtil.isEmpty((String)elementName) || "*".equals(elementName)) {
                result.add(INDEX_ELEMENT_NAME_PREFIX);
            } else {
                result.add(INDEX_ELEMENT_NAME_PREFIX + elementName);
            }
            for (String attrName : sel.getAttrNames()) {
                result.add(INDEX_ATTRIBUTE_NAME_PREFIX + attrName);
            }
        };
        for (Angular2DirectiveSimpleSelector sel2 : selectors) {
            indexSelector.accept(sel2);
            sel2.getNotSelectors().forEach(indexSelector);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            Angular2EntityUtils.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    public static String toString(Angular2Element element) {
        String sourceKind = element instanceof Angular2SourceEntity ? "source" : (element instanceof Angular2MetadataEntity ? "metadata" : "unknown");
        if (element instanceof Angular2Directive) {
            StringBuilder result = new StringBuilder();
            Angular2Directive directive = (Angular2Directive)element;
            result.append(directive.getName()).append(" <").append(sourceKind).append(' ');
            if (directive.isComponent()) {
                result.append("component");
            } else if (directive.isTemplate()) {
                result.append("template");
            } else {
                result.append("directive");
            }
            result.append(INDEX_ELEMENT_NAME_PREFIX).append(": selector=").append(directive.getSelector().getText());
            if (!directive.getExportAsList().isEmpty()) {
                result.append("; exportAs=").append(StringUtil.join(directive.getExportAsList(), (String)","));
            }
            result.append("; inputs=").append(directive.getInputs().toString()).append("; outputs=").append(directive.getOutputs().toString()).append("; inOuts=").append(directive.getInOuts().toString());
            return result.toString();
        }
        if (element instanceof Angular2Pipe) {
            return ((Angular2Pipe)element).getName() + " <" + sourceKind + " pipe>";
        }
        if (element instanceof Angular2DirectiveProperty) {
            return ((Angular2DirectiveProperty)element).getName();
        }
        return element.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/Angular2EntityUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDirectiveIndexName";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeIndexName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/Angular2EntityUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPipeTransformMethods";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePropertyMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementDirectiveIndexName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDirectiveIndexName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectiveIndexNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPipeTransformMethods";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementDirectiveIndexName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isElementDirectiveIndexName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDirectiveIndexName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAttributeDirectiveIndexName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveIndexNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

