/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationObject;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.util.Value2D;
import com.intellij.openapi.graph.util.Value2DSettable;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Graph2DViewRepaintManager;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.YLabel;
import java.awt.Color;
import java.awt.geom.GeneralPath;

public interface ViewAnimationFactory {
    public static final NodeOrder LEFT_TO_RIGHT = GraphManager.getGraphManager()._ViewAnimationFactory_LEFT_TO_RIGHT();
    public static final NodeOrder RIGHT_TO_LEFT = GraphManager.getGraphManager()._ViewAnimationFactory_RIGHT_TO_LEFT();
    public static final NodeOrder CLOCKWISE = GraphManager.getGraphManager()._ViewAnimationFactory_CLOCKWISE();
    public static final NodeOrder COUNTER_CLOCKWISE = GraphManager.getGraphManager()._ViewAnimationFactory_COUNTER_CLOCKWISE();
    public static final AnimationQuality HIGH_QUALITY = GraphManager.getGraphManager()._ViewAnimationFactory_HIGH_QUALITY();
    public static final AnimationQuality DEFAULT = GraphManager.getGraphManager()._ViewAnimationFactory_DEFAULT();
    public static final AnimationQuality HIGH_PERFORMANCE = GraphManager.getGraphManager()._ViewAnimationFactory_HIGH_PERFORMANCE();
    public static final StructuralEffect RESET_EFFECT = GraphManager.getGraphManager()._ViewAnimationFactory_RESET_EFFECT();
    public static final StructuralEffect SIMULATE_EFFECT = GraphManager.getGraphManager()._ViewAnimationFactory_SIMULATE_EFFECT();
    public static final StructuralEffect APPLY_EFFECT = GraphManager.getGraphManager()._ViewAnimationFactory_APPLY_EFFECT();

    public AnimationQuality getQuality();

    public void setQuality(AnimationQuality var1);

    public Graph2DView getView();

    public Graph2DViewRepaintManager getRepaintManager();

    public AnimationObject blurIn(Drawable var1, long var2);

    public AnimationObject blurOut(Drawable var1, long var2);

    public AnimationObject fadeIn(Drawable var1, long var2);

    public AnimationObject fadeOut(Drawable var1, long var2);

    public AnimationObject implode(Drawable var1, long var2);

    public AnimationObject explode(Drawable var1, long var2);

    public AnimationObject whirlIn(Drawable var1, long var2);

    public AnimationObject whirlOut(Drawable var1, long var2);

    public AnimationObject traversePath(GeneralPath var1, boolean var2, Drawable var3, long var4);

    public AnimationObject traversePath(GeneralPath var1, boolean var2, Drawable var3, boolean var4, boolean var5, long var6);

    public AnimationObject color(NodeRealizer var1, Color var2, Color var3, Color var4, StructuralEffect var5, long var6);

    public AnimationObject move(NodeRealizer var1, Value2D var2, StructuralEffect var3, long var4);

    public AnimationObject move(NodeRealizer[] var1, Value2D[] var2, StructuralEffect var3, long var4);

    public AnimationObject morph(NodeRealizer var1, NodeRealizer var2, StructuralEffect var3, long var4);

    public AnimationObject resize(NodeRealizer var1, Value2D var2, StructuralEffect var3, long var4);

    public AnimationObject scale(NodeRealizer var1, Value2D var2, StructuralEffect var3, long var4);

    public AnimationObject blink(NodeRealizer var1, long var2);

    public AnimationObject blurIn(NodeRealizer var1, long var2);

    public AnimationObject blurOut(NodeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject implode(NodeRealizer var1, long var2);

    public AnimationObject explode(NodeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject fadeIn(NodeRealizer var1, long var2);

    public AnimationObject fadeOut(NodeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject whirlIn(NodeRealizer var1, long var2);

    public AnimationObject whirlOut(NodeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject traversePath(GeneralPath var1, boolean var2, NodeRealizer var3, long var4);

    public AnimationObject blurIn(EdgeRealizer var1, long var2);

    public AnimationObject blurOut(EdgeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject color(EdgeRealizer var1, Color var2, StructuralEffect var3, long var4);

    public AnimationObject implode(EdgeRealizer var1, long var2);

    public AnimationObject explode(EdgeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject fadeIn(EdgeRealizer var1, long var2);

    public AnimationObject fadeOut(EdgeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject extract(EdgeRealizer var1, long var2);

    public AnimationObject retract(EdgeRealizer var1, StructuralEffect var2, long var3);

    public AnimationObject traverseEdge(EdgeRealizer var1, EdgeRealizer var2, StructuralEffect var3, long var4);

    public AnimationObject traverseEdge(EdgeRealizer var1, EdgeRealizer var2, EdgeRealizer var3, boolean var4, StructuralEffect var5, long var6);

    public AnimationObject traversePath(GeneralPath var1, boolean var2, Value2DSettable var3, Value2DSettable var4, long var5);

    public AnimationObject moveCamera(Value2D var1, long var2);

    public AnimationObject moveCamera(GeneralPath var1, long var2);

    public AnimationObject zoom(double var1, StructuralEffect var3, long var4);

    public AnimationObject fadeIn(Graph2D var1, NodeOrder var2, boolean var3, double var4, long var6);

    public AnimationObject fadeOut(Graph2D var1, NodeOrder var2, boolean var3, double var4, long var6);

    public AnimationPlayer createConfiguredPlayer();

    public AnimationObject focusView(double var1, Value2D var3, long var4);

    public static class Statics {
        public static Drawable createDrawable(NodeRealizer nodeRealizer) {
            return GraphManager.getGraphManager()._ViewAnimationFactory_createDrawable(nodeRealizer);
        }

        public static Drawable createDrawable(EdgeRealizer edgeRealizer) {
            return GraphManager.getGraphManager()._ViewAnimationFactory_createDrawable(edgeRealizer);
        }

        public static Drawable createDrawable(YLabel yLabel) {
            return GraphManager.getGraphManager()._ViewAnimationFactory_createDrawable(yLabel);
        }
    }

    public static interface NodeOrder {
    }

    public static interface AnimationQuality {
    }

    public static interface StructuralEffect {
    }
}

