/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerValidateDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JBCheckBox myDependenciesCheckBox;
    private JBCheckBox myPublishCheckBox;
    private JBCheckBox myLockCheckBox;
    private JBCheckBox myVersionsCheckBox;

    protected ComposerValidateDialog(@Nullable Project project) {
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Validation Settings");
        this.setOKButtonText("Validate");
        this.init();
        this.pack();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void setCommandLineOptions(String options) {
        options = StringUtil.notNullize((String)options);
        this.myVersionsCheckBox.setSelected(options.contains("--no-check-all"));
        this.myLockCheckBox.setSelected(!options.contains("--no-check-lock"));
        this.myPublishCheckBox.setSelected(!options.contains("--no-check-publish"));
        this.myDependenciesCheckBox.setSelected(options.contains("--with-dependencies"));
    }

    @NotNull
    public String getCommandLineOptions() {
        StringBuilder sb = new StringBuilder("--no-interaction --ansi --verbose");
        if (this.myVersionsCheckBox.isSelected()) {
            sb.append(" --no-check-all");
        }
        if (!this.myLockCheckBox.isSelected()) {
            sb.append(" --no-check-lock");
        }
        if (!this.myPublishCheckBox.isSelected()) {
            sb.append(" --no-check-publish");
        }
        if (this.myDependenciesCheckBox.isSelected()) {
            sb.append(" --with-dependencies");
        }
        String string = sb.toString();
        if (string == null) {
            ComposerValidateDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "ComposerValidateDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/actions/ComposerValidateDialog", "getCommandLineOptions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVersionsCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Allow unbound version constraints");
        jPanel.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLockCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Check if composer.lock is up-to-date");
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPublishCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Check if the package is Packagist-ready");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDependenciesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Validate package dependencies");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

