/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageFeatureUsagesTracker;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLanguageLevelInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLanguageLevelInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){
            private final EnumSet<PhpLanguageFeature> myUsedFeatures;
            private final PhpLanguageLevel myCurrentLevel;
            private final boolean syncWithComposer;
            {
                this.myUsedFeatures = PhpLanguageFeatureUsagesTracker.getInstance().getUsedFeatures(holder.getProject());
                this.myCurrentLevel = PhpProjectConfigurationFacade.getInstance(holder.getProject()).getLanguageLevel();
                this.syncWithComposer = ComposerDataService.getInstance(holder.getProject()).syncLanguageLevel();
            }

            public void visitPhpFieldReference(FieldReference reference) {
                this.checkStaticReferenceAccess((MemberReference)reference);
                super.visitPhpFieldReference(reference);
            }

            public void visitPhpParameter(Parameter parameter) {
                if (parameter.isVariadic()) {
                    this.checkFeature(PhpLanguageFeature.VARIADIC_FUNCTIONS, (PsiElement)parameter);
                }
                if (PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Function.INSTANCEOF) instanceof PhpDocMethod) {
                    return;
                }
                String type = parameter.getDeclaredType().toString();
                if (!(type.equalsIgnoreCase("array") || type.equalsIgnoreCase("callable") || type.equalsIgnoreCase("null") || type.equalsIgnoreCase("resource") || type.equalsIgnoreCase("number") || !PhpType.isPrimitiveType((String)type))) {
                    this.checkFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS, (PsiElement)parameter.getFirstPsiChild());
                }
                ClassReference classReference = (ClassReference)PhpPsiUtil.getChildByCondition((PsiElement)parameter, (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
                if ("object".equalsIgnoreCase(type) && classReference != null && classReference.multiResolve(false).length == 0) {
                    this.checkFeature(PhpLanguageFeature.OBJECT_TYPE_HINT, (PsiElement)classReference);
                }
                this.checkPhp7TypeHints(type, (PsiElement)classReference);
                PsiElement quest = parameter.getFirstChild();
                if (PhpPsiUtil.isOfType(quest, PhpTokenTypes.opQUEST)) {
                    Object ref = PhpPsiUtil.getNextSiblingByCondition(quest, (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
                    if (ref != null) {
                        TextRange range = TextRange.create((int)quest.getStartOffsetInParent(), (int)(ref.getStartOffsetInParent() + ref.getTextLength()));
                        this.checkFeature(PhpLanguageFeature.NULLABLES, (PsiElement)parameter, range);
                    } else {
                        this.checkFeature(PhpLanguageFeature.NULLABLES, quest);
                    }
                }
            }

            public void visitPhpReturnType(PhpReturnType returnType) {
                if (returnType.isNullable()) {
                    this.checkFeature(PhpLanguageFeature.NULLABLES, (PsiElement)returnType);
                } else {
                    if (this.myCurrentLevel == PhpLanguageLevel.PHP700) {
                        if ("void".equalsIgnoreCase(returnType.getDeclaredType().toString()) && returnType.getClassReference().multiResolve(false).length == 0) {
                            this.checkFeature(PhpLanguageFeature.RETURN_VOID, (PsiElement)returnType);
                        }
                    } else {
                        this.checkFeature(PhpLanguageFeature.RETURN_TYPES, (PsiElement)returnType);
                    }
                    CharSequence name = returnType.getClassReference().getNameCS();
                    this.checkPhp7TypeHints(name, (PsiElement)returnType);
                }
            }

            private void checkPhp7TypeHints(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700) && (PhpLangUtil.equalsClassNames(name, "true") || PhpLangUtil.equalsClassNames(name, "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
                    holder.registerProblem(psi, "Type hints with names true, false, and null are forbidden", new LocalQuickFix[0]);
                }
            }

            public void visitPhpField(Field field) {
                Object modifierList;
                ASTNode node = field.getNameNode();
                if (field.isConstant() && node != null && PhpTokenTypes.tsKEYWORDS.contains(node.getElementType())) {
                    this.checkFeature(PhpLanguageFeature.KEYWORD_NAMES, node.getPsi());
                }
                if (field.isConstant() && (modifierList = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)field, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF)) != null) {
                    this.checkFeature(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY, (PsiElement)modifierList);
                }
            }

            public void visitPhpFunction(Function function) {
                ASTNode node = function.getNameNode();
                if (node != null && PhpTokenTypes.tsKEYWORDS.contains(node.getElementType())) {
                    this.checkFeature(PhpLanguageFeature.KEYWORD_NAMES, node.getPsi());
                }
            }

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                if (expression.isShortSyntax()) {
                    this.checkFeature(PhpLanguageFeature.SHORT_ARRAY_SYNTAX, (PsiElement)expression);
                }
            }

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                PhpPsiElement value = expression.getValue();
                if (value instanceof FunctionReference) {
                    PsiElement target = PhpPsiUtil.findNextSiblingOfAnyType((PsiElement)value, PhpTokenTypes.chLBRACE, PhpTokenTypes.chLBRACKET);
                    this.checkFeature(PhpLanguageFeature.ARRAY_DEREFERENCING, (PsiElement)(target != null ? target : expression));
                }
            }

            public void visitPhpBreak(PhpBreak breakStatement) {
                this.checkBreakContinueArgument(breakStatement.getArgument(), PhpLanguageFeature.VAR_BREAK_ARGUMENT, PhpLanguageFeature.VAR_BREAK_ZERO_ARGUMENT);
            }

            public void visitPhpFinally(Finally element) {
                this.checkFeature(PhpLanguageFeature.FINALLY, (PsiElement)element);
            }

            public void visitPhpClassConstantReference(ClassConstantReference expression) {
                PsiElement child = expression.getLastChild();
                if (PhpPsiUtil.isOfType(child, PhpTokenTypes.kwCLASS)) {
                    this.checkFeature(PhpLanguageFeature.CLASS_NAME_CONST, child);
                }
            }

            public void visitPhpEmpty(PhpEmpty expression) {
                PhpPsiElement child = expression.getFirstPsiChild();
                if (!(child == null || child instanceof Variable || child instanceof FieldReference || child instanceof ArrayAccessExpression)) {
                    this.checkFeature(PhpLanguageFeature.EMPTY_ANY_EXPRESSION, (PsiElement)child);
                }
            }

            public void visitPhpArrayIndex(ArrayIndex expression) {
                PhpPsiElement prev = expression.getPrevPsiSibling();
                if (prev instanceof ArrayCreationExpression || prev instanceof StringLiteralExpression) {
                    this.checkFeature(PhpLanguageFeature.IMMEDIATE_DEREFERENCING, expression.getParent());
                }
            }

            public void visitPhpYield(PhpYield element) {
                this.checkFeature(PhpLanguageFeature.GENERATORS, (PsiElement)element);
            }

            public void visitPhpContinue(PhpContinue continueStatement) {
                this.checkBreakContinueArgument(continueStatement.getArgument(), PhpLanguageFeature.VAR_CONTINUE_ARGUMENT, PhpLanguageFeature.VAR_CONTINUE_ZERO_ARGUMENT);
            }

            private void checkBreakContinueArgument(@Nullable PsiElement argument, @NotNull PhpLanguageFeature argumentFeature, @NotNull PhpLanguageFeature zeroArgumentFeature) {
                if (argumentFeature == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (zeroArgumentFeature == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (argument != null) {
                    Object element = argument instanceof ParenthesizedExpression ? ((ParenthesizedExpression)argument).unparenthesize() : argument;
                    if (!PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
                        this.checkFeature(argumentFeature, argument);
                    } else {
                        Integer depth = PhpCodeInsightUtil.toInt(element);
                        if (depth == null || depth <= 0) {
                            this.checkFeature(zeroArgumentFeature, argument);
                        }
                    }
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isTrait()) {
                    this.checkFeature(PhpLanguageFeature.TRAITS, clazz.getFirstChild());
                }
                if (clazz.isAnonymous()) {
                    this.checkFeature(PhpLanguageFeature.ANONYMOUS_CLASSES, clazz.getFirstChild());
                }
                CharSequence name = clazz.getNameCS();
                ASTNode node = clazz.getNameNode();
                PsiElement psi = node != null ? node.getPsi() : null;
                this.checkPhp7ClassName(name, psi);
                this.checkPhp71ClassName(name, psi);
                this.checkPhp72ClassName(name, psi);
            }

            public void visitPhpVariable(Variable variable) {
                Function f;
                if (!variable.isDeclaration() && PhpLangUtil.equalsVariableNames("this", variable.getName()) && (f = (Function)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)Function.INSTANCEOF)) != null && f.isClosure()) {
                    this.checkFeature(PhpLanguageFeature.THIS_IN_CLOSURE, (PsiElement)variable);
                }
            }

            public void visitPhpClassReference(ClassReference classReference) {
                String name;
                Function f = (Function)PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (f != null && f.isClosure() && (name = classReference.getName()) != null) {
                    if (name.equals("self")) {
                        this.checkFeature(PhpLanguageFeature.SELF_IN_CLOSURE, (PsiElement)classReference);
                    }
                    if (name.equals("static")) {
                        this.checkFeature(PhpLanguageFeature.STATIC_IN_CLOSURE, (PsiElement)classReference);
                    }
                    if (name.equals("parent")) {
                        this.checkFeature(PhpLanguageFeature.PARENT_IN_CLOSURE, (PsiElement)classReference);
                    }
                }
            }

            public void visitPhpNewExpression(NewExpression expression) {
                this.checkCallParameterList((ParameterListOwner)expression);
                PsiElement parent = expression.getParent();
                if (parent instanceof ParenthesizedExpression && ((parent = parent.getParent()) instanceof FieldReference || parent instanceof MethodReference)) {
                    this.checkFeature(PhpLanguageFeature.CLASS_MEMBER_ACCESS_ON_INSTANTIATION, expression.getParent());
                }
            }

            public void visitPhpMethod(Method method) {
                PsiElement abstractKeyword;
                this.visitPhpFunction((Function)method);
                PhpModifierList modifiers = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
                if (modifiers != null && (abstractKeyword = PhpPsiUtil.getChildOfType((PsiElement)modifiers, PhpTokenTypes.kwABSTACT)) != null) {
                    PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (superMember, subClass, baseClass) -> {
                        Method superMethod = (Method)superMember;
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superMethod.isAbstract() && superContainingClass != null && !superContainingClass.isInterface() && !superContainingClass.isTrait()) {
                            this.checkFeature(PhpLanguageFeature.ABSTRACT_FUNCTION_OVERRIDE, abstractKeyword);
                        }
                        return false;
                    });
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                PhpPsiElement ref;
                PhpPsiElement child;
                this.checkStaticReferenceAccess((MemberReference)reference);
                this.checkCallParameterList((ParameterListOwner)reference);
                if (reference.isStatic() && (child = reference.getFirstPsiChild()) != null && (ref = child.getNextPsiSibling()) instanceof StringLiteralExpression && ref.getTextLength() > 0) {
                    this.checkFeature(PhpLanguageFeature.LITERAL_IN_STATIC_CALL, (PsiElement)ref);
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpPsiElement child = reference.getFirstPsiChild();
                if (child instanceof ParenthesizedExpression) {
                    this.checkFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX, (PsiElement)child);
                }
                this.checkCallParameterList((ParameterListOwner)reference);
            }

            private void checkCallParameterList(@NotNull ParameterListOwner parameterListOwner) {
                ParameterList parameterList;
                if (parameterListOwner == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((parameterList = parameterListOwner.getParameterList()) != null) {
                    PsiElement unpacking;
                    PsiElement bitOperator = PhpPsiUtil.getChildOfType((PsiElement)parameterList, PhpTokenTypes.opBIT_AND);
                    if (bitOperator != null) {
                        this.checkFeature(PhpLanguageFeature.CALL_TIME_PASS_BY_REFERENCE, bitOperator);
                    }
                    if ((unpacking = PhpPsiUtil.getChildOfType((PsiElement)parameterList, PhpTokenTypes.opVARIADIC)) != null) {
                        this.checkFeature(PhpLanguageFeature.ARGUMENT_UNPACKING, unpacking);
                    }
                    if (PhpPsiUtil.isOfType(parameterList.getLastChild(), PhpTokenTypes.opCOMMA)) {
                        this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, parameterList.getLastChild());
                    }
                }
            }

            public void visitPhpIsset(PhpIsset issetExpression) {
                PsiElement prevSibling;
                ASTNode lastChildNode = issetExpression.getNode().getLastChildNode();
                if (PhpPsiUtil.isOfType(lastChildNode, PhpTokenTypes.chRPAREN) && PhpPsiUtil.isOfType(prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(lastChildNode.getPsi(), true), PhpTokenTypes.opCOMMA)) {
                    this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, prevSibling);
                }
            }

            public void visitPhpUnset(PhpUnset unsetStatement) {
                PsiElement prevPrevSibling;
                PsiElement prevSibling;
                ASTNode lastChildNode = unsetStatement.getNode().getLastChildNode();
                if (PhpPsiUtil.isOfType(lastChildNode, PhpTokenTypes.opSEMICOLON) && PhpPsiUtil.isOfType(prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(lastChildNode.getPsi(), true), PhpTokenTypes.chRPAREN) && PhpPsiUtil.isOfType(prevPrevSibling = prevSibling.getPrevSibling(), PhpTokenTypes.opCOMMA)) {
                    this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, prevPrevSibling);
                }
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement operand;
                PsiElement operation = expression.getOperation();
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opEXP)) {
                    this.checkFeature(PhpLanguageFeature.EXPONENTIATION, operation);
                }
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opSPACESHIP)) {
                    this.checkFeature(PhpLanguageFeature.SPACESHIP_OPERATOR, operation);
                }
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCOALESCE)) {
                    this.checkFeature(PhpLanguageFeature.COALESCE_OPERATOR, operation);
                }
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.kwINSTANCEOF) && PhpLanguageLevelInspection.isConstant(operand = expression.getLeftOperand())) {
                    this.checkFeature(PhpLanguageFeature.LITERAL_IN_INSTANCEOF, operand);
                }
            }

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                if (expression.getOperationType() == PhpTokenTypes.opEXP_ASGN) {
                    this.checkFeature(PhpLanguageFeature.EXPONENTIATION, expression.getOperation());
                }
            }

            public void visitPhpForeach(ForeachStatement expression) {
                PsiElement list = PhpPsiUtil.getChildOfType((PsiElement)expression, PhpTokenTypes.kwLIST);
                if (list != null) {
                    this.checkFeature(PhpLanguageFeature.FOREACH_LIST, list);
                }
                super.visitPhpForeach(expression);
            }

            public void visitPhpExpression(PhpExpression expression) {
                if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.NUMBER) && expression.getText().startsWith("0b")) {
                    this.checkFeature(PhpLanguageFeature.BINARY_LITERAL, (PsiElement)expression);
                }
            }

            public void visitPhpUseList(PhpUseList expression) {
                ASTNode node = expression.getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCONST, PhpTokenTypes.kwFUNCTION}));
                if (node != null) {
                    this.checkFeature(PhpLanguageFeature.USE_FUNCTION_AND_CONST, node.getPsi());
                }
                if (PhpPsiUtil.getChildByCondition((PsiElement)expression, PhpUseImpl.USE_BRACES_CONDITION) != null) {
                    this.checkFeature(PhpLanguageFeature.GROUPED_USE, (PsiElement)expression);
                }
            }

            public void visitPhpMultiassignmentExpression(MultiassignmentExpression expr) {
                PhpPsiElement child = expr.getFirstPsiChild();
                if (PhpPsiUtil.isOfType((PsiElement)child, PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
                    this.checkFeature(PhpLanguageFeature.LIST_ASSIGN, (PsiElement)child);
                }
            }

            public void visitPhpUse(PhpUse expression) {
                if (PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null) {
                    this.checkFeature(PhpLanguageFeature.TRAITS, expression.getParent().getFirstChild());
                }
                String name = expression.getAliasName();
                PsiElement psi = expression.getLastChild();
                if (!PhpUseImpl.isOfFunction(expression) && !PhpUseImpl.isOfConst(expression)) {
                    this.checkPhp7ClassName(name, psi);
                    this.checkPhp71ClassName(name, psi);
                    this.checkPhp72ClassName(name, psi);
                }
            }

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (expression.isHeredoc() && PhpPsiUtil.isOfType(expression.getLastChild(), PhpTokenTypes.HEREDOC_END)) {
                    ASTNode at1;
                    if (expression.getLastChild().getText().startsWith("\n ") || expression.getLastChild().getText().startsWith("\n\t")) {
                        this.checkFeature(PhpLanguageFeature.FLEXIBLE_HEREDOCS, expression.getLastChild());
                    }
                    int offset = expression.getTextOffset() + expression.getTextLength();
                    FileASTNode node = expression.getContainingFile().getNode();
                    ASTNode at0 = node.findLeafElementAt(offset);
                    if (!(at0 != null && at0.getChars().charAt(0) == '\n' || (at1 = node.findLeafElementAt(offset + 1)) != null && at1.getChars().charAt(0) == '\n')) {
                        this.checkFeature(PhpLanguageFeature.FLEXIBLE_HEREDOCS, expression.getLastChild());
                    }
                }
            }

            private void checkPhp7ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700) && (PhpLangUtil.equalsClassNames(name, "int") || PhpLangUtil.equalsClassNames(name, "string") || PhpLangUtil.equalsClassNames(name, "float") || PhpLangUtil.equalsClassNames(name, "bool") || PhpLangUtil.equalsClassNames(name, "true") || PhpLangUtil.equalsClassNames(name, "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
                    holder.registerProblem(psi, "Classes with names int, string, float, bool, true, false, and null are forbidden in PHP 7", new LocalQuickFix[0]);
                }
            }

            private void checkPhp71ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP710) && (PhpLangUtil.equalsClassNames(name, "void") || PhpLangUtil.equalsClassNames(name, "iterable"))) {
                    holder.registerProblem(psi, "Classes with names void, and iterable are forbidden in PHP 7.1", new LocalQuickFix[0]);
                }
            }

            private void checkPhp72ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP720) && PhpLangUtil.equalsClassNames(name, "object")) {
                    holder.registerProblem(psi, "Classes with name object are forbidden in PHP 7.2", new LocalQuickFix[0]);
                }
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700)) {
                    int defaults = 0;
                    for (PsiElement child = switchStatement.getLastChild(); child != null; child = child.getPrevSibling()) {
                        if (!PhpPsiUtil.isOfType(child, PhpElementTypes.CASE_DEFAULT) || defaults++ <= 0) continue;
                        holder.registerProblem(child, "Switch statements may only contain one default clause in PHP 7", new LocalQuickFix[0]);
                    }
                }
            }

            public void visitPhpStatement(Statement statement) {
                PsiElement strictTypesDirective;
                if (statement instanceof Declare && (strictTypesDirective = DeclareImpl.getStrictTypesDirective((Declare)statement)) != null) {
                    this.checkFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS, "Strict type declaration is available in PHP 7 only", strictTypesDirective);
                }
            }

            public void visitPhpCatch(Catch phpCatch) {
                Collection types = phpCatch.getExceptionTypes();
                if (types.size() > 1) {
                    ClassReference first = (ClassReference)ContainerUtil.getFirstItem((Collection)types);
                    ClassReference last = (ClassReference)ContainerUtil.getLastItem((List)((List)types));
                    TextRange range = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
                    this.checkFeature(PhpLanguageFeature.CATCH_MULTIPLE, (PsiElement)phpCatch, range);
                }
            }

            private void checkStaticReferenceAccess(MemberReference reference) {
                PsiElement parent = reference.getParent();
                if (parent instanceof MemberReference && ((MemberReference)parent).getReferenceType().isStatic()) {
                    this.checkFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX, parent);
                }
            }

            private void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull PsiElement psiElement) {
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.checkFeature(languageFeature, languageFeature.getNotSupportedErrorMessage(), psiElement);
            }

            private void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull String errorMessage, @NotNull PsiElement psiElement) {
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(7);
                }
                this.checkFeature(languageFeature, errorMessage, psiElement, null);
            }

            private void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull PsiElement psiElement, @Nullable TextRange rangeInElement) {
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(9);
                }
                this.checkFeature(languageFeature, languageFeature.getNotSupportedErrorMessage(), psiElement, rangeInElement);
            }

            private void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull String errorMessage, @NotNull PsiElement psiElement, @Nullable TextRange rangeInElement) {
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(12);
                }
                this.myUsedFeatures.add(languageFeature);
                PhpLanguageLevel preferableLanguageLevel = this.myCurrentLevel;
                if (!preferableLanguageLevel.hasFeature(languageFeature)) {
                    for (PhpLanguageLevel level : PhpLanguageLevel.values()) {
                        if (!level.hasFeature(languageFeature)) continue;
                        preferableLanguageLevel = level;
                        break;
                    }
                    LocalQuickFix quickFix = this.syncWithComposer ? null : PhpSwitchLanguageLevelQuickFix.getInstance(preferableLanguageLevel);
                    holder.registerProblem(psiElement, rangeInElement, errorMessage, new LocalQuickFix[]{quickFix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argumentFeature";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "zeroArgumentFeature";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameterListOwner";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 8: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "languageFeature";
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 6: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkBreakContinueArgument";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkCallParameterList";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkFeature";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpLanguageLevelInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        HyperlinkLabel settingsLink = new HyperlinkLabel("Languages & Frameworks / PHP");
        settingsLink.addHyperlinkListener(e -> {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)settingsLink);
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project != null) {
                PhpProjectConfigurable configurable = new PhpProjectConfigurable(project);
                Settings settings = (Settings)Settings.KEY.getData(dataContext);
                if (settings != null) {
                    settings.select(settings.find(configurable.getId()));
                } else {
                    PhpUiUtil.editConfigurable(project, (Configurable)configurable);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)settingsLink, "North");
        return panel;
    }

    @Contract(value="null -> false")
    private static boolean isConstant(@Nullable PsiElement element) {
        if (element instanceof ConstantReference) {
            ConstantReference reference = (ConstantReference)element;
            return PhpLangUtil.isNull(reference) || PhpLangUtil.isTrue(reference) || PhpLangUtil.isFalse(reference);
        }
        return element instanceof StringLiteralExpression || PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

