/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedCallbackInspection
extends PhpInspection {
    public static final LocalQuickFix METHOD_FIX = new PhpAddMethodFromCallbackQuickFix();
    public static final LocalQuickFix FUNCTION_FIX = new PhpAddFunctionFromCallbackQuickFix();
    public static final LocalQuickFix FIELD_FIX = new PhpAddFieldFromCallbackQuickFix();
    private static final LocalQuickFix[] ADD_METHOD_FIXES = new LocalQuickFix[]{METHOD_FIX};
    private static final LocalQuickFix[] ADD_FUNCTION_FIXES = new LocalQuickFix[]{FUNCTION_FIX};
    private static final LocalQuickFix[] ADD_FIELD_FIXES = new LocalQuickFix[]{FIELD_FIX};
    private static final String UNDEFINED_METHOD_REF = "Method #ref was not found";
    private static final String UNDEFINED_FIELD_REF = "Field #ref was not found";
    public boolean DONT_REPORT_EXISTS_CALLBACKS = true;
    public boolean DONT_REPORT_AMBIGUITY = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkForCallback(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkForCallback((FunctionReference)reference);
            }

            private void checkForCallback(@NotNull FunctionReference reference) {
                String functionName;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.isEmpty((String)(functionName = reference.getName())) || PhpUndefinedCallbackInspection.this.DONT_REPORT_EXISTS_CALLBACKS && PhpCallbackFunctionUtil.isExistsCallbackFunction(functionName)) {
                    return;
                }
                PsiElement[] arguments = reference.getParameters();
                if (arguments.length == 0) {
                    return;
                }
                if (PhpCallbackFunctionUtil.isStandardFunctionCallbackFunction(functionName)) {
                    this.resolveFunctionCallback(arguments[0]);
                } else if (PhpCallbackFunctionUtil.isMethodCallbackFunction(reference, 1)) {
                    this.resolveMemberCallback(arguments[0], arguments[1], true);
                } else if (PhpCallbackFunctionUtil.isFieldCallbackFunction(reference, 1)) {
                    this.resolveMemberCallback(arguments[0], arguments[1], false);
                } else if (PhpCallbackFunctionUtil.isClassCallbackFunction(reference, 0)) {
                    if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(arguments[0])) {
                        this.registerClassNotFound(arguments[0]);
                    }
                } else {
                    boolean canHaveCallbackArguments = false;
                    for (PsiElement argument : arguments) {
                        if (!(argument instanceof StringLiteralExpression) && !(argument instanceof ArrayCreationExpression)) continue;
                        canHaveCallbackArguments = true;
                        break;
                    }
                    if (!canHaveCallbackArguments) {
                        return;
                    }
                    PsiElement resolve = reference.resolve();
                    if (resolve instanceof Function) {
                        Parameter[] parameters = ((Function)resolve).getParameters();
                        int length = Math.min(parameters.length, arguments.length);
                        for (int i = 0; i < length; ++i) {
                            PsiElement argument = arguments[i];
                            if (!PhpUndefinedCallbackInspection.this.isCallableParameter(parameters[i], argument)) continue;
                            this.resolveFunctionCallback(argument);
                        }
                    }
                }
            }

            private void resolveFunctionCallback(@NotNull PsiElement argument) {
                String text;
                PhpCallbackFunctionUtil.PhpCallbackInfoHolder callback;
                if (argument == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((callback = PhpCallbackFunctionUtil.createCallback(argument)) == null || !PhpNameUtil.isValidFunctionName(PhpLangUtil.toShortName(callback.getCallbackText()))) {
                    return;
                }
                PsiElement element = callback.getCallbackElement();
                if (callback instanceof PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder) {
                    this.resolveMemberCallback(((PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder)callback).getClassElement(), element, true);
                } else if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(element) && StringUtil.isNotEmpty((String)(text = PhpCodeInsightUtil.toString(element, false)))) {
                    holder.registerProblem(element, PhpBundle.message("inspection.undefined.callback.function", text), ADD_FUNCTION_FIXES);
                }
            }

            private void resolveMemberCallback(@NotNull PsiElement classRef, @NotNull PsiElement memberRef, boolean isMethodReference) {
                if (classRef == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (memberRef == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(memberRef)) {
                    String text = PhpCodeInsightUtil.toString(memberRef, false);
                    if (StringUtil.isEmpty((String)text)) {
                        return;
                    }
                    String classFqn = this.checkClassReference(classRef);
                    if (StringUtil.isEmpty((String)classFqn)) {
                        return;
                    }
                    if (isMethodReference) {
                        String message = isOnTheFly ? PhpBundle.message("inspection.undefined.callback.method", text, classFqn) : PhpUndefinedCallbackInspection.UNDEFINED_METHOD_REF;
                        holder.registerProblem(memberRef, message, ADD_METHOD_FIXES);
                    } else {
                        String message = isOnTheFly ? PhpBundle.message("inspection.undefined.callback.field", text, classFqn) : PhpUndefinedCallbackInspection.UNDEFINED_FIELD_REF;
                        holder.registerProblem(memberRef, message, ADD_FIELD_FIXES);
                    }
                } else if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(classRef)) {
                    this.registerClassNotFound(classRef);
                }
            }

            @Nullable
            private String checkClassReference(@NotNull PsiElement classRef) {
                if (classRef == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (classRef instanceof StringLiteralExpression) {
                    PsiReference[] references = classRef.getReferences();
                    if (references.length == 1 && references[0] instanceof PhpCallbackReferenceBase) {
                        ResolveResult[] results = ((PhpCallbackReferenceBase)references[0]).multiResolve(false);
                        if (results.length == 0) {
                            this.registerClassNotFound(classRef);
                            return null;
                        }
                        PsiElement element = results[0].getElement();
                        return element instanceof PhpClass ? ((PhpClass)element).getFQN() : null;
                    }
                } else {
                    PhpType type = PhpCallbackFunctionUtil.getClassReferenceType(classRef);
                    if (type != null) {
                        return type.filterPrimitives().toStringResolved();
                    }
                }
                return null;
            }

            private void registerClassNotFound(@NotNull PsiElement element) {
                String text;
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (StringUtil.isNotEmpty((String)(text = PhpCodeInsightUtil.toString(element, false)))) {
                    holder.registerProblem(element, PhpBundle.message("inspection.undefined.callback.class", text), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argument";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classRef";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "memberRef";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkForCallback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolveFunctionCallback";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolveMemberCallback";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkClassReference";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerClassNotFound";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean hasUnresolvedCallbackReference(@NotNull PsiElement element) {
        PsiReference[] references;
        if (element == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof StringLiteralExpression && (references = element.getReferences()).length == 1 && references[0] instanceof PhpCallbackReferenceBase) {
            return ((PhpCallbackReferenceBase)references[0]).multiResolve(false).length == 0;
        }
        return false;
    }

    private boolean isCallableParameter(@NotNull Parameter parameter, @NotNull PsiElement argument) {
        if (parameter == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(4);
        }
        if (argument instanceof StringLiteralExpression || argument instanceof ArrayCreationExpression) {
            PhpType type = parameter.getType();
            if (this.DONT_REPORT_AMBIGUITY) {
                Set types = type.getTypes();
                return types.size() == 1 && PhpType.isCallableType((String)((String)types.iterator().next()));
            }
            return PhpCallbackFunctionUtil.isCallable(type);
        }
        return false;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedCallbackReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCallableParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myDontReportExistsCallbacks;
        private JCheckBox myDontReportAmbiguity;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDontReportExistsCallbacks.setSelected(PhpUndefinedCallbackInspection.this.DONT_REPORT_EXISTS_CALLBACKS);
            this.myDontReportAmbiguity.setSelected(PhpUndefinedCallbackInspection.this.DONT_REPORT_AMBIGUITY);
            this.myDontReportExistsCallbacks.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedCallbackInspection.this.DONT_REPORT_EXISTS_CALLBACKS = OptionsPanel.this.myDontReportExistsCallbacks.isSelected();
                }
            });
            this.myDontReportAmbiguity.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedCallbackInspection.this.DONT_REPORT_AMBIGUITY = OptionsPanel.this.myDontReportAmbiguity.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myDontReportExistsCallbacks = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.callback.dont.report.exist.checkbox"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDontReportAmbiguity = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.callback.dont.report.ambiguity.checkbox"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class PhpAddFunctionFromCallbackQuickFix
    extends PhpAddMethodFromCallbackQuickFix {
        private PhpAddFunctionFromCallbackQuickFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.create.function.from.callback.name", new Object[0]);
            if (string == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            String fqn;
            if (project == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmpty((String)(fqn = PhpCallbackFunctionUtil.getCallbackString(element = descriptor.getPsiElement())))) {
                PhpAddFunctionFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.function.from.callback.invalid.element", new Object[0]), element);
                return;
            }
            String namespace = PhpLangUtil.getParentQualifiedName(fqn);
            if (!PhpAddFunctionFromCallbackQuickFix.isCalledFromTheSameNamespace(element, namespace)) {
                String presentable = PhpLangUtil.isGlobalNamespaceName(namespace) ? "global" : namespace;
                PhpAddFunctionFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.function.from.callback.another.namespace", presentable), element);
                return;
            }
            String name = PhpLangUtil.toShortName(fqn);
            Function function = PhpPsiElementFactory.createFunction(project, "function " + name + this.createParameters(element) + "{}");
            PsiElement anchor = PhpAddFunctionFromCallbackQuickFix.getElementScope(element);
            if (anchor != null && FileModificationService.getInstance().prepareFileForWrite(anchor.getContainingFile())) {
                PsiElement parent = anchor.getParent();
                ApplicationManager.getApplication().runWriteAction(() -> parent.addAfter((PsiElement)function, anchor));
            }
        }

        private static boolean isCalledFromTheSameNamespace(@NotNull PsiElement element, @NotNull String namespace) {
            Object parentNamespace;
            if (element == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(3);
            }
            if (namespace == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(4);
            }
            if ((parentNamespace = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)) == null) {
                return StringUtil.isEmpty((String)namespace) || StringUtil.equals((CharSequence)namespace, (CharSequence)"\\");
            }
            String originalNamespace = ((PhpNamespace)parentNamespace).getNamespaceName();
            return PhpLangUtil.equalsClassNames(originalNamespace, namespace);
        }

        @Nullable
        private static PsiElement getElementScope(@NotNull PsiElement element) {
            Object parentClass;
            if (element == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(5);
            }
            if ((parentClass = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null) {
                return parentClass;
            }
            Object parentFunction = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (parentFunction != null) {
                return parentFunction;
            }
            Object controlStatement = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)ControlStatement.INSTANCEOF);
            return controlStatement == null ? PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Statement.INSTANCEOF) : controlStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFunctionFromCallbackQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFunctionFromCallbackQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isCalledFromTheSameNamespace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementScope";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpAddFieldFromCallbackQuickFix
    extends PhpAddFieldDeclarationQuickFix {
        private PhpAddFieldFromCallbackQuickFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.create.field.from.callback.name", new Object[0]);
            if (string == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpModifier.Access access;
            if (project == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(2);
            }
            if ((access = PhpAddFieldFromCallbackQuickFix.getSettings()) == null) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            PsiReference[] references = element.getReferences();
            if (references.length == 1 && references[0] instanceof PhpCallbackReferenceBase.PhpClassMemberCallbackReference) {
                PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref = (PhpCallbackReferenceBase.PhpClassMemberCallbackReference)references[0];
                String fieldName = ref.getClassMemberName();
                if (StringUtil.isEmpty((String)fieldName)) {
                    PhpAddFieldFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.field.from.callback.invalid.element", new Object[0]), element);
                    return;
                }
                Collection<PhpClass> classes = ref.resolveClassReference();
                if (classes.isEmpty()) {
                    PhpAddFieldFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.field.from.callback.unresolved.class.ref", new Object[0]), element);
                    return;
                }
                if (classes.size() > 1) {
                    PhpAddFieldFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.field.from.callback.ambiguity.class.ref", new Object[0]), element);
                    return;
                }
                PsiElement field = PhpAddFieldFromCallbackQuickFix.addFieldToClass(project, classes.iterator().next(), fieldName, access, ref.isStaticRef());
                if (field != null) {
                    PhpAddFieldFromCallbackQuickFix.runTemplate(field, PhpAddFieldFromCallbackQuickFix.createTemplate(field), null);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFieldFromCallbackQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFieldFromCallbackQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpAddMethodFromCallbackQuickFix
    extends PhpAddMethodDeclarationQuickFix {
        private PhpAddMethodFromCallbackQuickFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.create.method.from.callback.name", new Object[0]);
            if (string == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiReference[] references;
            if (project == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(2);
            }
            if ((references = (element = descriptor.getPsiElement()).getReferences()).length == 1 && references[0] instanceof PhpCallbackReferenceBase.PhpClassMemberCallbackReference) {
                PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref = (PhpCallbackReferenceBase.PhpClassMemberCallbackReference)references[0];
                String methodName = ref.getClassMemberName();
                if (StringUtil.isEmpty((String)methodName)) {
                    PhpAddMethodFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.method.from.callback.invalid.element", new Object[0]), element);
                    return;
                }
                Collection<PhpClass> classes = ref.resolveClassReference();
                if (classes.isEmpty()) {
                    PhpAddMethodFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.method.from.callback.unresolved.class.ref", new Object[0]), element);
                    return;
                }
                if (classes.size() > 1) {
                    PhpAddMethodFromCallbackQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.create.method.from.callback.ambiguity.class.ref", new Object[0]), element);
                    return;
                }
                String parameters = this.createParameters(element);
                PhpClass klass = classes.iterator().next();
                if (klass != null && FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
                    WriteAction.run(() -> {
                        if (project == null) {
                            PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(5);
                        }
                        PsiElement method = PhpAddMethodFromCallbackQuickFix.buildMethod(project, element, parameters, methodName, ref.isStaticRef(), klass);
                        PhpAddFieldDeclarationQuickFix.runTemplate(method, PhpAddFieldDeclarationQuickFix.createTemplate(method), (TemplateEditingListener)new TemplateEditingAdapter(){

                            public void templateFinished(@NotNull Template template1, boolean brokenOff) {
                                if (template1 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (!brokenOff) {
                                    PhpCodeEditUtil.setupMethodBody(project);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template1", "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddMethodFromCallbackQuickFix$1", "templateFinished"));
                            }
                        });
                    });
                }
            }
        }

        @NotNull
        protected String createParameters(@NotNull PsiElement element) {
            PhpPsiElement nextParameter;
            if (element == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(3);
            }
            Object argument = PhpPsiUtil.getParentByCondition(element, false, PhpCallbackFunctionUtil.FUNCTION_ARGUMENT);
            StringBuilder builder = new StringBuilder("(");
            if (argument instanceof PhpPsiElement && (nextParameter = ((PhpPsiElement)argument).getNextPsiSibling()) != null && nextParameter.getParent() == argument.getParent() && nextParameter instanceof ArrayCreationExpression) {
                PsiElement[] item = nextParameter.getChildren();
                int length = item.length;
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        builder.append(",");
                    }
                    PsiElement value = item[i];
                    PsiElement content = PhpCallbackFunctionUtil.getArrayValueContent(value);
                    builder.append("$");
                    builder.append(PhpNameSuggestionUtil.parameterNameByElement(content));
                    builder.append(i);
                }
            }
            builder.append(")");
            String string = builder.toString();
            if (string == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddMethodFromCallbackQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddMethodFromCallbackQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

