/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveDelegateBase
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if (this.extractElementByIdentifier(element) != null) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer);
    }

    public abstract String getRefactoringName();

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiFile file = element.getContainingFile();
        PsiElement elementToMove = this.extractElementByIdentifier(element);
        if (elementToMove != null) {
            if (!file.isWritable()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.common.file.read.only", new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), null);
                return true;
            }
            this.doMove(project, new PsiElement[]{elementToMove}, null, null);
            return true;
        }
        return false;
    }

    @Nullable
    private PsiElement extractElementByIdentifier(@NotNull PsiElement element) {
        PsiElement parent;
        PsiElement identifier;
        if (element == null) {
            PhpMoveDelegateBase.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = identifier = this.isValidTarget(parent = element.getParent(), null) ? ((PsiNameIdentifierOwner)parent).getNameIdentifier() : null;
        if (identifier == null) {
            return null;
        }
        return identifier == element || identifier == element.getPrevSibling() || identifier == element.getNextSibling() ? parent : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/move/PhpMoveDelegateBase", "extractElementByIdentifier"));
    }
}

