/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.PhpRenamePsiElementProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PhpUseWithAliasRenameProcessor
extends PhpRenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PhpUse && ((PhpUse)element).getAliasName() != null;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(1);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_USE_WITH_ALIAS;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(2);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_USE_WITH_ALIAS;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(3);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_USE_WITH_ALIAS = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(4);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_USE_WITH_ALIAS = enabled;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newAliasName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PhpPsiElement scope;
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newAliasName == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(7);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(element)) == null) {
            return;
        }
        PhpUseWithAliasRenameProcessor.importsWithSameName(newAliasName, scope, PhpUseWithAliasRenameProcessor.getKeyword((PhpUse)element)).forEach(declaration -> {
            if (conflicts == null) {
                PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(27);
            }
            conflicts.putValue(declaration, (Object)PhpBundle.message("conflict.use.with.same.name.already.exists", new Object[0]));
        });
        PhpUseList list = PhpUseImpl.getUseList(element);
        if (list == null) {
            return;
        }
        String message = PhpUseWithAliasRenameProcessor.getMessage(list);
        PhpUseWithAliasRenameProcessor.getConflictDeclarations(list, scope, newAliasName).forEach(def -> {
            if (conflicts == null) {
                PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(26);
            }
            conflicts.putValue(def, (Object)message);
        });
    }

    @NotNull
    public static Stream<PhpUse> importsWithSameName(@NotNull String name, @NotNull PhpPsiElement scope, @NotNull String keyword) {
        if (name == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(9);
        }
        if (keyword == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(10);
        }
        Stream<PhpUse> stream = PhpCodeInsightUtil.collectImports(scope).stream().flatMap(list -> Arrays.stream(list.getDeclarations())).filter(declaration -> {
            if (name == null) {
                PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(25);
            }
            return StringUtil.equalsIgnoreCase((CharSequence)declaration.getName(), (CharSequence)name);
        }).filter(declaration -> {
            if (keyword == null) {
                PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(24);
            }
            return StringUtil.equals((CharSequence)PhpUseWithAliasRenameProcessor.getKeyword(declaration), (CharSequence)keyword);
        });
        if (stream == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    private static String getKeyword(@NotNull PhpUse use) {
        if (use == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(12);
        }
        String string = PhpGroupUseElement.getKeyword(use, PhpUseImpl.getUseList((PsiElement)use));
        if (string == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static Collection<PhpNamedElement> getConflictDeclarations(@NotNull PhpUseList list, @NotNull PhpPsiElement scope, @NotNull String name) {
        if (list == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(15);
        }
        if (name == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(16);
        }
        List result = ContainerUtil.newSmartList();
        boolean isOfConst = list.isOfConst();
        boolean isOfFunction = list.isOfFunction();
        for (PhpNamedElement def : ((PhpFile)list.getContainingFile()).getTopLevelDefs().values()) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)def.getName(), (CharSequence)name) || !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)def, (boolean)true)) continue;
            if (isOfConst && def instanceof Constant) {
                result.add(def);
                continue;
            }
            if (isOfFunction && def instanceof Function) {
                result.add(def);
                continue;
            }
            if (isOfFunction || isOfConst || !(def instanceof PhpClass)) continue;
            result.add(def);
        }
        List list2 = result;
        if (list2 == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    private static String getMessage(@NotNull PhpUseList list) {
        if (list == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(18);
        }
        if (list.isOfConst()) {
            String string = PhpBundle.message("conflict.constant.with.same.name.already.exists", new Object[0]);
            if (string == null) {
                PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (list.isOfFunction()) {
            String string = PhpBundle.message("conflict.function.with.same.name.already.exists", new Object[0]);
            if (string == null) {
                PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = PhpBundle.message("conflict.class.with.same.name.already.exists", new Object[0]);
        if (string == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        if (element == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(22);
        }
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).findAll();
        if (collection == null) {
            PhpUseWithAliasRenameProcessor.$$$reportNull$$$0(23);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAliasName";
                break;
            }
            case 7: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 8: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/PhpUseWithAliasRenameProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpUseWithAliasRenameProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "importsWithSameName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictDeclarations";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importsWithSameName";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConflictDeclarations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$importsWithSameName$4";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$importsWithSameName$3";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findExistingNameConflicts$1";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findExistingNameConflicts$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

