/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternThatSetsCurrent
extends Pattern {
    private LocalVariableBinding binding;
    private Pattern wrappedPattern;

    public PatternThatSetsCurrent(Pattern wrappedPattern) {
        this.wrappedPattern = wrappedPattern;
        this.binding = new LocalVariableBinding(Current.FN_CURRENT, SequenceType.SINGLE_ITEM);
        this.setExecutable(wrappedPattern.getExecutable());
        this.setOriginalText(wrappedPattern.toString());
        this.setLineNumber(wrappedPattern.getLineNumber());
        this.setSystemId(wrappedPattern.getSystemId());
    }

    public Binding getCurrentBinding() {
        return this.binding;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        this.binding.setSlotNumber(nextFree++);
        return this.wrappedPattern.allocateSlots(slotManager, nextFree);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return this.wrappedPattern.iterateSubExpressions();
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        context.setLocalVariable(this.binding.getLocalSlotNumber(), item);
        return this.wrappedPattern.matches(item, context);
    }

    @Override
    public ItemType getItemType() {
        return this.wrappedPattern.getItemType();
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.wrappedPattern = this.wrappedPattern.simplify(visitor);
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.wrappedPattern = this.wrappedPattern.analyze(visitor, contextItemType);
        return this;
    }

    @Override
    public int getNodeKind() {
        return this.wrappedPattern.getNodeKind();
    }

    @Override
    public int getFingerprint() {
        return this.wrappedPattern.getFingerprint();
    }

    @Override
    public double getDefaultPriority() {
        return this.wrappedPattern.getDefaultPriority();
    }

    @Override
    public String toString() {
        return this.wrappedPattern.toString();
    }

    @Override
    public int getHostLanguage() {
        return this.wrappedPattern.getHostLanguage();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        return this.wrappedPattern.replaceSubExpression(original, replacement);
    }

    @Override
    public boolean isMotionless(boolean allowExtensions) {
        return this.wrappedPattern.isMotionless(allowExtensions);
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.wrappedPattern.matchesBeneathAnchor(node, anchor, context);
    }
}

