/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.jvm.MonitoredData;
import org.graalvm.visualvm.application.jvm.MonitoredDataListener;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.heapdump.HeapDumpSupport;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.openide.util.NbBundle;

final class ApplicationMonitorModel {
    private static final String PROP_PREFIX = "ApplicationMonitorModel_";
    static final String SNAPSHOT_VERSION = "ApplicationMonitorModel_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.1";
    private static final String PROP_NOT_DEFINED = "<not defined>";
    public static final String PROP_CHART_CACHE = "ApplicationMonitorModel_chart_cache";
    public static final String PROP_UPTIME = "ApplicationMonitorModel_uptime";
    public static final String PROP_PREV_UPTIME = "ApplicationMonitorModel_prev_uptime";
    public static final String PROP_INVOKE_GC_SUPPORTED = "ApplicationMonitorModel_invoke_gc_supported";
    public static final String PROP_HEAP_DUMP_SUPPORTED = "ApplicationMonitorModel_heap_dump_supported";
    public static final String PROP_CPU_MONITORING_SUPPORTED = "ApplicationMonitorModel_cpu_monitoring_supported";
    public static final String PROP_GC_MONITORING_SUPPORTED = "ApplicationMonitorModel_gc_monitoring_supported";
    public static final String PROP_MEMORY_MONITORING_SUPPORTED = "ApplicationMonitorModel_memory_monitoring_supported";
    public static final String PROP_CLASS_MONITORING_SUPPORTED = "ApplicationMonitorModel_class_monitoring_supported";
    public static final String PROP_THREADS_MONITORING_SUPPORTED = "ApplicationMonitorModel_threads_monitoring_supported";
    public static final String PROP_NUMBER_OF_PROCESSORS = "ApplicationMonitorModel_number_of_processors";
    public static final String PROP_PROCESS_CPU_TIME = "ApplicationMonitorModel_process_cpu_time";
    public static final String PROP_PROCESS_GC_TIME = "ApplicationMonitorModel_process_gc_time";
    public static final String PROP_PREV_PROCESS_CPU_TIME = "ApplicationMonitorModel_prev_process_cpu_time";
    public static final String PROP_PREV_PROCESS_GC_TIME = "ApplicationMonitorModel_prev_process_gc_time";
    public static final String PROP_HEAP_NAME = "ApplicationMonitorModel_heap_name";
    public static final String PROP_HEAP_CAPACITY = "ApplicationMonitorModel_heap_capacity";
    public static final String PROP_HEAP_USED = "ApplicationMonitorModel_heap_used";
    public static final String PROP_MAX_HEAP = "ApplicationMonitorModel_max_heap";
    public static final String PROP_PERMGEN_NAME = "ApplicationMonitorModel_permgen_name";
    public static final String PROP_PERMGEN_CAPACITY = "ApplicationMonitorModel_permgen_capacity";
    public static final String PROP_PERMGEN_USED = "ApplicationMonitorModel_permgen_used";
    public static final String PROP_PERMGEN_MAX = "ApplicationMonitorModel_permgen_max";
    public static final String PROP_SHARED_UNLOADED = "ApplicationMonitorModel_shared_unloaded";
    public static final String PROP_TOTAL_UNLOADED = "ApplicationMonitorModel_total_unloaded";
    public static final String PROP_SHARED_LOADED = "ApplicationMonitorModel_shared_loaded";
    public static final String PROP_TOTAL_LOADED = "ApplicationMonitorModel_total_loaded";
    public static final String PROP_TOTAL_THREADS = "ApplicationMonitorModel_total_threads";
    public static final String PROP_DAEMON_THREADS = "ApplicationMonitorModel_daemon_threads";
    public static final String PROP_PEAK_THREADS = "ApplicationMonitorModel_peak_threads";
    public static final String PROP_STARTED_THREADS = "ApplicationMonitorModel_started_threads";
    private static final String CPU_CHART_STORAGE = "monitor_cpu.dat";
    private static final String HEAP_CHART_STORAGE = "monitor_heap.dat";
    private static final String PERMGEN_CHART_STORAGE = "monitor_permgen.dat";
    private static final String CLASSES_CHART_STORAGE = "monitor_classes.dat";
    private static final String THREADS_CHART_STORAGE = "monitor_threads.dat";
    private boolean initialized = false;
    private final DataSource source;
    private final boolean live;
    private final List<ChangeListener> listeners;
    private Jvm jvm;
    private MemoryMXBean memoryMXBean;
    private MonitoredDataListener monitoredDataListener;
    private int chartCache = -1;
    private long timestamp = -1L;
    private long uptime = -1L;
    private long prevUpTime = -1L;
    private boolean takeHeapDumpSupported = false;
    private boolean cpuMonitoringSupported = false;
    private boolean gcMonitoringSupported = false;
    private boolean memoryMonitoringSupported = false;
    private boolean classMonitoringSupported = false;
    private boolean threadsMonitoringSupported = false;
    private int processorsCount = -1;
    private long processCpuTime = -1L;
    private long processGcTime = -1L;
    private long prevProcessCpuTime = -1L;
    private long prevProcessGcTime = -1L;
    private String heapName;
    private long heapCapacity = -1L;
    private long heapUsed = -1L;
    private long maxHeap = -1L;
    private String permgenName;
    private long permgenCapacity = -1L;
    private long permgenUsed = -1L;
    private long permgenMax = -1L;
    private long sharedUnloaded = -1L;
    private long totalUnloaded = -1L;
    private long sharedLoaded = -1L;
    private long totalLoaded = -1L;
    private long totalThreads = -1L;
    private long daemonThreads = -1L;
    private long peakThreads = -1L;
    private long startedThreads = -1L;
    private SimpleXYChartSupport cpuChartSupport;
    private SimpleXYChartSupport heapChartSupport;
    private SimpleXYChartSupport permGenChartSupport;
    private SimpleXYChartSupport classesChartSupport;
    private SimpleXYChartSupport threadsChartSupport;

    public static ApplicationMonitorModel create(Application application, boolean live) {
        return new ApplicationMonitorModel((DataSource)application, live);
    }

    public static ApplicationMonitorModel create(Snapshot snapshot) {
        return new ApplicationMonitorModel((DataSource)snapshot, false);
    }

    public DataSource getSource() {
        return this.source;
    }

    public boolean isLive() {
        return this.live;
    }

    public MemoryMXBean getMemoryMXBean() {
        return this.memoryMXBean;
    }

    public int getChartCache() {
        return this.chartCache;
    }

    public boolean isInvokeGCSupported() {
        return this.memoryMXBean != null;
    }

    public boolean isTakeHeapDumpSupported() {
        return this.takeHeapDumpSupported;
    }

    public boolean isCpuMonitoringSupported() {
        return this.cpuMonitoringSupported;
    }

    public boolean isGcMonitoringSupported() {
        return this.gcMonitoringSupported;
    }

    public boolean isMemoryMonitoringSupported() {
        return this.memoryMonitoringSupported;
    }

    public boolean isClassMonitoringSupported() {
        return this.classMonitoringSupported;
    }

    public boolean isThreadsMonitoringSupported() {
        return this.threadsMonitoringSupported;
    }

    public int getProcessorsCount() {
        return this.processorsCount;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getUpTime() {
        return this.uptime;
    }

    public long getPrevUpTime() {
        return this.prevUpTime;
    }

    public long getProcessCpuTime() {
        return this.processCpuTime;
    }

    public long getProcessGcTime() {
        return this.processGcTime;
    }

    public long getPrevProcessCpuTime() {
        return this.prevProcessCpuTime;
    }

    public long getPrevProcessGcTime() {
        return this.prevProcessGcTime;
    }

    public String getHeapName() {
        return this.heapName;
    }

    public long getHeapCapacity() {
        return this.heapCapacity;
    }

    public long getHeapUsed() {
        return this.heapUsed;
    }

    public long getMaxHeap() {
        return this.maxHeap;
    }

    public String getPermgenName() {
        return this.permgenName;
    }

    public long getPermgenCapacity() {
        return this.permgenCapacity;
    }

    public long getPermgenUsed() {
        return this.permgenUsed;
    }

    public long getPermgenMax() {
        return this.permgenMax;
    }

    public long getSharedUnloaded() {
        return this.sharedUnloaded;
    }

    public long getTotalUnloaded() {
        return this.totalUnloaded;
    }

    public long getSharedLoaded() {
        return this.sharedLoaded;
    }

    public long getTotalLoaded() {
        return this.totalLoaded;
    }

    public long getTotalThreads() {
        return this.totalThreads;
    }

    public long getDeamonThreads() {
        return this.daemonThreads;
    }

    public long getPeakThreads() {
        return this.peakThreads;
    }

    public long getStartedThreads() {
        return this.startedThreads;
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.source instanceof Application) {
            this.initialize((Application)this.source);
        } else {
            this.initialize((Snapshot)this.source);
        }
    }

    public void registerCpuChartSupport(final SimpleXYChartSupport cpuChartSupport) {
        this.cpuChartSupport = cpuChartSupport;
        if (cpuChartSupport != null && this.source instanceof Snapshot) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    File file = new File(ApplicationMonitorModel.this.source.getStorage().getDirectory(), ApplicationMonitorModel.CPU_CHART_STORAGE);
                    if (file.isFile()) {
                        ApplicationMonitorModel.loadChartSupport(cpuChartSupport, file);
                    }
                }
            });
        }
    }

    public void registerHeapChartSupport(final SimpleXYChartSupport heapChartSupport) {
        this.heapChartSupport = heapChartSupport;
        if (heapChartSupport != null && this.source instanceof Snapshot) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    File file = new File(ApplicationMonitorModel.this.source.getStorage().getDirectory(), ApplicationMonitorModel.HEAP_CHART_STORAGE);
                    if (file.isFile()) {
                        ApplicationMonitorModel.loadChartSupport(heapChartSupport, file);
                    }
                }
            });
        }
    }

    public void registerPermGenChartSupport(SimpleXYChartSupport permgenChartSupport) {
        this.permGenChartSupport = permgenChartSupport;
        if (this.permGenChartSupport != null && this.source instanceof Snapshot) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    File file = new File(ApplicationMonitorModel.this.source.getStorage().getDirectory(), ApplicationMonitorModel.PERMGEN_CHART_STORAGE);
                    if (file.isFile()) {
                        ApplicationMonitorModel.loadChartSupport(ApplicationMonitorModel.this.permGenChartSupport, file);
                    }
                }
            });
        }
    }

    public void registerClassesChartSupport(final SimpleXYChartSupport classesChartSupport) {
        this.classesChartSupport = classesChartSupport;
        if (classesChartSupport != null && this.source instanceof Snapshot) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    File file = new File(ApplicationMonitorModel.this.source.getStorage().getDirectory(), ApplicationMonitorModel.CLASSES_CHART_STORAGE);
                    if (file.isFile()) {
                        ApplicationMonitorModel.loadChartSupport(classesChartSupport, file);
                    }
                }
            });
        }
    }

    public void registerThreadsChartSupport(final SimpleXYChartSupport threadsChartSupport) {
        this.threadsChartSupport = threadsChartSupport;
        if (threadsChartSupport != null && this.source instanceof Snapshot) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    File file = new File(ApplicationMonitorModel.this.source.getStorage().getDirectory(), ApplicationMonitorModel.THREADS_CHART_STORAGE);
                    if (file.isFile()) {
                        ApplicationMonitorModel.loadChartSupport(threadsChartSupport, file);
                    }
                }
            });
        }
    }

    public synchronized void cleanup() {
        this.listeners.clear();
        if (!this.initialized) {
            return;
        }
        if (this.jvm != null && this.monitoredDataListener != null) {
            this.jvm.removeMonitoredDataListener(this.monitoredDataListener);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.live) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.live) {
            this.listeners.remove(listener);
        }
    }

    public void save(Snapshot snapshot) {
        this.initialize();
        Storage storage = snapshot.getStorage();
        ApplicationMonitorModel.setProperty(storage, SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        ApplicationMonitorModel.setProperty(storage, PROP_CHART_CACHE, Integer.toString(this.chartCache));
        ApplicationMonitorModel.setProperty(storage, PROP_UPTIME, Long.toString(this.uptime));
        ApplicationMonitorModel.setProperty(storage, PROP_PREV_UPTIME, Long.toString(this.prevUpTime));
        ApplicationMonitorModel.setProperty(storage, PROP_CPU_MONITORING_SUPPORTED, Boolean.toString(this.cpuMonitoringSupported));
        ApplicationMonitorModel.setProperty(storage, PROP_GC_MONITORING_SUPPORTED, Boolean.toString(this.gcMonitoringSupported));
        ApplicationMonitorModel.setProperty(storage, PROP_MEMORY_MONITORING_SUPPORTED, Boolean.toString(this.memoryMonitoringSupported));
        ApplicationMonitorModel.setProperty(storage, PROP_CLASS_MONITORING_SUPPORTED, Boolean.toString(this.classMonitoringSupported));
        ApplicationMonitorModel.setProperty(storage, PROP_THREADS_MONITORING_SUPPORTED, Boolean.toString(this.threadsMonitoringSupported));
        ApplicationMonitorModel.setProperty(storage, PROP_NUMBER_OF_PROCESSORS, Integer.toString(this.processorsCount));
        ApplicationMonitorModel.setProperty(storage, PROP_PROCESS_CPU_TIME, Long.toString(this.processCpuTime));
        ApplicationMonitorModel.setProperty(storage, PROP_PROCESS_GC_TIME, Long.toString(this.processGcTime));
        ApplicationMonitorModel.setProperty(storage, PROP_PREV_PROCESS_CPU_TIME, Long.toString(this.prevProcessCpuTime));
        ApplicationMonitorModel.setProperty(storage, PROP_PREV_PROCESS_GC_TIME, Long.toString(this.prevProcessGcTime));
        ApplicationMonitorModel.setProperty(storage, PROP_HEAP_NAME, this.heapName);
        ApplicationMonitorModel.setProperty(storage, PROP_HEAP_CAPACITY, Long.toString(this.heapCapacity));
        ApplicationMonitorModel.setProperty(storage, PROP_HEAP_USED, Long.toString(this.heapUsed));
        ApplicationMonitorModel.setProperty(storage, PROP_MAX_HEAP, Long.toString(this.maxHeap));
        ApplicationMonitorModel.setProperty(storage, PROP_PERMGEN_NAME, this.permgenName);
        ApplicationMonitorModel.setProperty(storage, PROP_PERMGEN_CAPACITY, Long.toString(this.permgenCapacity));
        ApplicationMonitorModel.setProperty(storage, PROP_PERMGEN_USED, Long.toString(this.permgenUsed));
        ApplicationMonitorModel.setProperty(storage, PROP_PERMGEN_MAX, Long.toString(this.permgenMax));
        ApplicationMonitorModel.setProperty(storage, PROP_SHARED_UNLOADED, Long.toString(this.sharedUnloaded));
        ApplicationMonitorModel.setProperty(storage, PROP_TOTAL_UNLOADED, Long.toString(this.totalUnloaded));
        ApplicationMonitorModel.setProperty(storage, PROP_SHARED_LOADED, Long.toString(this.sharedLoaded));
        ApplicationMonitorModel.setProperty(storage, PROP_TOTAL_LOADED, Long.toString(this.totalLoaded));
        ApplicationMonitorModel.setProperty(storage, PROP_TOTAL_THREADS, Long.toString(this.totalThreads));
        ApplicationMonitorModel.setProperty(storage, PROP_DAEMON_THREADS, Long.toString(this.daemonThreads));
        ApplicationMonitorModel.setProperty(storage, PROP_PEAK_THREADS, Long.toString(this.peakThreads));
        ApplicationMonitorModel.setProperty(storage, PROP_STARTED_THREADS, Long.toString(this.startedThreads));
        File dir = storage.getDirectory();
        if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
            ApplicationMonitorModel.saveChartSupport(this.cpuChartSupport, new File(dir, CPU_CHART_STORAGE));
        }
        if (this.memoryMonitoringSupported) {
            ApplicationMonitorModel.saveChartSupport(this.heapChartSupport, new File(dir, HEAP_CHART_STORAGE));
        }
        if (this.memoryMonitoringSupported) {
            ApplicationMonitorModel.saveChartSupport(this.permGenChartSupport, new File(dir, PERMGEN_CHART_STORAGE));
        }
        if (this.classMonitoringSupported) {
            ApplicationMonitorModel.saveChartSupport(this.classesChartSupport, new File(dir, CLASSES_CHART_STORAGE));
        }
        if (this.threadsMonitoringSupported) {
            ApplicationMonitorModel.saveChartSupport(this.threadsChartSupport, new File(dir, THREADS_CHART_STORAGE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveChartSupport(SimpleXYChartSupport chartSupport, File file) {
        if (chartSupport == null) {
            return;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            chartSupport.saveValues((OutputStream)os);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadChartSupport(SimpleXYChartSupport chartSupport, File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            chartSupport.loadValues((InputStream)is);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void initialize(Snapshot snapshot) {
        Storage storage = snapshot.getStorage();
        String version = ApplicationMonitorModel.getProperty(storage, SNAPSHOT_VERSION);
        this.chartCache = Integer.parseInt(ApplicationMonitorModel.getProperty(storage, PROP_CHART_CACHE));
        this.uptime = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_UPTIME));
        this.prevUpTime = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PREV_UPTIME));
        this.takeHeapDumpSupported = false;
        this.cpuMonitoringSupported = Boolean.parseBoolean(ApplicationMonitorModel.getProperty(storage, PROP_CPU_MONITORING_SUPPORTED));
        this.gcMonitoringSupported = Boolean.parseBoolean(ApplicationMonitorModel.getProperty(storage, PROP_GC_MONITORING_SUPPORTED));
        this.memoryMonitoringSupported = Boolean.parseBoolean(ApplicationMonitorModel.getProperty(storage, PROP_MEMORY_MONITORING_SUPPORTED));
        this.classMonitoringSupported = Boolean.parseBoolean(ApplicationMonitorModel.getProperty(storage, PROP_CLASS_MONITORING_SUPPORTED));
        this.threadsMonitoringSupported = Boolean.parseBoolean(ApplicationMonitorModel.getProperty(storage, PROP_THREADS_MONITORING_SUPPORTED));
        this.processorsCount = Integer.parseInt(ApplicationMonitorModel.getProperty(storage, PROP_NUMBER_OF_PROCESSORS));
        this.processCpuTime = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PROCESS_CPU_TIME));
        this.processGcTime = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PROCESS_GC_TIME));
        this.prevProcessCpuTime = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PREV_PROCESS_CPU_TIME));
        this.prevProcessGcTime = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PREV_PROCESS_GC_TIME));
        this.heapCapacity = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_HEAP_CAPACITY));
        this.heapUsed = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_HEAP_USED));
        this.maxHeap = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_MAX_HEAP));
        this.permgenCapacity = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PERMGEN_CAPACITY));
        this.permgenUsed = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PERMGEN_USED));
        this.permgenMax = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PERMGEN_MAX));
        this.sharedUnloaded = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_SHARED_UNLOADED));
        this.totalUnloaded = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_TOTAL_UNLOADED));
        this.sharedLoaded = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_SHARED_LOADED));
        this.totalLoaded = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_TOTAL_LOADED));
        this.totalThreads = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_TOTAL_THREADS));
        this.daemonThreads = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_DAEMON_THREADS));
        this.peakThreads = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_PEAK_THREADS));
        this.startedThreads = Long.parseLong(ApplicationMonitorModel.getProperty(storage, PROP_STARTED_THREADS));
        if (version.compareTo(CURRENT_SNAPSHOT_VERSION) >= 0) {
            this.heapName = ApplicationMonitorModel.getProperty(storage, PROP_HEAP_NAME);
            this.permgenName = ApplicationMonitorModel.getProperty(storage, PROP_PERMGEN_NAME);
        } else {
            this.heapName = NbBundle.getMessage(ApplicationMonitorModel.class, (String)"LBL_Heap");
            this.permgenName = NbBundle.getMessage(ApplicationMonitorModel.class, (String)"LBL_PermGen");
        }
    }

    private static void setProperty(Storage storage, String property, String value) {
        storage.setCustomProperty(property, value == null ? PROP_NOT_DEFINED : value);
    }

    private static String getProperty(Storage storage, String property) {
        String value = storage.getCustomProperty(property);
        return PROP_NOT_DEFINED.equals(value) ? null : value;
    }

    private void initialize(Application application) {
        JvmMXBeans mxbeans;
        GlobalPreferences preferences = GlobalPreferences.sharedInstance();
        this.chartCache = preferences.getMonitoredDataCache() * 60 / preferences.getMonitoredDataPoll();
        this.processorsCount = 1;
        this.jvm = JvmFactory.getJVMFor((Application)application);
        HeapDumpSupport hds = HeapDumpSupport.getInstance();
        this.takeHeapDumpSupported = application.isLocalApplication() ? hds.supportsHeapDump(application) : hds.supportsRemoteHeapDump(application);
        this.cpuMonitoringSupported = this.jvm.isCpuMonitoringSupported();
        this.gcMonitoringSupported = this.jvm.isCollectionTimeSupported();
        this.memoryMonitoringSupported = this.jvm.isMemoryMonitoringSupported();
        this.classMonitoringSupported = this.jvm.isClassMonitoringSupported();
        this.threadsMonitoringSupported = this.jvm.isThreadMonitoringSupported();
        if (this.memoryMonitoringSupported) {
            String[] names = this.jvm.getGenName();
            this.heapName = names[0];
            this.permgenName = names[1];
        }
        this.processorsCount = this.jvm.getAvailableProcessors();
        this.memoryMXBean = null;
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null) {
            this.memoryMXBean = mxbeans.getMemoryMXBean();
        }
        if (this.jvm != null) {
            this.updateValues(System.currentTimeMillis(), this.jvm.getMonitoredData());
            if (this.live) {
                this.monitoredDataListener = new MonitoredDataListener(){
                    long lastTimestamp = -1L;

                    public void monitoredDataEvent(final MonitoredData data) {
                        long timestamp = System.currentTimeMillis();
                        final long timestampF = this.lastTimestamp < timestamp ? (this.lastTimestamp = timestamp) : (this.lastTimestamp = this.lastTimestamp + 1L);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ApplicationMonitorModel.this.updateValues(timestampF, data);
                                ApplicationMonitorModel.this.fireChange();
                            }
                        });
                    }
                };
                this.jvm.addMonitoredDataListener(this.monitoredDataListener);
            }
        }
    }

    private void updateValues(long time, MonitoredData data) {
        this.timestamp = time;
        if (data != null) {
            this.prevUpTime = this.uptime;
            this.uptime = data.getUpTime();
            if (this.cpuMonitoringSupported) {
                this.prevProcessCpuTime = this.processCpuTime;
                this.processCpuTime = data.getProcessCpuTime();
            }
            if (this.gcMonitoringSupported) {
                this.prevProcessGcTime = this.processGcTime;
                this.processGcTime = data.getCollectionTime();
            }
            if (this.memoryMonitoringSupported) {
                this.heapCapacity = data.getGenCapacity()[0];
                this.heapUsed = data.getGenUsed()[0];
                this.maxHeap = data.getGenMaxCapacity()[0];
                this.permgenCapacity = data.getGenCapacity()[1];
                this.permgenUsed = data.getGenUsed()[1];
                this.permgenMax = data.getGenMaxCapacity()[1];
            }
            if (this.classMonitoringSupported) {
                this.sharedUnloaded = data.getSharedUnloadedClasses();
                this.totalUnloaded = data.getUnloadedClasses();
                this.sharedLoaded = data.getSharedLoadedClasses();
                this.totalLoaded = data.getLoadedClasses();
            }
            if (this.threadsMonitoringSupported) {
                this.totalThreads = data.getThreadsLive();
                this.daemonThreads = data.getThreadsDaemon();
                this.peakThreads = data.getThreadsLivePeak();
                this.startedThreads = data.getThreadsStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> list = new ArrayList<ChangeListener>();
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            list.addAll(this.listeners);
        }
        for (ChangeListener l : list) {
            l.stateChanged(new ChangeEvent(this));
        }
    }

    private ApplicationMonitorModel(DataSource source, boolean live) {
        this.source = source;
        this.live = live;
        this.listeners = Collections.synchronizedList(new ArrayList());
    }
}

