/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.phrasetable;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class PhraseTableValueContainer
implements ValueContainer<PhraseTableValues> {
    private static final long serialVersionUID = 964277160049236607L;
    private static final int EMPTY_VALUE_INDEX = Integer.MAX_VALUE;
    @Annotations.PrintMemoryCount
    private LongArray[] features;
    @Annotations.PrintMemoryCount
    private LongArray[] valueIndexes;
    @Annotations.PrintMemoryCount
    private ArrayList<CustomWidthArray>[] targetTranslations;
    private HashNgramMap<PhraseTableValues> map;
    private final int separatorWord;
    private final int numFeatures;

    public PhraseTableValueContainer(int separatorWord, int numFeatures) {
        this.separatorWord = separatorWord;
        this.numFeatures = numFeatures;
        this.targetTranslations = new ArrayList[5];
        this.valueIndexes = new LongArray[5];
        this.features = new LongArray[5];
    }

    public PhraseTableValueContainer createFreshValues(long[] numNgramsForEachOrder_) {
        return new PhraseTableValueContainer(this.separatorWord, this.numFeatures);
    }

    @Override
    public void getFromOffset(long offset, int ngramOrder, @Annotations.OutputParameter PhraseTableValues outputVal) {
        if (offset >= this.valueIndexes[ngramOrder].size()) {
            return;
        }
        long valueIndex = this.valueIndexes[ngramOrder].get(offset);
        if (valueIndex == Integer.MAX_VALUE) {
            return;
        }
        if (outputVal instanceof FeaturePhraseTableValues && valueIndex >= 0L) {
            float[] fs = new float[this.numFeatures];
            for (int i = 0; i < this.numFeatures; ++i) {
                fs[i] = Float.intBitsToFloat((int)this.features[ngramOrder].get((int)(valueIndex + (long)i)));
            }
            ((FeaturePhraseTableValues)outputVal).features = fs;
        }
        if (outputVal instanceof TargetTranslationsValues && valueIndex < 0L) {
            ((TargetTranslationsValues)outputVal).targetTranslationOffsets = this.readOffsets(this.targetTranslations[ngramOrder].get((int)(-valueIndex - 1L)));
            ((TargetTranslationsValues)outputVal).targetTranslationOrders = this.readOrders(this.targetTranslations[ngramOrder].get((int)(-valueIndex - 1L)));
        }
    }

    private int[] readOrders(CustomWidthArray longArray) {
        int[] ret = new int[(int)longArray.size()];
        int i = 0;
        while ((long)i < longArray.size()) {
            ret[i] = (byte)(longArray.get(i) >> 32);
            ++i;
        }
        return ret;
    }

    private long[] readOffsets(CustomWidthArray longArray) {
        long[] ret = new long[(int)longArray.size()];
        int i = 0;
        while ((long)i < longArray.size()) {
            ret[i] = (int)longArray.get(i);
            ++i;
        }
        return ret;
    }

    @Override
    public void trimAfterNgram(int ngramOrder, long size) {
    }

    @Override
    public PhraseTableValues getScratchValue() {
        return new FeaturePhraseTableValues(null);
    }

    @Override
    public boolean add(int[] ngram, int startPos, int endPos, int ngramOrder, long offset, long contextOffset, int word, PhraseTableValues val, long suffixOffset, boolean ngramIsNew) {
        boolean isSourceSidePhrase;
        assert (!this.map.isReversed());
        boolean bl = isSourceSidePhrase = !this.containsSeparator(ngram, startPos, endPos);
        if (isSourceSidePhrase) {
            this.addNewSrcPhrase(ngramOrder, offset);
        } else if (val instanceof FeaturePhraseTableValues && ((FeaturePhraseTableValues)val).features != null) {
            this.addFeaturesForWholePhrase(ngramOrder, offset, val);
            this.addPointerToTargetSidePhrase(ngramOrder, offset, contextOffset, word);
        } else if (ngramIsNew) {
            assert (val instanceof TargetTranslationsValues || ((FeaturePhraseTableValues)val).features == null);
            this.growValueIndexArrayIfNecessary(ngramOrder);
            this.valueIndexes[ngramOrder].setAndGrowIfNeeded((int)offset, Integer.MAX_VALUE);
        }
        return true;
    }

    private boolean containsSeparator(int[] ngram, int startPos, int endPos) {
        for (int i = startPos; i < endPos; ++i) {
            if (ngram[i] != this.separatorWord) continue;
            return true;
        }
        return false;
    }

    private void addNewSrcPhrase(int ngramOrder, long offset) {
        long currVal;
        this.growValueIndexArrayIfNecessary(ngramOrder);
        if (ngramOrder >= this.targetTranslations.length) {
            this.targetTranslations = Arrays.copyOf(this.targetTranslations, this.targetTranslations.length * 3 / 2);
        }
        if (this.targetTranslations[ngramOrder] == null) {
            this.targetTranslations[ngramOrder] = new ArrayList();
        }
        ArrayList<CustomWidthArray> targetTranslationPointersHere = this.targetTranslations[ngramOrder];
        long l = currVal = offset >= this.valueIndexes[ngramOrder].size() ? 0L : this.valueIndexes[ngramOrder].get((int)offset);
        if (currVal == 0L) {
            this.valueIndexes[ngramOrder].setAndGrowIfNeeded((int)offset, -this.targetTranslations[ngramOrder].size() - 1);
        }
        targetTranslationPointersHere.add(new CustomWidthArray(3L, 40));
    }

    private void addPointerToTargetSidePhrase(int ngramOrder, long offset, long contextOffset, int word) {
        int currWord = word;
        long srcPhraseOffset = contextOffset;
        int srcPhraseOrder = ngramOrder - 1;
        while (currWord != this.separatorWord) {
            currWord = this.map.getNextWord(srcPhraseOffset, srcPhraseOrder);
            srcPhraseOffset = this.map.getNextContextOffset(srcPhraseOffset, srcPhraseOrder);
            --srcPhraseOrder;
        }
        long valueIndex = -this.valueIndexes[srcPhraseOrder].get(srcPhraseOffset) - 1L;
        ArrayList<CustomWidthArray> targetTranslationPointersHere = this.targetTranslations[srcPhraseOrder];
        targetTranslationPointersHere.get((int)valueIndex).add(this.combineOrderAndOffset(ngramOrder, offset));
    }

    private long combineOrderAndOffset(int ngramOrder, long offset) {
        return (long)ngramOrder << 32 | offset;
    }

    private void addFeaturesForWholePhrase(int ngramOrder, long offset, PhraseTableValues val) {
        this.growValueIndexArrayIfNecessary(ngramOrder);
        if (ngramOrder >= this.features.length) {
            this.features = Arrays.copyOf(this.features, Math.max(ngramOrder + 1, this.features.length * 3 / 2));
        }
        if (this.features[ngramOrder] == null) {
            this.features[ngramOrder] = LongArray.StaticMethods.newLongArray(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        this.valueIndexes[ngramOrder].setAndGrowIfNeeded((int)offset, this.features[ngramOrder].size());
        for (int f = 0; f < this.numFeatures; ++f) {
            this.features[ngramOrder].add(Float.floatToIntBits(((FeaturePhraseTableValues)val).features[f]));
        }
    }

    private void growValueIndexArrayIfNecessary(int ngramOrder) {
        if (ngramOrder >= this.valueIndexes.length) {
            this.valueIndexes = Arrays.copyOf(this.valueIndexes, Math.max(ngramOrder + 1, this.valueIndexes.length * 3 / 2));
        }
        if (this.valueIndexes[ngramOrder] == null) {
            this.valueIndexes[ngramOrder] = LongArray.StaticMethods.newLongArray(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    @Override
    public void setSizeAtLeast(long size, int ngramOrder) {
    }

    @Override
    public void setFromOtherValues(ValueContainer<PhraseTableValues> other) {
        PhraseTableValueContainer other_ = (PhraseTableValueContainer)other;
        this.features = other_.features;
        this.targetTranslations = other_.targetTranslations;
        this.valueIndexes = other_.valueIndexes;
    }

    @Override
    public void trim() {
        for (int ngramOrder = 0; ngramOrder < this.features.length; ++ngramOrder) {
            if (this.features[ngramOrder] != null) {
                this.features[ngramOrder].trim();
            }
            if (this.valueIndexes[ngramOrder] != null) {
                this.valueIndexes[ngramOrder].trim();
            }
            if (ngramOrder >= this.targetTranslations.length || this.targetTranslations[ngramOrder] == null) continue;
            this.targetTranslations[ngramOrder].trimToSize();
            for (int j = 0; j < this.targetTranslations[ngramOrder].size(); ++j) {
                this.targetTranslations[ngramOrder].get(j).trim();
            }
        }
    }

    @Override
    public void setMap(NgramMap<PhraseTableValues> map) {
        this.map = (HashNgramMap)map;
    }

    public int getSeparatorWord() {
        return this.separatorWord;
    }

    @Override
    public void clearStorageForOrder(int ngramOrder) {
        this.features[ngramOrder] = null;
        this.valueIndexes[ngramOrder] = null;
        this.targetTranslations[ngramOrder] = null;
    }

    @Override
    public boolean storeSuffixoffsets() {
        return false;
    }

    @Override
    public int numValueBits(int ngramOrder) {
        return 0;
    }

    public static class TargetTranslationsValues
    implements PhraseTableValues {
        private static final long serialVersionUID = 1L;
        long[] targetTranslationOffsets;
        int[] targetTranslationOrders;
    }

    public static class FeaturePhraseTableValues
    implements PhraseTableValues {
        private static final long serialVersionUID = 1L;
        float[] features;

        public FeaturePhraseTableValues(float[] features) {
            this.features = features;
        }
    }

    public static interface PhraseTableValues
    extends Serializable {
    }
}

