/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.sax;

import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.Tag;
import org.xml.sax.helpers.NamespaceSupport;

public class Attributes
implements org.xml.sax.Attributes {
    protected Tag mTag;
    protected NamespaceSupport mSupport;
    protected String[] mParts;

    public Attributes(Tag tag, NamespaceSupport support, String[] parts) {
        this.mTag = tag;
        this.mSupport = support;
        this.mParts = parts;
    }

    @Override
    public int getLength() {
        return this.mTag.getAttributesEx().size() - 1;
    }

    @Override
    public String getURI(int index) {
        this.mSupport.processName(this.getQName(index), this.mParts, true);
        return this.mParts[0];
    }

    @Override
    public String getLocalName(int index) {
        this.mSupport.processName(this.getQName(index), this.mParts, true);
        return this.mParts[1];
    }

    @Override
    public String getQName(int index) {
        Attribute attribute = (Attribute)this.mTag.getAttributesEx().elementAt(index + 1);
        String ret = attribute.isWhitespace() ? "#text" : attribute.getName();
        return ret;
    }

    @Override
    public String getType(int index) {
        return "CDATA";
    }

    @Override
    public String getValue(int index) {
        Attribute attribute = (Attribute)this.mTag.getAttributesEx().elementAt(index + 1);
        String ret = attribute.getValue();
        if (null == ret) {
            ret = "";
        }
        return ret;
    }

    @Override
    public int getIndex(String uri, String localName) {
        int ret = -1;
        Vector attributes = this.mTag.getAttributesEx();
        if (null != attributes) {
            int size = attributes.size();
            for (int i = 1; i < size; ++i) {
                Attribute attribute = (Attribute)attributes.elementAt(i);
                String string = attribute.getName();
                if (null == string) continue;
                this.mSupport.processName(string, this.mParts, true);
                if (!(uri.equals(this.mParts[0]) & localName.equalsIgnoreCase(this.mParts[1]))) continue;
                ret = i;
                i = size;
            }
        }
        return ret;
    }

    @Override
    public int getIndex(String qName) {
        this.mSupport.processName(qName, this.mParts, true);
        return this.getIndex(this.mParts[0], this.mParts[1]);
    }

    @Override
    public String getType(String uri, String localName) {
        return null;
    }

    @Override
    public String getType(String qName) {
        return null;
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.mTag.getAttribute(localName);
    }

    @Override
    public String getValue(String qName) {
        this.mSupport.processName(qName, this.mParts, true);
        return this.getValue(this.mParts[0], this.mParts[1]);
    }
}

