/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.formatter;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.formatter.Formatter;

public class HtmlFormatter
implements Formatter {
    private PrintWriter writer;

    public HtmlFormatter(Writer writer) {
        this.writer = new PrintWriter(writer, true);
    }

    @Override
    public void format(List<Alignment> alignmentList) {
        this.writer.println("<html>");
        this.writer.println("<head>");
        this.writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        this.writer.println("</head>");
        this.writer.println("<body>");
        this.writer.println("<table border=\"1\" cellpadding=\"5\">");
        for (Alignment alignment : alignmentList) {
            this.writer.println("<tr>");
            this.formatStrings(alignment.getSourceSegmentList());
            this.formatStrings(alignment.getTargetSegmentList());
            this.writer.println("</tr>");
        }
        this.writer.println("</table>");
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    private void formatStrings(List<String> stringList) {
        this.writer.println("<td>");
        for (String string : stringList) {
            this.writer.println("<p>" + string + "</p>");
        }
        this.writer.println("</td>");
    }
}

