/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autocompleter;

import java.util.Arrays;

public class AutoCompleterItem {
    public final String payload;
    public final String[] extras;
    public final int cursorAdjust;
    public final boolean keepSelection;
    public final int replacementLength;

    public AutoCompleterItem(String payload, String[] extras, int replacementLength) {
        this.payload = payload;
        this.extras = extras;
        this.cursorAdjust = 0;
        this.keepSelection = false;
        this.replacementLength = replacementLength;
    }

    public AutoCompleterItem(String payload, String[] extras, int cursorAdjust, boolean keepSelection, int replacementLength) {
        this.payload = payload;
        this.extras = extras;
        this.cursorAdjust = cursorAdjust;
        this.keepSelection = keepSelection;
        this.replacementLength = replacementLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cursorAdjust;
        result = 31 * result + Arrays.hashCode(this.extras);
        result = 31 * result + (this.keepSelection ? 1231 : 1237);
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + this.replacementLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoCompleterItem other = (AutoCompleterItem)obj;
        if (this.cursorAdjust != other.cursorAdjust) {
            return false;
        }
        if (!Arrays.equals(this.extras, other.extras)) {
            return false;
        }
        if (this.keepSelection != other.keepSelection) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        return this.replacementLength == other.replacementLength;
    }
}

