/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.EncodingDetector;
import org.omegat.util.Log;
import org.omegat.util.MagicComment;
import org.omegat.util.StringUtil;

public final class GlossaryReaderTSV {
    private GlossaryReaderTSV() {
    }

    public static boolean createEmpty(File file) throws IOException {
        if (file.exists()) {
            return false;
        }
        file.getParentFile().mkdirs();
        if (file.createNewFile()) {
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("# Glossary in tab-separated format -*- coding: utf-8 -*-");
                writer.write(System.lineSeparator());
            }
            return true;
        }
        return false;
    }

    public static String getFileEncoding(File file) throws IOException {
        return GlossaryReaderTSV.getFileEncoding(file, Charset.defaultCharset().name());
    }

    public static String getFileEncoding(File file, String defaultEncoding) throws IOException {
        String fnameLower = file.getName().toLowerCase(Locale.ENGLISH);
        if (fnameLower.endsWith(".utf8")) {
            return StandardCharsets.UTF_8.name();
        }
        return GlossaryReaderTSV.detectEncodingDefault(file, defaultEncoding);
    }

    private static String detectEncodingDefault(File inFile, String defaultEncoding) {
        try {
            Map<String, String> magic = MagicComment.parse(inFile);
            String detected = magic.get("coding");
            if (detected != null) {
                return detected;
            }
        }
        catch (IOException e) {
            Log.log(e);
        }
        return EncodingDetector.detectEncodingDefault(inFile, defaultEncoding);
    }

    public static List<GlossaryEntry> read(File file, boolean priorityGlossary) throws IOException {
        String encoding = GlossaryReaderTSV.getFileEncoding(file);
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                if (!s.startsWith("#")) {
                    String[] tokens = s.split("\t");
                    for (int i = 0; i < tokens.length; ++i) {
                        tokens[i] = tokens[i].trim();
                    }
                    if (tokens.length >= 2 && !tokens[0].isEmpty()) {
                        String comment = "";
                        if (tokens.length >= 3) {
                            comment = tokens[2];
                        }
                        result.add(new GlossaryEntry(tokens[0], tokens[1], comment, priorityGlossary, file.getPath()));
                    }
                }
                s = in.readLine();
            }
        }
        return result;
    }

    public static synchronized void append(File file, GlossaryEntry newEntry) throws IOException {
        Charset encoding;
        if (!file.exists()) {
            GlossaryReaderTSV.createEmpty(file);
            encoding = StandardCharsets.UTF_8;
        } else {
            encoding = Charset.forName(GlossaryReaderTSV.getFileEncoding(file, StandardCharsets.UTF_8.name()));
        }
        if (encoding.equals(StandardCharsets.US_ASCII)) {
            encoding = StandardCharsets.UTF_8;
        }
        try (BufferedWriter wr = Files.newBufferedWriter(file.toPath(), encoding, StandardOpenOption.APPEND);){
            wr.append(newEntry.getSrcText()).append('\t').append(newEntry.getLocText());
            if (!StringUtil.isEmpty(newEntry.getCommentText())) {
                wr.append('\t').append(newEntry.getCommentText());
            }
            wr.append(System.lineSeparator());
        }
    }
}

