/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public final class ResourcesUtil {
    private static final String APP_ROOT = "/org/omegat/";
    private static final String RESOURCES = "/org/omegat/gui/resources/";
    public static final Image APP_ICON_32X32 = ResourcesUtil.getBundledImage("OmegaT.png");
    public static final Image APP_ICON_16X16 = ResourcesUtil.getBundledImage("OmegaT_small.png");

    private ResourcesUtil() {
    }

    public static Image getImage(String resourceName) {
        URL resourceURL = ResourcesUtil.class.getResource(resourceName);
        return Toolkit.getDefaultToolkit().getImage(resourceURL);
    }

    public static Image getBundledImage(String imageName) {
        return ResourcesUtil.getImage(RESOURCES + imageName);
    }

    public static Properties getBundleColorProperties(String style) throws IOException {
        String resourcePath = "/org/omegat/ColorScheme_" + style + ".properties";
        Properties properties = new Properties();
        try (InputStream is = ResourcesUtil.class.getResourceAsStream(resourcePath);){
            properties.load(is);
        }
        return properties;
    }
}

