/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;

public abstract class AbstractEndpointSnitch
implements IEndpointSnitch {
    @Override
    public abstract int compareEndpoints(InetAddress var1, InetAddress var2, InetAddress var3);

    @Override
    public List<InetAddress> getSortedListByProximity(InetAddress address, Collection<InetAddress> unsortedAddress) {
        ArrayList<InetAddress> preferred = new ArrayList<InetAddress>(unsortedAddress);
        this.sortByProximity(address, preferred);
        return preferred;
    }

    @Override
    public void sortByProximity(final InetAddress address, List<InetAddress> addresses) {
        Collections.sort(addresses, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress a1, InetAddress a2) {
                return AbstractEndpointSnitch.this.compareEndpoints(address, a1, a2);
            }
        });
    }

    @Override
    public void gossiperStarting() {
    }

    @Override
    public boolean isWorthMergingForRangeQuery(List<InetAddress> merged, List<InetAddress> l1, List<InetAddress> l2) {
        boolean mergedHasRemote = this.hasRemoteNode(merged);
        return mergedHasRemote ? this.hasRemoteNode(l1) || this.hasRemoteNode(l2) : true;
    }

    private boolean hasRemoteNode(List<InetAddress> l) {
        String localDc = DatabaseDescriptor.getLocalDataCenter();
        for (InetAddress ep : l) {
            if (localDc.equals(this.getDatacenter(ep))) continue;
            return true;
        }
        return false;
    }
}

