/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.compress;

import com.google.common.base.Throwables;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamReader;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.compress.CompressedInputStream;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.streaming.messages.FileMessageHeader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.BytesReadTracker;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedStreamReader
extends StreamReader {
    private static final Logger logger = LoggerFactory.getLogger(CompressedStreamReader.class);
    protected final CompressionInfo compressionInfo;

    public CompressedStreamReader(FileMessageHeader header, StreamSession session) {
        super(header, session);
        this.compressionInfo = header.compressionInfo;
    }

    @Override
    public SSTableWriter read(ReadableByteChannel channel) throws IOException {
        long totalSize = this.totalSize();
        Pair<String, String> kscf = Schema.instance.getCF(this.cfId);
        ColumnFamilyStore cfs = null;
        if (kscf != null) {
            cfs = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
        }
        if (kscf == null || cfs == null) {
            throw new IOException("CF " + this.cfId + " was dropped during streaming");
        }
        logger.debug("[Stream #{}] Start receiving file #{} from {}, repairedAt = {}, size = {}, ks = '{}', table = '{}'.", new Object[]{this.session.planId(), this.fileSeqNum, this.session.peer, this.repairedAt, totalSize, cfs.keyspace.getName(), cfs.getColumnFamilyName()});
        CompressedInputStream cis = new CompressedInputStream(Channels.newInputStream(channel), this.compressionInfo);
        BytesReadTracker in = new BytesReadTracker(new DataInputStream(cis));
        SSTableWriter writer = null;
        DecoratedKey key = null;
        try {
            writer = this.createWriter(cfs, totalSize, this.repairedAt, this.format);
            int sectionIdx = 0;
            for (Pair section : this.sections) {
                assert (cis.getTotalCompressedBytesRead() <= totalSize);
                long sectionLength = (Long)section.right - (Long)section.left;
                logger.trace("[Stream #{}] Reading section {} with length {} from stream.", new Object[]{this.session.planId(), sectionIdx++, sectionLength});
                cis.position((Long)section.left);
                in.reset(0L);
                while (in.getBytesRead() < sectionLength) {
                    key = StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(in));
                    this.writeRow(key, writer, in, cfs);
                    this.session.progress(this.desc, ProgressInfo.Direction.IN, cis.getTotalCompressedBytesRead(), totalSize);
                }
            }
            logger.debug("[Stream #{}] Finished receiving file #{} from {} readBytes = {}, totalSize = {}", new Object[]{this.session.planId(), this.fileSeqNum, this.session.peer, cis.getTotalCompressedBytesRead(), totalSize});
            return writer;
        }
        catch (Throwable e) {
            if (key != null) {
                logger.warn("[Stream {}] Error while reading partition {} from stream on ks='{}' and table='{}'.", new Object[]{this.session.planId(), key, cfs.keyspace.getName(), cfs.getColumnFamilyName()});
            }
            if (writer != null) {
                try {
                    writer.abort();
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
            }
            if (org.apache.cassandra.utils.Throwables.extractIOExceptionCause(e).isPresent()) {
                throw e;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected long totalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }
}

