/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import org.caffinitas.ohc.linked.KeyBuffer;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class HashEntries {
    HashEntries() {
    }

    static void init(long hash, long keyLen, long valueLen, long hashEntryAdr, int sentinel) {
        Uns.putLong(hashEntryAdr, 32L, hash);
        HashEntries.setNext(hashEntryAdr, 0L);
        Uns.putLong(hashEntryAdr, 48L, keyLen);
        Uns.putLong(hashEntryAdr, 40L, valueLen);
        Uns.putInt(hashEntryAdr, 24L, 1);
        Uns.putInt(hashEntryAdr, 28L, sentinel);
    }

    static boolean compareKey(long hashEntryAdr, KeyBuffer key, long serKeyLen) {
        if (hashEntryAdr == 0L) {
            return false;
        }
        long blkOff = 56L;
        int p = 0;
        byte[] arr = key.array();
        while ((long)p <= serKeyLen - 8L) {
            if (Uns.getLong(hashEntryAdr, blkOff) != Uns.getLongFromByteArray(arr, p)) {
                return false;
            }
            p += 8;
            blkOff += 8L;
        }
        while ((long)p <= serKeyLen - 4L) {
            if (Uns.getInt(hashEntryAdr, blkOff) != Uns.getIntFromByteArray(arr, p)) {
                return false;
            }
            p += 4;
            blkOff += 4L;
        }
        while ((long)p <= serKeyLen - 2L) {
            if (Uns.getShort(hashEntryAdr, blkOff) != Uns.getShortFromByteArray(arr, p)) {
                return false;
            }
            p += 2;
            blkOff += 2L;
        }
        while ((long)p < serKeyLen) {
            if (Uns.getByte(hashEntryAdr, blkOff) != arr[p]) {
                return false;
            }
            ++p;
            ++blkOff;
        }
        return true;
    }

    static boolean compare(long hashEntryAdr, long offset, long otherHashEntryAdr, long otherOffset, long len) {
        if (hashEntryAdr == 0L) {
            return false;
        }
        int p = 0;
        while ((long)p <= len - 8L) {
            if (Uns.getLong(hashEntryAdr, offset) != Uns.getLong(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 8;
            offset += 8L;
            otherOffset += 8L;
        }
        while ((long)p <= len - 4L) {
            if (Uns.getInt(hashEntryAdr, offset) != Uns.getInt(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 4;
            offset += 4L;
            otherOffset += 4L;
        }
        while ((long)p <= len - 2L) {
            if (Uns.getShort(hashEntryAdr, offset) != Uns.getShort(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 2;
            offset += 2L;
            otherOffset += 2L;
        }
        while ((long)p < len) {
            if (Uns.getByte(hashEntryAdr, offset) != Uns.getByte(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            ++p;
            ++offset;
            ++otherOffset;
        }
        return true;
    }

    public static long getLRUNext(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 0L);
    }

    public static void setLRUNext(long hashEntryAdr, long replacement) {
        Uns.putLong(hashEntryAdr, 0L, replacement);
    }

    public static long getAndSetLRUNext(long hashEntryAdr, long replacement) {
        return Uns.getAndPutLong(hashEntryAdr, 0L, replacement);
    }

    public static long getLRUPrev(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 8L);
    }

    public static void setLRUPrev(long hashEntryAdr, long replacement) {
        Uns.putLong(hashEntryAdr, 8L, replacement);
    }

    public static long getAndSetLRUPrev(long hashEntryAdr, long replacement) {
        return Uns.getAndPutLong(hashEntryAdr, 8L, replacement);
    }

    static long getHash(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 32L);
    }

    static long getNext(long hashEntryAdr) {
        return hashEntryAdr != 0L ? Uns.getLong(hashEntryAdr, 16L) : 0L;
    }

    static int getSentinel(long hashEntryAdr) {
        return hashEntryAdr != 0L ? Uns.getInt(hashEntryAdr, 28L) : 0;
    }

    static void setSentinel(long hashEntryAdr, int sentinelState) {
        if (hashEntryAdr != 0L) {
            Uns.putInt(hashEntryAdr, 28L, sentinelState);
        }
    }

    static void setNext(long hashEntryAdr, long nextAdr) {
        if (hashEntryAdr == nextAdr) {
            throw new IllegalArgumentException();
        }
        if (hashEntryAdr != 0L) {
            Uns.putLong(hashEntryAdr, 16L, nextAdr);
        }
    }

    static long getKeyLen(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 48L);
    }

    static long getValueLen(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 40L);
    }

    static long getAllocLen(long address) {
        return Util.allocLen(HashEntries.getKeyLen(address), HashEntries.getValueLen(address));
    }

    static void reference(long hashEntryAdr) {
        Uns.increment(hashEntryAdr, 24L);
    }

    static boolean dereference(long hashEntryAdr) {
        if (Uns.decrement(hashEntryAdr, 24L)) {
            Uns.free(hashEntryAdr);
            return true;
        }
        return false;
    }
}

