/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

class EndpointStateSerializer
implements IVersionedSerializer<EndpointState> {
    EndpointStateSerializer() {
    }

    @Override
    public void serialize(EndpointState epState, DataOutputPlus out, int version) throws IOException {
        HeartBeatState hbState = epState.getHeartBeatState();
        HeartBeatState.serializer.serialize(hbState, out, version);
        Set<Map.Entry<ApplicationState, VersionedValue>> states = epState.states();
        out.writeInt(states.size());
        for (Map.Entry<ApplicationState, VersionedValue> state : states) {
            VersionedValue value = state.getValue();
            out.writeInt(state.getKey().ordinal());
            VersionedValue.serializer.serialize(value, out, version);
        }
    }

    @Override
    public EndpointState deserialize(DataInputPlus in, int version) throws IOException {
        HeartBeatState hbState = HeartBeatState.serializer.deserialize(in, version);
        int appStateSize = in.readInt();
        EnumMap<ApplicationState, VersionedValue> states = new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class);
        for (int i = 0; i < appStateSize; ++i) {
            int key = in.readInt();
            VersionedValue value = VersionedValue.serializer.deserialize(in, version);
            states.put(Gossiper.STATES[key], value);
        }
        return new EndpointState(hbState, states);
    }

    @Override
    public long serializedSize(EndpointState epState, int version) {
        long size = HeartBeatState.serializer.serializedSize(epState.getHeartBeatState(), version);
        Set<Map.Entry<ApplicationState, VersionedValue>> states = epState.states();
        size += (long)TypeSizes.sizeof(states.size());
        for (Map.Entry<ApplicationState, VersionedValue> state : states) {
            VersionedValue value = state.getValue();
            size += (long)TypeSizes.sizeof(state.getKey().ordinal());
            size += VersionedValue.serializer.serializedSize(value, version);
        }
        return size;
    }
}

