/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineStatement;

public class BrokeredStatement
implements EngineStatement {
    final BrokeredStatementControl control;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private String cursorName;
    private Boolean escapeProcessing;

    BrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        this.control = brokeredStatementControl;
        this.resultSetType = this.getResultSetType();
        this.resultSetConcurrency = this.getResultSetConcurrency();
        this.resultSetHoldability = this.getResultSetHoldability();
    }

    public final void addBatch(String string) throws SQLException {
        this.getStatement().addBatch(string);
    }

    public final void clearBatch() throws SQLException {
        this.getStatement().clearBatch();
    }

    public final int[] executeBatch() throws SQLException {
        return this.getStatement().executeBatch();
    }

    public final void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    public final boolean execute(String string) throws SQLException {
        return this.getStatement().execute(string);
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        return this.wrapResultSet(this.getStatement().executeQuery(string));
    }

    public final int executeUpdate(String string) throws SQLException {
        return this.getStatement().executeUpdate(string);
    }

    public void close() throws SQLException {
        this.control.closeRealStatement();
    }

    public final Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    public final int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    public final int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    public final int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    public final int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    public final int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    public final void setMaxFieldSize(int n) throws SQLException {
        this.getStatement().setMaxFieldSize(n);
    }

    public final void setMaxRows(int n) throws SQLException {
        this.getStatement().setMaxRows(n);
    }

    public final void setEscapeProcessing(boolean bl) throws SQLException {
        this.getStatement().setEscapeProcessing(bl);
        this.escapeProcessing = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    public final void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    public final void setCursorName(String string) throws SQLException {
        this.getStatement().setCursorName(string);
        this.cursorName = string;
    }

    public final ResultSet getResultSet() throws SQLException {
        return this.wrapResultSet(this.getStatement().getResultSet());
    }

    public final int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    public final int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    public final void setFetchDirection(int n) throws SQLException {
        this.getStatement().setFetchDirection(n);
    }

    public final void setFetchSize(int n) throws SQLException {
        this.getStatement().setFetchSize(n);
    }

    public final int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    public final void setQueryTimeout(int n) throws SQLException {
        this.getStatement().setQueryTimeout(n);
    }

    public final boolean execute(String string, int n) throws SQLException {
        return this.getStatement().execute(string, n);
    }

    public final boolean execute(String string, int[] nArray) throws SQLException {
        return this.getStatement().execute(string, nArray);
    }

    public final boolean execute(String string, String[] stringArray) throws SQLException {
        return this.getStatement().execute(string, stringArray);
    }

    public final int executeUpdate(String string, int n) throws SQLException {
        int n2 = this.getStatement().executeUpdate(string, n);
        return n2;
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.getStatement().executeUpdate(string, nArray);
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.getStatement().executeUpdate(string, stringArray);
    }

    public final boolean getMoreResults(int n) throws SQLException {
        return ((EngineStatement)this.getStatement()).getMoreResults(n);
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.getStatement().getGeneratedKeys());
    }

    public final int getResultSetHoldability() throws SQLException {
        int n = ((EngineStatement)this.getStatement()).getResultSetHoldability();
        return this.controlCheck().checkHoldCursors(n);
    }

    public Statement createDuplicateStatement(Connection connection, Statement statement) throws SQLException {
        Statement statement2 = connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.setStatementState(statement, statement2);
        return statement2;
    }

    void setStatementState(Statement statement, Statement statement2) throws SQLException {
        if (this.cursorName != null) {
            statement2.setCursorName(this.cursorName);
        }
        if (this.escapeProcessing != null) {
            statement2.setEscapeProcessing(this.escapeProcessing);
        }
        statement2.setFetchDirection(statement.getFetchDirection());
        statement2.setFetchSize(statement.getFetchSize());
        statement2.setMaxFieldSize(statement.getMaxFieldSize());
        statement2.setMaxRows(statement.getMaxRows());
        statement2.setQueryTimeout(statement.getQueryTimeout());
    }

    public Statement getStatement() throws SQLException {
        return this.control.getRealStatement();
    }

    final ResultSet wrapResultSet(ResultSet resultSet) {
        return this.control.wrapResultSet(this, resultSet);
    }

    final BrokeredStatementControl controlCheck() throws SQLException {
        this.getStatement().getConnection();
        return this.control;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        this.checkIfClosed();
        return clazz.isInstance(this);
    }

    public final boolean isClosed() throws SQLException {
        return ((EngineStatement)this.getStatement()).isClosed();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw this.control.getExceptionFactory().getSQLException("XJ012.S", null, null, new Object[]{"Statement"});
        }
    }

    final SQLException unableToUnwrap(Class clazz) {
        return this.control.getExceptionFactory().getSQLException("XJ128.S", null, null, new Object[]{clazz});
    }

    public void closeOnCompletion() throws SQLException {
        ((EngineStatement)this.getStatement()).closeOnCompletion();
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return ((EngineStatement)this.getStatement()).isCloseOnCompletion();
    }
}

