/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.queryparser.surround.parser.ParseException;
import org.apache.lucene.queryparser.surround.parser.QueryParser;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryparser.surround.query.SrndQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurroundQParserPlugin
extends QParserPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NAME = "surround";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new SurroundQParser(qstr, localParams, params, req);
    }

    static class SurroundQParser
    extends QParser {
        protected static final Logger LOG = SurroundQParserPlugin.access$000();
        static final int DEFMAXBASICQUERIES = 1000;
        static final String MBQParam = "maxBasicQueries";
        String sortStr;
        SolrQueryParser lparser;
        int maxBasicQueries;

        public SurroundQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            SrndQuery sq;
            String qstr = this.getString();
            if (qstr == null) {
                return null;
            }
            String mbqparam = this.getParam(MBQParam);
            if (mbqparam == null) {
                this.maxBasicQueries = 1000;
            } else {
                try {
                    this.maxBasicQueries = Integer.parseInt(mbqparam);
                }
                catch (Exception e) {
                    log.warn("Couldn't parse maxBasicQueries value {}, using default of 1000", (Object)mbqparam);
                    this.maxBasicQueries = 1000;
                }
            }
            try {
                sq = QueryParser.parse((String)qstr);
            }
            catch (ParseException pe) {
                throw new SyntaxError(pe);
            }
            BasicQueryFactory bqFactory = new BasicQueryFactory(this.maxBasicQueries);
            String defaultField = this.getParam("df");
            Query lquery = sq.makeLuceneQueryField(defaultField, bqFactory);
            return lquery;
        }
    }
}

