/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;

final class ApplicationDispatcher
implements RequestDispatcher {
    private Log log = null;
    private Context context = null;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private String pathInfo = null;
    private String queryString = null;
    private String requestURI = null;
    private String servletPath = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;
    private Wrapper wrapper = null;

    public ApplicationDispatcher(Wrapper wrapper, String requestURI, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.log = this.context.getLogger();
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        this.support = wrapper instanceof StandardWrapper ? ((StandardWrapper)wrapper).getInstanceSupport() : new InstanceSupport(wrapper);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + queryString + ", name=" + this.name));
        }
    }

    public String getInfo() {
        return info;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedForward dp = new PrivilegedForward(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doForward(request, response);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ApplicationHttpRequest wrequest;
        if (response.isCommitted()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"  Forward on committed response --> ISE");
            }
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        try {
            response.resetBuffer();
        }
        catch (IllegalStateException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("  Forward resetBuffer() returned ISE: " + e));
            }
            throw e;
        }
        State state = new State(request, response, false);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state);
        if (this.servletPath == null && this.pathInfo == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)" Named Dispatcher Forward");
            }
            wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            HttpServletRequest hrequest = state.hrequest;
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)" Path Based Forward");
            }
            wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String contextPath = this.context.getPath();
            HttpServletRequest hrequest = state.hrequest;
            if (hrequest.getAttribute("javax.servlet.forward.request_uri") == null) {
                wrequest.setAttribute("javax.servlet.forward.request_uri", hrequest.getRequestURI());
                wrequest.setAttribute("javax.servlet.forward.context_path", hrequest.getContextPath());
                wrequest.setAttribute("javax.servlet.forward.servlet_path", hrequest.getServletPath());
                wrequest.setAttribute("javax.servlet.forward.path_info", hrequest.getPathInfo());
                wrequest.setAttribute("javax.servlet.forward.query_string", hrequest.getQueryString());
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            this.processRequest(request, response, state);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)" Disabling the response for futher output");
        }
        if (response instanceof ResponseFacade) {
            ((ResponseFacade)response).finish();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" The Response is vehiculed using a wrapper: " + response.getClass().getName()));
            }
            try {
                PrintWriter writer = response.getWriter();
                writer.close();
            }
            catch (IllegalStateException e) {
                try {
                    ServletOutputStream stream = response.getOutputStream();
                    stream.close();
                }
                catch (IllegalStateException f) {
                }
                catch (IOException f) {}
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        Integer disInt = (Integer)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        if (disInt != null) {
            if (disInt != 1) {
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.servletPath);
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)new Integer(2));
                this.invoke(state.outerRequest, response, state);
            } else {
                this.invoke(state.outerRequest, response, state);
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, true);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state);
        if (this.name != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)" Named Dispatcher Include");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", new Integer(4));
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.servletPath);
            this.invoke(state.outerRequest, state.outerResponse, state);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)" Path Based Include");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String contextPath = this.context.getPath();
            if (this.requestURI != null) {
                wrequest.setAttribute("javax.servlet.include.request_uri", this.requestURI);
            }
            if (contextPath != null) {
                wrequest.setAttribute("javax.servlet.include.context_path", contextPath);
            }
            if (this.servletPath != null) {
                wrequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                wrequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                wrequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", new Integer(4));
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.servletPath);
            this.invoke(state.outerRequest, state.outerResponse, state);
        }
    }

    private void invoke(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        ClassLoader contextClassLoader;
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        if (oldCCL != (contextClassLoader = this.context.getLoader().getClassLoader())) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        } else {
            oldCCL = null;
        }
        HttpServletResponse hresponse = state.hresponse;
        Servlet servlet = null;
        IOException ioException = null;
        Throwable servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            this.wrapper.getLogger().warn((Object)sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            long available = this.wrapper.getAvailable();
            if (available > 0L && available < Long.MAX_VALUE) {
                hresponse.setDateHeader("Retry-After", available);
            }
            hresponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), StandardWrapper.getRootCause(e));
            servletException = e;
        }
        catch (Throwable e) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servlet = null;
        }
        ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
        ApplicationFilterChain filterChain = factory.createFilterChain(request, this.wrapper, servlet);
        try {
            String jspFile = this.wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
            } else {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            this.support.fireInstanceEvent("beforeDispatch", servlet, request, response);
            if (servlet != null && filterChain != null) {
                filterChain.doFilter(request, response);
            }
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
        }
        catch (ClientAbortException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            ioException = e;
        }
        catch (IOException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), (Throwable)e);
            ioException = e;
        }
        catch (UnavailableException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), (Throwable)e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            Throwable rootCause = StandardWrapper.getRootCause(e);
            if (!(rootCause instanceof ClientAbortException)) {
                this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), rootCause);
            }
            servletException = e;
        }
        catch (RuntimeException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), (Throwable)e);
            runtimeException = e;
        }
        try {
            if (filterChain != null) {
                filterChain.release();
            }
        }
        catch (Throwable e) {
            this.log.error((Object)sm.getString("standardWrapper.releaseFilters", this.wrapper.getName()), e);
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), (Throwable)e);
            servletException = e;
        }
        catch (Throwable e) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
        }
        if (oldCCL != null) {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        this.unwrapRequest(state);
        this.unwrapResponse(state);
        this.recycleRequestWrapper(state);
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !(current instanceof Request) && !(current instanceof RequestFacade)) {
            if (current == state.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    state.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && !(current instanceof Response) && !(current instanceof ResponseFacade)) {
            if (current == state.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    state.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state) {
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null) {
            if (state.hrequest == null && current instanceof HttpServletRequest) {
                state.hrequest = (HttpServletRequest)current;
            }
            if ("org.apache.catalina.servlets.InvokerHttpRequest".equals(current.getClass().getName()) || !(current instanceof ServletRequestWrapper) || current instanceof ApplicationHttpRequest || current instanceof ApplicationRequest || current instanceof Request) break;
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        Object wrapper = null;
        if (current instanceof ApplicationHttpRequest || current instanceof Request || current instanceof HttpServletRequest) {
            HttpServletRequest hcurrent = (HttpServletRequest)current;
            boolean crossContext = false;
            if (state.outerRequest instanceof ApplicationHttpRequest || state.outerRequest instanceof Request || state.outerRequest instanceof HttpServletRequest) {
                HttpServletRequest houterRequest = (HttpServletRequest)state.outerRequest;
                Object contextPath = houterRequest.getAttribute("javax.servlet.include.context_path");
                if (contextPath == null) {
                    contextPath = houterRequest.getContextPath();
                }
                crossContext = !this.context.getPath().equals(contextPath);
            }
            wrapper = new ApplicationHttpRequest(hcurrent, this.context, crossContext);
        } else {
            wrapper = new ApplicationRequest(current);
        }
        if (previous == null) {
            state.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest((ServletRequest)wrapper);
        }
        state.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null) {
            if (state.hresponse == null && current instanceof HttpServletResponse) {
                state.hresponse = (HttpServletResponse)current;
                if (!state.including) {
                    return null;
                }
            }
            if (!(current instanceof ServletResponseWrapper) || current instanceof ApplicationHttpResponse || current instanceof ApplicationResponse || current instanceof Response) break;
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        Object wrapper = null;
        wrapper = current instanceof ApplicationHttpResponse || current instanceof Response || current instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current, state.including) : new ApplicationResponse(current, state.including);
        if (previous == null) {
            state.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse((ServletResponse)wrapper);
        }
        state.wrapResponse = wrapper;
        return wrapper;
    }

    private void checkSameObjects(ServletRequest appRequest, ServletResponse appResponse) throws ServletException {
        ServletRequest originalRequest = ApplicationFilterChain.getLastServicedRequest();
        ServletResponse originalResponse = ApplicationFilterChain.getLastServicedResponse();
        if (originalRequest == null || originalResponse == null) {
            return;
        }
        boolean same = false;
        ServletRequest dispatchedRequest = appRequest;
        while (originalRequest instanceof ServletRequestWrapper && ((ServletRequestWrapper)originalRequest).getRequest() != null) {
            originalRequest = ((ServletRequestWrapper)originalRequest).getRequest();
        }
        while (!same) {
            if (originalRequest.equals(dispatchedRequest)) {
                same = true;
            }
            if (same || !(dispatchedRequest instanceof ServletRequestWrapper)) break;
            dispatchedRequest = ((ServletRequestWrapper)dispatchedRequest).getRequest();
        }
        if (!same) {
            throw new ServletException(sm.getString("applicationDispatcher.specViolation.request"));
        }
        same = false;
        ServletResponse dispatchedResponse = appResponse;
        while (originalResponse instanceof ServletResponseWrapper && ((ServletResponseWrapper)originalResponse).getResponse() != null) {
            originalResponse = ((ServletResponseWrapper)originalResponse).getResponse();
        }
        while (!same) {
            if (originalResponse.equals(dispatchedResponse)) {
                same = true;
            }
            if (same || !(dispatchedResponse instanceof ServletResponseWrapper)) break;
            dispatchedResponse = ((ServletResponseWrapper)dispatchedResponse).getResponse();
        }
        if (!same) {
            throw new ServletException(sm.getString("applicationDispatcher.specViolation.response"));
        }
    }

    private void recycleRequestWrapper(State state) {
        if (state.wrapRequest instanceof ApplicationHttpRequest) {
            ((ApplicationHttpRequest)state.wrapRequest).recycle();
        }
    }

    private class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        boolean including = false;
        HttpServletRequest hrequest = null;
        HttpServletResponse hresponse = null;

        State(ServletRequest request, ServletResponse response, boolean including) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.including = including;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedForward(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws Exception {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }
}

