/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.store.leveldb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.activemq.apollo.broker.store.leveldb.LevelDBClient$;
import org.apache.activemq.apollo.broker.store.leveldb.RecordLog$;
import org.apache.activemq.apollo.broker.store.leveldb.RecordLog$LogReader$;
import org.apache.activemq.apollo.broker.store.leveldb.RecordLog$log_mutex$;
import org.apache.activemq.apollo.util.FileSupport$;
import org.apache.activemq.apollo.util.LRUCache;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferEditor;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.BaseRetained;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011\u001dw!B\u0001\u0003\u0011\u000b\t\u0012!\u0003*fG>\u0014H\rT8h\u0015\t\u0019A!A\u0004mKZ,G\u000e\u001a2\u000b\u0005\u00151\u0011!B:u_J,'BA\u0004\t\u0003\u0019\u0011'o\\6fe*\u0011\u0011BC\u0001\u0007CB|G\u000e\\8\u000b\u0005-a\u0011\u0001C1di&4X-\\9\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001!\t\u00112#D\u0001\u0003\r\u0015!\"\u0001#\u0002\u0016\u0005%\u0011VmY8sI2{wmE\u0003\u0014-y!#\u0006\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\r=\u0013'.Z2u!\ty\"%D\u0001!\u0015\t\t\u0003\"\u0001\u0003vi&d\u0017BA\u0012!\u0005\raun\u001a\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0005\u0002&W%\u0011AF\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006]M!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003EAq!M\nC\u0002\u0013\u0005!'A\tM\u001f\u001e{\u0006*R!E\u000bJ{\u0006KU#G\u0013b+\u0012a\r\t\u0003KQJ!!\u000e\u0014\u0003\t\tKH/\u001a\u0005\u0007oM\u0001\u000b\u0011B\u001a\u0002%1{ui\u0018%F\u0003\u0012+%k\u0018)S\u000b\u001aK\u0005\f\t\u0005\bsM\u0011\r\u0011\"\u00013\u00039)vjV0F\u001d\u0012{&+R\"P%\u0012CaaO\n!\u0002\u0013\u0019\u0014aD+P/~+e\nR0S\u000b\u000e{%\u000b\u0012\u0011\t\u000fu\u001a\"\u0019!C\u0001}\u0005yAjT$`\u0011\u0016\u000bE)\u0012*`'&SV)F\u0001@!\t)\u0003)\u0003\u0002BM\t\u0019\u0011J\u001c;\t\r\r\u001b\u0002\u0015!\u0003@\u0003AaujR0I\u000b\u0006#UIU0T\u0013j+\u0005\u0005C\u0004F'\t\u0007I\u0011\u0001 \u0002\u0017\t+fIR#S?NK%,\u0012\u0005\u0007\u000fN\u0001\u000b\u0011B \u0002\u0019\t+fIR#S?NK%,\u0012\u0011\t\u000f%\u001b\"\u0019!C\u0001}\u0005\u0011\")\u0017)B'N{&)\u0016$G\u000bJ{6+\u0013.F\u0011\u0019Y5\u0003)A\u0005\u007f\u0005\u0019\")\u0017)B'N{&)\u0016$G\u000bJ{6+\u0013.FA\u0019!Qj\u0005!O\u0005\u001daunZ%oM>\u001cR\u0001\u0014\f%\u001f*\u0002\"!\n)\n\u0005E3#a\u0002)s_\u0012,8\r\u001e\u0005\t'2\u0013)\u001a!C\u0001)\u0006!a-\u001b7f+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-\u001b\u0003\tIw.\u0003\u0002[/\n!a)\u001b7f\u0011!aFJ!E!\u0002\u0013)\u0016!\u00024jY\u0016\u0004\u0003\u0002\u00030M\u0005+\u0007I\u0011A0\u0002\u0011A|7/\u001b;j_:,\u0012\u0001\u0019\t\u0003K\u0005L!A\u0019\u0014\u0003\t1{gn\u001a\u0005\tI2\u0013\t\u0012)A\u0005A\u0006I\u0001o\\:ji&|g\u000e\t\u0005\tM2\u0013)\u001a!C\u0001?\u00061A.\u001a8hi\"D\u0001\u0002\u001b'\u0003\u0012\u0003\u0006I\u0001Y\u0001\bY\u0016tw\r\u001e5!\u0011\u0015qC\n\"\u0001k)\u0011YWN\\8\u0011\u00051dU\"A\n\t\u000bMK\u0007\u0019A+\t\u000byK\u0007\u0019\u00011\t\u000b\u0019L\u0007\u0019\u00011\t\u000bEdE\u0011A0\u0002\u000b1LW.\u001b;\t\u000fMd\u0015\u0011!C\u0001i\u0006!1m\u001c9z)\u0011YWO^<\t\u000fM\u0013\b\u0013!a\u0001+\"9aL\u001dI\u0001\u0002\u0004\u0001\u0007b\u00024s!\u0003\u0005\r\u0001\u0019\u0005\bs2\u000b\n\u0011\"\u0001{\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001f\u0016\u0003+r\\\u0013! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0002'\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0013y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0002'\u0012\u0002\u0013\u0005\u0011qB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tB\u000b\u0002ay\"I\u0011Q\u0003'\u0012\u0002\u0013\u0005\u0011qB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011\u001d\tI\u0002\u0014C!\u00037\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u007f!9\u0011q\u0004'\u0005B\u0005\u0005\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wq1!JA\u0014\u0013\r\tICJ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%b\u0005C\u0004\u000241#\t%!\u000e\u0002\r\u0015\fX/\u00197t)\u0011\t9$!\u0010\u0011\u0007\u0015\nI$C\u0002\u0002<\u0019\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002@\u0005E\u0012\u0011!a\u0001\u0003\u0003\n1\u0001\u001f\u00132!\r)\u00131I\u0005\u0004\u0003\u000b2#aA!os\"9\u0011\u0011\n'\u0005B\u0005-\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002NA\u0019q#a\u0014\n\u0007\u00055\u0002\u0004\u0003\u0004\u0002T1#\tEP\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\b\u0003/bE\u0011IA-\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0011\u0002\\!I\u0011qHA+\u0003\u0003\u0005\ra\u0010\u0005\b\u0003?bE\u0011IA1\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001c\u0003GB!\"a\u0010\u0002^\u0005\u0005\t\u0019AA!\u000f%\t9gEA\u0001\u0012\u000b\tI'A\u0004M_\u001eLeNZ8\u0011\u00071\fYG\u0002\u0005N'\u0005\u0005\tRAA7'\u0019\tY'a\u001c%UAA\u0011\u0011OA<+\u0002\u00047.\u0004\u0002\u0002t)\u0019\u0011Q\u000f\u0014\u0002\u000fI,h\u000e^5nK&!\u0011\u0011PA:\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b]\u0005-D\u0011AA?)\t\tI\u0007\u0003\u0005\u0002 \u0005-DQIAA)\t\ti\u0005\u0003\u0006\u0002\u0006\u0006-\u0014\u0011!CA\u0003\u000f\u000bQ!\u00199qYf$ra[AE\u0003\u0017\u000bi\t\u0003\u0004T\u0003\u0007\u0003\r!\u0016\u0005\u0007=\u0006\r\u0005\u0019\u00011\t\r\u0019\f\u0019\t1\u0001a\u0011)\t\t*a\u001b\u0002\u0002\u0013\u0005\u00151S\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)*!)\u0011\u000b\u0015\n9*a'\n\u0007\u0005eeE\u0001\u0004PaRLwN\u001c\t\u0007K\u0005uU\u000b\u00191\n\u0007\u0005}eE\u0001\u0004UkBdWm\r\u0005\b\u0003G\u000by\t1\u0001l\u0003\rAH\u0005\r\u0005\t\u0003O\u000bY\u0007\"\u0005\u0002*\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u00051\u0002bBAW'\u0011\u0005\u0011qV\u0001\fK:\u001cw\u000eZ3`Y>tw\r\u0006\u0003\u00022\u0006\u0005\u0007\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\bQ\u0006<HOY;g\u0015\r\tYLD\u0001\u000bMV\u001cXm]8ve\u000e,\u0017\u0002BA`\u0003k\u0013aAQ;gM\u0016\u0014\bbBAb\u0003W\u0003\r\u0001Y\u0001\u0003CFBq!a2\u0014\t\u0003\tI-A\u0006eK\u000e|G-Z0m_:<Gc\u00011\u0002L\"A\u0011QZAc\u0001\u0004\t\t,A\u0003wC2,X\rC\u0005\u0002RN\u0019\r\u0011\"\u0002\u0002T\u0006\u0011B%\u001a8bE2,w,Y:tKJ$\u0018n\u001c8t+\t\t9\u0004\u0003\u0005\u0002XN\u0001\u000bQBA\u001c\u0003M!SM\\1cY\u0016|\u0016m]:feRLwN\\:!\u0011%\t)iEA\u0001\n\u0003\u000bY\u000e\u0006\u0004\u0002^\u0012]F\u0011\u0018\t\u0004%\u0005}g!\u0002\u000b\u0003\u0001\u0006\u00058CBAp-\u0011z%\u0006\u0003\u0006\u0002f\u0006}'Q3A\u0005\u0002Q\u000b\u0011\u0002Z5sK\u000e$xN]=\t\u0015\u0005%\u0018q\u001cB\tB\u0003%Q+\u0001\u0006eSJ,7\r^8ss\u0002B1\"!<\u0002`\nU\r\u0011\"\u0001\u0002p\u0006IAn\\4Tk\u001a4\u0017\u000e_\u000b\u0003\u0003GA1\"a=\u0002`\nE\t\u0015!\u0003\u0002$\u0005QAn\\4Tk\u001a4\u0017\u000e\u001f\u0011\t\u000f9\ny\u000e\"\u0001\u0002xR1\u0011Q\\A}\u0003wDq!!:\u0002v\u0002\u0007Q\u000b\u0003\u0005\u0002n\u0006U\b\u0019AA\u0012\u0011%\ty0a8A\u0002\u0013\u0005q,A\u0004m_\u001e\u001c\u0016N_3\t\u0015\t\r\u0011q\u001ca\u0001\n\u0003\u0011)!A\u0006m_\u001e\u001c\u0016N_3`I\u0015\fH\u0003\u0002B\u0004\u0005\u001b\u00012!\nB\u0005\u0013\r\u0011YA\n\u0002\u0005+:LG\u000fC\u0005\u0002@\t\u0005\u0011\u0011!a\u0001A\"A!\u0011CApA\u0003&\u0001-\u0001\u0005m_\u001e\u001c\u0016N_3!\u0011)\u0011)\"a8A\u0002\u0013\u0005!qC\u0001\u0011GV\u0014(/\u001a8u?\u0006\u0004\b/\u001a8eKJ,\"A!\u0007\u0011\t\tm!QD\u0007\u0003\u0003?4qAa\b\u0002`\u0002\u0011\tCA\u0006M_\u001e\f\u0005\u000f]3oI\u0016\u00148#\u0002B\u000f\u0005G!\u0003\u0003\u0002B\u000e\u0005K1qAa\n\u0002`\u0002\u0013ICA\u0005M_\u001e\u0014V-\u00193feN9!Q\u0005B\u0016I=S\u0003\u0003\u0002B\u0017\u0005gi!Aa\f\u000b\t\tE\u0012\u0011X\u0001\rQ\u0006<H\u000fZ5ta\u0006$8\r[\u0005\u0005\u0005k\u0011yC\u0001\u0007CCN,'+\u001a;bS:,G\rC\u0005T\u0005K\u0011)\u001a!C\u0001)\"IAL!\n\u0003\u0012\u0003\u0006I!\u0016\u0005\n=\n\u0015\"Q3A\u0005\u0002}C\u0011\u0002\u001aB\u0013\u0005#\u0005\u000b\u0011\u00021\t\u000f9\u0012)\u0003\"\u0001\u0003BQ1!1\u0005B\"\u0005\u000bBaa\u0015B \u0001\u0004)\u0006B\u00020\u0003@\u0001\u0007\u0001\r\u0003\u0005\u0003J\t\u0015B\u0011\u0001B&\u0003\u0011y\u0007/\u001a8\u0016\u0005\t5\u0003c\u0001,\u0003P%\u0019!\u0011K,\u0003!I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:GS2,\u0007B\u0003B+\u0005K\u0011\r\u0011\"\u0001\u0003L\u0005\u0011a\r\u001a\u0005\n\u00053\u0012)\u0003)A\u0005\u0005\u001b\n1A\u001a3!\u0011)\u0011iF!\nC\u0002\u0013\u0005!qL\u0001\bG\"\fgN\\3m+\t\u0011\t\u0007\u0005\u0003\u0003d\t5TB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\u0011\rD\u0017M\u001c8fYNT1Aa\u001b\u001b\u0003\rq\u0017n\\\u0005\u0005\u0005_\u0012)GA\u0006GS2,7\t[1o]\u0016d\u0007\"\u0003B:\u0005K\u0001\u000b\u0011\u0002B1\u0003!\u0019\u0007.\u00198oK2\u0004\u0003\u0002\u0003B<\u0005K!\tE!\u001f\u0002\u000f\u0011L7\u000f]8tKR\u0011!q\u0001\u0005\t\u0005{\u0012)\u0003\"\u0001\u0003\u0000\u0005\u00012\r[3dW~\u0013X-\u00193`M2,8\u000f\u001b\u000b\u0005\u0005\u000f\u0011\t\tC\u0004\u0003\u0004\nm\u0004\u0019\u00011\u0002\u0015\u0015tGmX8gMN,G\u000f\u0003\u0005\u0003\b\n\u0015B\u0011\u0001BE\u0003\u0011\u0011X-\u00193\u0015\r\u0005E&1\u0012BH\u0011\u001d\u0011iI!\"A\u0002\u0001\fqB]3d_J$w\f]8tSRLwN\u001c\u0005\u0007M\n\u0015\u0005\u0019A \t\u0011\t\u001d%Q\u0005C\u0001\u0005'#BA!&\u0003\u0018B9Q%!(4\u0003c\u0003\u0007b\u0002BG\u0005#\u0003\r\u0001\u0019\u0005\t\u00057\u0013)\u0003\"\u0001\u0003\u001e\u0006)1\r[3dWR!!q\u0014BU!\u0015)\u0013q\u0013BQ!\u0019)#1\u00151\u0003(&\u0019!Q\u0015\u0014\u0003\rQ+\b\u000f\\33!\u0011)\u0013q\u00131\t\u000f\t5%\u0011\u0014a\u0001A\"9!Q\u0016B\u0013\t\u0003y\u0016a\u0006<fe&4\u00170\u00118e\u000f\u0016$XI\u001c3Q_NLG/[8o\u0011%\u0019(QEA\u0001\n\u0003\u0011\t\f\u0006\u0004\u0003$\tM&Q\u0017\u0005\t'\n=\u0006\u0013!a\u0001+\"AaLa,\u0011\u0002\u0003\u0007\u0001\r\u0003\u0005z\u0005K\t\n\u0011\"\u0001{\u0011)\tiA!\n\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\t\u00033\u0011)\u0003\"\u0011\u0002\u001c!A\u0011q\u0004B\u0013\t\u0003\n\t\u0003\u0003\u0005\u00024\t\u0015B\u0011\tBa)\u0011\t9Da1\t\u0015\u0005}\"qXA\u0001\u0002\u0004\t\t\u0005\u0003\u0005\u0002J\t\u0015B\u0011IA&\u0011\u001d\t\u0019F!\n\u0005ByB\u0001\"a\u0016\u0003&\u0011\u0005#1\u001a\u000b\u0005\u0003\u0003\u0012i\rC\u0005\u0002@\t%\u0017\u0011!a\u0001\u007f!A\u0011q\fB\u0013\t\u0003\u0012\t\u000e\u0006\u0003\u00028\tM\u0007BCA \u0005\u001f\f\t\u00111\u0001\u0002B!Y1K!\b\u0003\u0002\u0003\u0006I!\u0016B\u001c\u0011-q&Q\u0004B\u0001B\u0003%\u0001Ma\u000f\t\u000f9\u0012i\u0002\"\u0001\u0003\\R1!\u0011\u0004Bo\u0005?Daa\u0015Bm\u0001\u0004)\u0006B\u00020\u0003Z\u0002\u0007\u0001\r\u0003\u0006\u0003d\nu!\u0019!C\u0001\u0005K\fA!\u001b8g_V\u0011!q\u001d\t\u0004\u0005SdeB\u0001\n\u0001\u0011%\u0011iO!\b!\u0002\u0013\u00119/A\u0003j]\u001a|\u0007\u0005\u0003\u0005\u0003J\tuA\u0011\tB&\u0011!\u00119H!\b\u0005B\te\u0004\"\u0003B{\u0005;\u0001\r\u0011\"\u0001`\u00035\t\u0007\u000f]3oI~{gMZ:fi\"Q!\u0011 B\u000f\u0001\u0004%\tAa?\u0002#\u0005\u0004\b/\u001a8e?>4gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0003\b\tu\b\"CA \u0005o\f\t\u00111\u0001a\u0011!\u0019\tA!\b!B\u0013\u0001\u0017AD1qa\u0016tGmX8gMN,G\u000f\t\u0005\u000b\u0007\u000b\u0011iB1A\u0005\u0002\r\u001d\u0011A\u00044mkNDW\rZ0pM\u001a\u001cX\r^\u000b\u0003\u0007\u0013\u0001Baa\u0003\u0004\u00185\u00111Q\u0002\u0006\u0005\u0007\u001f\u0019\t\"\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0007'\u0019)\"\u0001\u0006d_:\u001cWO\u001d:f]RT!!\t\u000e\n\t\re1Q\u0002\u0002\u000b\u0003R|W.[2M_:<\u0007\"CB\u000f\u0005;\u0001\u000b\u0011BB\u0005\u0003=1G.^:iK\u0012|vN\u001a4tKR\u0004\u0003bBB\u0011\u0005;!\taX\u0001\u0010CB\u0004XM\u001c3`a>\u001c\u0018\u000e^5p]\"Q1Q\u0005B\u000f\u0005\u0004%\taa\n\u0002\u0019]\u0014\u0018\u000e^3`EV4g-\u001a:\u0016\u0005\r%\u0002\u0003BAZ\u0007WIAa!\f\u00026\nIB)\u0019;b\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0011%\u0019\tD!\b!\u0002\u0013\u0019I#A\u0007xe&$Xm\u00182vM\u001a,'\u000f\t\u0005\t\u0007k\u0011i\u0002\"\u0001\u00048\u0005)am\u001c:dKV\u0011!q\u0001\u0005\t\u0007w\u0011i\u0002\"\u0001\u0004>\u00051\u0011\r\u001d9f]\u0012$baa\u0010\u0004B\r\u0015\u0003CB\u0013\u0003$\u0002\u00149\u000fC\u0004\u0004D\re\u0002\u0019A\u001a\u0002\u0005%$\u0007\u0002CB$\u0007s\u0001\ra!\u0013\u0002\t\u0011\fG/\u0019\t\u0006K\r-\u0013\u0011W\u0005\u0004\u0007\u001b2#A\u0003\u001fsKB,\u0017\r^3e}!A1\u0011\u000bB\u000f\t\u0003\u00199$A\u0003gYV\u001c\b\u000e\u0003\u0005\u0003~\tuA\u0011IB+)\u0011\u00119aa\u0016\t\u000f\t\r51\u000ba\u0001A\"Q11LAp\u0001\u0004%\ta!\u0018\u0002)\r,(O]3oi~\u000b\u0007\u000f]3oI\u0016\u0014x\fJ3r)\u0011\u00119aa\u0018\t\u0015\u0005}2\u0011LA\u0001\u0002\u0004\u0011I\u0002C\u0005\u0004d\u0005}\u0007\u0015)\u0003\u0003\u001a\u0005\t2-\u001e:sK:$x,\u00199qK:$WM\u001d\u0011\t\u0015\r\u001d\u0014q\u001ca\u0001\n\u0003\t\u0019.\u0001\twKJLg-_0dQ\u0016\u001c7n];ng\"Q11NAp\u0001\u0004%\ta!\u001c\u0002)Y,'/\u001b4z?\u000eDWmY6tk6\u001cx\fJ3r)\u0011\u00119aa\u001c\t\u0015\u0005}2\u0011NA\u0001\u0002\u0004\t9\u0004C\u0005\u0004t\u0005}\u0007\u0015)\u0003\u00028\u0005\tb/\u001a:jMf|6\r[3dWN,Xn\u001d\u0011\t\u0015\r]\u0014q\u001ca\u0001\n\u0003\t\u0019.\u0001\u0003ts:\u001c\u0007BCB>\u0003?\u0004\r\u0011\"\u0001\u0004~\u0005A1/\u001f8d?\u0012*\u0017\u000f\u0006\u0003\u0003\b\r}\u0004BCA \u0007s\n\t\u00111\u0001\u00028!I11QApA\u0003&\u0011qG\u0001\u0006gft7\r\t\u0005\u000b\u0007\u000f\u000byN1A\u0005\u0002\r%\u0015!\u00037pO~KgNZ8t+\t\u0019Y\tE\u0004\u0004\u000e\u000e=\u0005Ma:\u000e\u0005\rU\u0011\u0002BBI\u0007+\u0011q\u0001\u0016:fK6\u000b\u0007\u000fC\u0005\u0004\u0016\u0006}\u0007\u0015!\u0003\u0004\f\u0006QAn\\4`S:4wn\u001d\u0011\b\u0011\re\u0015q\u001cE\u0003\u00077\u000b\u0011\u0002\\8h?6,H/\u001a=\u0011\t\tm1Q\u0014\u0004\t\u0007?\u000by\u000e#\u0002\u0004\"\nIAn\\4`[V$X\r_\n\u0005\u0007;3B\u0005C\u0004/\u0007;#\ta!*\u0015\u0005\rm\u0005\u0002CBU\u0003?$\taa+\u0002\r\u0011,G.\u001a;f)\u0011\u00119a!,\t\u000f\r\r3q\u0015a\u0001A\"A1\u0011WAp\t#\u0019\u0019,\u0001\u0005p]\u0012+G.\u001a;f)\u0011\t9d!.\t\rM\u001by\u000b1\u0001V\u0011!\u0019I,a8\u0005\u0002\rm\u0016\u0001C2iK\u000e\\7/^7\u0015\u0007}\u001ai\f\u0003\u0005\u0004H\r]\u0006\u0019AB%\u000f)\u0019\t-a8\u0002\u0002#\u001511Y\u0001\n\u0019><'+Z1eKJ\u0004BAa\u0007\u0004F\u001aQ!qEAp\u0003\u0003E)aa2\u0014\r\r\u00157\u0011\u001a\u0013+!!\t\tha3VA\n\r\u0012\u0002BBg\u0003g\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dq3Q\u0019C\u0001\u0007#$\"aa1\t\u0011\u0005}1Q\u0019C#\u0003\u0003C!\"!\"\u0004F\u0006\u0005I\u0011QBl)\u0019\u0011\u0019c!7\u0004\\\"11k!6A\u0002UCaAXBk\u0001\u0004\u0001\u0007BCAI\u0007\u000b\f\t\u0011\"!\u0004`R!1\u0011]Bs!\u0015)\u0013qSBr!\u0015)#1U+a\u0011!\t\u0019k!8A\u0002\t\r\u0002\u0002CBu\u0003?$\taa;\u0002'\r\u0014X-\u0019;f?2|wmX1qa\u0016tG-\u001a:\u0015\t\te1Q\u001e\u0005\u0007=\u000e\u001d\b\u0019\u00011\t\u0011\rE\u0018q\u001cC\u0001\u0007g\fqb\u0019:fCR,w,\u00199qK:$WM\u001d\u000b\u0005\u0003\u0003\u001a)\u0010\u0003\u0004_\u0007_\u0004\r\u0001\u0019\u0005\t\u0005\u0013\ny\u000e\"\u0001\u0004zV\u0011\u0011\u0011\t\u0005\t\u0007{\fy\u000e\"\u0001\u00048\u0005)1\r\\8tK\"9A\u0011AAp\t\u0003y\u0016AD1qa\u0016tG-\u001a:`Y&l\u0017\u000e\u001e\u0005\b\t\u000b\ty\u000e\"\u0001`\u00039\t\u0007\u000f]3oI\u0016\u0014xl\u001d;beRD\u0001\u0002\"\u0003\u0002`\u0012\u0005A1B\u0001\t]\u0016DHo\u00187pOR\u0019Q\u000b\"\u0004\t\ry#9\u00011\u0001a\u0011!!\t\"a8\u0005\u0002\u0011M\u0011\u0001C1qa\u0016tG-\u001a:\u0016\t\u0011UA1\u0004\u000b\u0005\t/!9\u0003\u0005\u0003\u0005\u001a\u0011mA\u0002\u0001\u0003\t\t;!yA1\u0001\u0005 \t\tA+\u0005\u0003\u0005\"\u0005\u0005\u0003cA\u0013\u0005$%\u0019AQ\u0005\u0014\u0003\u000f9{G\u000f[5oO\"AA\u0011\u0006C\b\u0001\u0004!Y#\u0001\u0003gk:\u001c\u0007cB\u0013\u0005.\teAqC\u0005\u0004\t_1#!\u0003$v]\u000e$\u0018n\u001c82\u0011)!\u0019$a8A\u0002\u0013\u0005AQG\u0001\u000e_:|Fn\\4`e>$\u0018\r^3\u0016\u0005\u0011]\u0002#B\u0013\u0005:\t\u001d\u0011b\u0001C\u001eM\tIa)\u001e8di&|g\u000e\r\u0005\u000b\t\u007f\ty\u000e1A\u0005\u0002\u0011\u0005\u0013!E8o?2|wm\u0018:pi\u0006$Xm\u0018\u0013fcR!!q\u0001C\"\u0011)\ty\u0004\"\u0010\u0002\u0002\u0003\u0007Aq\u0007\u0005\n\t\u000f\ny\u000e)Q\u0005\to\tab\u001c8`Y><wL]8uCR,\u0007\u0005\u0003\u0006\u0005L\u0005}'\u0019!C\u0005\t\u001b\nAB]3bI\u0016\u0014xlY1dQ\u0016,\"\u0001b\u0014\u0011\r}!\t&\u0016B\u0012\u0013\r!\u0019\u0006\t\u0002\t\u0019J+6)Y2iK\"IAqKApA\u0003%AqJ\u0001\u000ee\u0016\fG-\u001a:`G\u0006\u001c\u0007.\u001a\u0011\t\u0011\u0011m\u0013q\u001cC\u0001\t;\n\u0001\u0002\\8h?&tgm\u001c\u000b\u0005\t?\"\t\u0007E\u0003&\u0003/\u00139\u000fC\u0004\u0005d\u0011e\u0003\u0019\u00011\u0002\u0007A|7\u000f\u0003\u0005\u0005h\u0005}G\u0011\u0002C5\u0003)9W\r^0sK\u0006$WM]\u000b\u0005\tW\"\u0019\b\u0006\u0003\u0005n\u0011eD\u0003\u0002C8\tk\u0002R!JAL\tc\u0002B\u0001\"\u0007\u0005t\u0011AAQ\u0004C3\u0005\u0004!y\u0002\u0003\u0005\u0005*\u0011\u0015\u0004\u0019\u0001C<!\u001d)CQ\u0006B\u0012\tcBqA!$\u0005f\u0001\u0007\u0001\r\u0003\u0005\u0003\b\u0006}G\u0011\u0001C?)\u0011!y\b\"!\u0011\u000b\u0015\n9J!&\t\u000f\u0011\rD1\u0010a\u0001A\"A!qQAp\t\u0003!)\t\u0006\u0004\u0005\b\u0012%E1\u0012\t\u0006K\u0005]\u0015\u0011\u0017\u0005\b\tG\"\u0019\t1\u0001a\u0011\u00191G1\u0011a\u0001\u007f!I1/a8\u0002\u0002\u0013\u0005Aq\u0012\u000b\u0007\u0003;$\t\nb%\t\u0013\u0005\u0015HQ\u0012I\u0001\u0002\u0004)\u0006BCAw\t\u001b\u0003\n\u00111\u0001\u0002$!A\u00110a8\u0012\u0002\u0013\u0005!\u0010\u0003\u0006\u0002\u000e\u0005}\u0017\u0013!C\u0001\t3+\"\u0001b'+\u0007\u0005\rB\u0010\u0003\u0005\u0002\u001a\u0005}G\u0011IA\u000e\u0011!\ty\"a8\u0005B\u0005\u0005\u0002\u0002CA\u001a\u0003?$\t\u0005b)\u0015\t\u0005]BQ\u0015\u0005\u000b\u0003\u007f!\t+!AA\u0002\u0005\u0005\u0003\u0002CA%\u0003?$\t%a\u0013\t\u000f\u0005M\u0013q\u001cC!}!A\u0011qKAp\t\u0003\"i\u000b\u0006\u0003\u0002B\u0011=\u0006\"CA \tW\u000b\t\u00111\u0001@\u0011!\ty&a8\u0005B\u0011MF\u0003BA\u001c\tkC!\"a\u0010\u00052\u0006\u0005\t\u0019AA!\u0011\u001d\t)/!7A\u0002UC\u0001\"!<\u0002Z\u0002\u0007\u00111\u0005\u0005\n\u0003#\u001b\u0012\u0011!CA\t{#B\u0001b0\u0005DB)Q%a&\u0005BB1QEa)V\u0003GA\u0001\"a)\u0005<\u0002\u0007\u0011Q\u001c\u0005\b\u0003O\u001bB\u0011CAU\u0001")
public class RecordLog
implements ScalaObject,
Product,
Serializable {
    private final File directory;
    private final String logSuffix;
    private long logSize;
    private LogAppender current_appender;
    private boolean verify_checksums;
    private boolean sync;
    private final TreeMap<Object, LogInfo> log_infos;
    private Function0<BoxedUnit> on_log_rotate;
    private final LRUCache<File, LogReader> org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache;
    private volatile RecordLog$log_mutex$ log_mutex$module;
    private volatile RecordLog$LogReader$ LogReader$module;

    public static final void trace(Throwable throwable) {
        RecordLog$.MODULE$.trace(throwable);
    }

    public static final void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.trace(throwable, function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Throwable throwable) {
        RecordLog$.MODULE$.debug(throwable);
    }

    public static final void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.debug(throwable, function0, seq);
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.debug(function0, seq);
    }

    public static final void info(Throwable throwable) {
        RecordLog$.MODULE$.info(throwable);
    }

    public static final void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.info(throwable, function0, seq);
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.info(function0, seq);
    }

    public static final void warn(Throwable throwable) {
        RecordLog$.MODULE$.warn(throwable);
    }

    public static final void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.warn(throwable, function0, seq);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.warn(function0, seq);
    }

    public static final void error(Throwable throwable) {
        RecordLog$.MODULE$.error(throwable);
    }

    public static final void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.error(throwable, function0, seq);
    }

    public static final void error(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.error(function0, seq);
    }

    public static final void org$apache$activemq$apollo$util$Log$_setter_$log_$eq(Logger logger) {
        RecordLog$.MODULE$.org$apache$activemq$apollo$util$Log$_setter_$log_$eq(logger);
    }

    public static final Logger log() {
        return RecordLog$.MODULE$.log();
    }

    public static final boolean $enable_assertions() {
        return RecordLog$.MODULE$.$enable_assertions();
    }

    public static final long decode_long(Buffer buffer) {
        return RecordLog$.MODULE$.decode_long(buffer);
    }

    public static final Buffer encode_long(long l) {
        return RecordLog$.MODULE$.encode_long(l);
    }

    public static final int BYPASS_BUFFER_SIZE() {
        return RecordLog$.MODULE$.BYPASS_BUFFER_SIZE();
    }

    public static final int BUFFER_SIZE() {
        return RecordLog$.MODULE$.BUFFER_SIZE();
    }

    public static final int LOG_HEADER_SIZE() {
        return RecordLog$.MODULE$.LOG_HEADER_SIZE();
    }

    public static final byte UOW_END_RECORD() {
        return RecordLog$.MODULE$.UOW_END_RECORD();
    }

    public static final byte LOG_HEADER_PREFIX() {
        return RecordLog$.MODULE$.LOG_HEADER_PREFIX();
    }

    public Iterator<Object> productIterator() {
        return Product.class.productIterator((Product)this);
    }

    public Iterator<Object> productElements() {
        return Product.class.productElements((Product)this);
    }

    public File directory() {
        return this.directory;
    }

    public String logSuffix() {
        return this.logSuffix;
    }

    public long logSize() {
        return this.logSize;
    }

    public void logSize_$eq(long l) {
        this.logSize = l;
    }

    public LogAppender current_appender() {
        return this.current_appender;
    }

    public void current_appender_$eq(LogAppender logAppender) {
        this.current_appender = logAppender;
    }

    public boolean verify_checksums() {
        return this.verify_checksums;
    }

    public void verify_checksums_$eq(boolean bl) {
        this.verify_checksums = bl;
    }

    public boolean sync() {
        return this.sync;
    }

    public void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    public TreeMap<Object, LogInfo> log_infos() {
        return this.log_infos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final RecordLog$log_mutex$ log_mutex() {
        if (this.log_mutex$module != null) return this.log_mutex$module;
        RecordLog recordLog = this;
        synchronized (recordLog) {
            if (this.log_mutex$module == null) {
                this.log_mutex$module = new RecordLog$log_mutex$(this);
            }
            return this.log_mutex$module;
        }
    }

    public void delete(long id$1) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            BoxedUnit boxedUnit;
            if (this.current_appender().position() != id$1) {
                Option$.MODULE$.apply((Object)this.log_infos().get(BoxesRunTime.boxToLong((long)id$1))).foreach((Function1)new Serializable(this, id$1){
                    public static final long serialVersionUID;
                    private final RecordLog $outer;
                    private final long id$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final LogInfo apply(LogInfo info) {
                        this.$outer.onDelete(info.file());
                        return this.$outer.log_infos().remove(BoxesRunTime.boxToLong((long)this.id$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.id$1 = l;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean onDelete(File file) {
        return file.delete();
    }

    public int checksum(Seq<Buffer> data) {
        CRC32 checksum$1 = new CRC32();
        data.foreach((Function1)new Serializable(this, checksum$1){
            public static final long serialVersionUID;
            private final CRC32 checksum$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Buffer data) {
                this.checksum$1.update(data.data, data.offset, data.length);
            }
            {
                this.checksum$1 = cRC32;
            }
        });
        return (int)(checksum$1.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final RecordLog$LogReader$ LogReader() {
        if (this.LogReader$module != null) return this.LogReader$module;
        RecordLog recordLog = this;
        synchronized (recordLog) {
            if (this.LogReader$module == null) {
                this.LogReader$module = new RecordLog$LogReader$(this);
            }
            return this.LogReader$module;
        }
    }

    public LogAppender create_log_appender(long position) {
        return new LogAppender(this, this.next_log(position), position);
    }

    public Object create_appender(long position) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Object object = this.current_appender() == null ? BoxedUnit.UNIT : this.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(this.current_appender().file(), this.current_appender().position(), this.current_appender().append_offset()));
            this.current_appender_$eq(this.create_log_appender(position));
            LogInfo logInfo = this.log_infos().put(BoxesRunTime.boxToLong((long)position), this.current_appender().info());
            return logInfo;
        }
    }

    public Object open() {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            long l;
            this.log_infos().clear();
            LevelDBClient$.MODULE$.find_sequence_files(this.directory(), this.logSuffix()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final LogInfo apply(Tuple2<Object, File> tuple2) {
                    Tuple2<Object, File> tuple22 = tuple2;
                    if (tuple22 != null) {
                        long l = BoxesRunTime.unboxToLong((Object)tuple22._1());
                        File file = (File)tuple22._2();
                        long position = l;
                        File file2 = file;
                        return this.$outer.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(file2, position, file2.length()));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (this.log_infos().isEmpty()) {
                l = 0L;
            } else {
                LogInfo file$3 = this.log_infos().lastEntry().getValue();
                LogReader r$1 = new LogReader(this, file$3.file(), file$3.position());
                l = this.liftedTree1$1(file$3, r$1);
            }
            long appendPos = l;
            Object object = this.create_appender(appendPos);
            return object;
        }
    }

    public void close() {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            this.current_appender().release();
            return;
        }
    }

    public long appender_limit() {
        return this.current_appender().append_position();
    }

    public long appender_start() {
        return this.current_appender().position();
    }

    public File next_log(long position) {
        return LevelDBClient$.MODULE$.create_sequence_file(this.directory(), position, this.logSuffix());
    }

    public <T> T appender(Function1<LogAppender, T> func) {
        RecordLog$log_mutex$ recordLog$log_mutex$;
        long intial_position = this.current_appender().append_position();
        Object exceptionResult1 = null;
        try {
            Object rc = func.apply((Object)this.current_appender());
            Tuple2<Object, LogInfo> tuple2 = this.current_appender().append_position() != intial_position ? this.current_appender().append(RecordLog$.MODULE$.UOW_END_RECORD(), (Seq<Buffer>)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{RecordLog$.MODULE$.encode_long(intial_position)})) : BoxedUnit.UNIT;
            exceptionResult1 = rc;
            this.current_appender().flush();
            recordLog$log_mutex$ = this.log_mutex();
        }
        catch (Throwable throwable) {
            this.current_appender().flush();
            RecordLog$log_mutex$ recordLog$log_mutex$2 = this.log_mutex();
            synchronized (recordLog$log_mutex$2) {
                Object object;
                if (this.current_appender().append_offset() >= this.logSize()) {
                    this.current_appender().release();
                    this.on_log_rotate().apply$mcV$sp();
                    object = this.create_appender(this.current_appender().append_position());
                } else {
                    object = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
        synchronized (recordLog$log_mutex$) {
            Object object;
            if (this.current_appender().append_offset() >= this.logSize()) {
                this.current_appender().release();
                this.on_log_rotate().apply$mcV$sp();
                object = this.create_appender(this.current_appender().append_position());
            } else {
                object = BoxedUnit.UNIT;
            }
            return (T)exceptionResult1;
        }
    }

    public Function0<BoxedUnit> on_log_rotate() {
        return this.on_log_rotate;
    }

    public void on_log_rotate_$eq(Function0<BoxedUnit> function0) {
        this.on_log_rotate = function0;
    }

    public final LRUCache<File, LogReader> org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache() {
        return this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache;
    }

    public Option<LogInfo> log_info(long pos) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Option option = Option$.MODULE$.apply(this.log_infos().floorEntry(BoxesRunTime.boxToLong((long)pos))).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final LogInfo apply(Map.Entry<Object, LogInfo> entry) {
                    return entry.getValue();
                }
            });
            return option;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Option<T> get_reader(long record_position, Function1<LogReader, T> func$1) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Option<LogInfo> info = this.log_info(record_position);
            Option option = info.map((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<LogInfo, LogAppender> apply(LogInfo info) {
                    Tuple2 tuple2;
                    if (info.position() == this.$outer.current_appender().position()) {
                        this.$outer.current_appender().retain();
                        tuple2 = new Tuple2((Object)info, (Object)((Object)this.$outer.current_appender()));
                    } else {
                        tuple2 = new Tuple2((Object)info, null);
                    }
                    return tuple2;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : recordLog$log_mutex$
            Option lookup = option;
            return lookup.map((Function1)new Serializable(this, func$1){
                public static final long serialVersionUID;
                private final RecordLog $outer;
                private final Function1 func$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final T apply(Tuple2<LogInfo, LogAppender> tuple2) {
                    LogReader logReader;
                    Tuple2<LogInfo, LogAppender> tuple22 = tuple2;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    LogInfo logInfo = (LogInfo)tuple22._1();
                    LogAppender logAppender = (LogAppender)((Object)tuple22._2());
                    LogInfo info = logInfo;
                    LogAppender appender = logAppender;
                    if (appender == null) {
                        LRUCache<File, LogReader> lRUCache = this.$outer.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache();
                        synchronized (lRUCache) {
                            Object object;
                            LogReader reader2 = (LogReader)((Object)this.$outer.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache().get((Object)info.file()));
                            if (reader2 == null) {
                                reader2 = new LogReader(this.$outer, info.file(), info.position());
                                object = this.$outer.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache().put((Object)info.file(), (Object)((Object)reader2));
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            reader2.retain();
                            LogReader logReader2 = reader2;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 9] lbl19 : MonitorExitStatement: MONITOREXIT : lRUCache
                            logReader = logReader2;
                        }
                    } else {
                        logReader = appender;
                    }
                    LogAppender reader = logReader;
                    Object exceptionResult4 = null;
                    try {
                        exceptionResult4 = this.func$1.apply((Object)((Object)reader));
                        return (T)exceptionResult4;
                    }
                    finally {
                        reader.release();
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.func$1 = function1;
                }
            });
        }
    }

    public Option<Tuple3<Object, Buffer, Object>> read(long pos$2) {
        return this.get_reader(pos$2, (Function1)new Serializable(this, pos$2){
            public static final long serialVersionUID;
            private final long pos$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple3<Object, Buffer, Object> apply(LogReader logReader) {
                return logReader.read(this.pos$2);
            }
            {
                this.pos$2 = l;
            }
        });
    }

    public Option<Buffer> read(long pos$1, int length$2) {
        return this.get_reader(pos$1, (Function1)new Serializable(this, pos$1, length$2){
            public static final long serialVersionUID;
            private final long pos$1;
            private final int length$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer apply(LogReader logReader) {
                return logReader.read(this.pos$1, this.length$2);
            }
            {
                this.pos$1 = l;
                this.length$2 = n;
            }
        });
    }

    public RecordLog copy(File directory, String logSuffix) {
        return new RecordLog(directory, logSuffix);
    }

    public String copy$default$2() {
        return this.logSuffix();
    }

    public File copy$default$1() {
        return this.directory();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        String string;
        String logSuffix$1;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof RecordLog)) return false;
        RecordLog recordLog = (RecordLog)object2;
        File file = recordLog.directory();
        File directory$1 = file;
        if (!this.gd3$1(directory$1, logSuffix$1 = (string = recordLog.logSuffix()))) return false;
        boolean bl = ((RecordLog)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String productPrefix() {
        return "RecordLog";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            case 0: {
                object = this.directory();
                break;
            }
            case 1: {
                object = this.logSuffix();
            }
        }
        return object;
    }

    public boolean canEqual(Object object) {
        return object instanceof RecordLog;
    }

    private final long liftedTree1$1(LogInfo logInfo, LogReader logReader) {
        long exceptionResult2 = 0L;
        try {
            long actualLength = logReader.verifyAndGetEndPosition();
            long x$6 = actualLength - logInfo.position();
            File x$7 = logInfo.copy$default$1();
            long x$8 = logInfo.copy$default$2();
            LogInfo updated$1 = logInfo.copy(x$7, x$8, x$6);
            this.log_infos().put(BoxesRunTime.boxToLong((long)updated$1.position()), updated$1);
            Object object = updated$1.file().length() != logInfo.length() ? FileSupport$.MODULE$.using((Closeable)new RandomAccessFile(logInfo.file(), "rw"), (Function1)new Serializable(this, updated$1){
                public static final long serialVersionUID;
                private final LogInfo updated$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(RandomAccessFile randomAccessFile) {
                    randomAccessFile.setLength(this.updated$1.length());
                }
                {
                    this.updated$1 = logInfo;
                }
            }) : BoxedUnit.UNIT;
            exceptionResult2 = actualLength;
            return exceptionResult2;
        }
        finally {
            logReader.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gd3$1(File file, String string) {
        File file2 = file;
        File file3 = this.directory();
        if (file2 == null) {
            if (file3 != null) {
                return false;
            }
        } else if (!((Object)file2).equals(file3)) return false;
        String string2 = string;
        String string3 = this.logSuffix();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    public RecordLog(File directory, String logSuffix) {
        this.directory = directory;
        this.logSuffix = logSuffix;
        Product.class.$init$((Product)this);
        directory.mkdirs();
        this.logSize = 0x6400000L;
        this.verify_checksums = false;
        this.sync = false;
        this.log_infos = new TreeMap();
        this.on_log_rotate = new $anonfun$1(this);
        this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$$reader_cache = new $anon$1(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogInfo
    implements ScalaObject,
    Product,
    Serializable {
        private final File file;
        private final long position;
        private final long length;

        public Iterator<Object> productIterator() {
            return Product.class.productIterator((Product)this);
        }

        public Iterator<Object> productElements() {
            return Product.class.productElements((Product)this);
        }

        public File file() {
            return this.file;
        }

        public long position() {
            return this.position;
        }

        public long length() {
            return this.length;
        }

        public long limit() {
            return this.position() + this.length();
        }

        public long copy$default$3() {
            return this.length();
        }

        public long copy$default$2() {
            return this.position();
        }

        public File copy$default$1() {
            return this.file();
        }

        public LogInfo copy(File file, long position, long length) {
            return new LogInfo(file, position, length);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long l;
            long length$1;
            long l2;
            long position$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof LogInfo)) return false;
            LogInfo logInfo = (LogInfo)object2;
            File file = logInfo.file();
            File file$1 = file;
            if (!this.gd1$1(file$1, position$1 = (l2 = logInfo.position()), length$1 = (l = logInfo.length()))) return false;
            boolean bl = ((LogInfo)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "LogInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int n) {
            Comparable<File> comparable;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    comparable = this.file();
                    break;
                }
                case 2: {
                    comparable = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToLong((long)this.position());
                }
            }
            return comparable;
        }

        public boolean canEqual(Object object) {
            return object instanceof LogInfo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(File file, long l, long l2) {
            File file2 = file;
            File file3 = this.file();
            if (file2 == null) {
                if (file3 != null) {
                    return false;
                }
            } else if (!((Object)file2).equals(file3)) return false;
            if (l != this.position()) return false;
            if (l2 != this.length()) return false;
            return true;
        }

        public LogInfo(File file, long position, long length) {
            this.file = file;
            this.position = position;
            this.length = length;
            Product.class.$init$((Product)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogReader
    extends BaseRetained
    implements ScalaObject,
    Product,
    Serializable {
        private final File file;
        private final long position;
        private final RandomAccessFile fd;
        private final FileChannel channel;
        public final RecordLog $outer;

        public Iterator<Object> productIterator() {
            return Product.class.productIterator((Product)this);
        }

        public Iterator<Object> productElements() {
            return Product.class.productElements((Product)this);
        }

        public File file() {
            return this.file;
        }

        public long position() {
            return this.position;
        }

        public RandomAccessFile open() {
            return new RandomAccessFile(this.file(), "r");
        }

        public RandomAccessFile fd() {
            return this.fd;
        }

        public FileChannel channel() {
            return this.channel;
        }

        public void dispose() {
            this.fd().close();
        }

        public void check_read_flush(long end_offset) {
        }

        public Buffer read(long record_position, int length$3) {
            Buffer buffer;
            long offset$1 = record_position - this.position();
            if (RecordLog$.MODULE$.$enable_assertions()) {
                Predef$.MODULE$.assert(offset$1 >= 0L, (Function0)new Serializable(this, offset$1){
                    public static final long serialVersionUID;
                    private final long offset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("offset.$greater$eq(0) with offset=>%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1)}));
                    }
                    {
                        this.offset$1 = l;
                    }
                });
            }
            this.check_read_flush(offset$1 + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length$3);
            if (this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer().verify_checksums()) {
                Buffer record$1 = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE() + length$3);
                if (this.channel().read(record$1.toByteBuffer(), offset$1) != record$1.length) {
                    throw new IOException(new StringBuilder().append((Object)"short record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                DataByteArrayInputStream is = new DataByteArrayInputStream(record$1);
                byte prefix = is.readByte();
                if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1), (Function0)new Serializable(this, length$3, offset$1, record$1){
                            public static final long serialVersionUID;
                            private final LogReader $outer;
                            private final int length$3;
                            private final long offset$1;
                            private final Buffer record$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("record_is_not_changing with record_is_not_changing=>%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.$outer.record_is_not_changing$1(this.length$3, this.offset$1, this.record$1))}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.length$3 = n;
                                this.offset$1 = l;
                                this.record$1 = buffer;
                            }
                        });
                    }
                    throw new IOException(new StringBuilder().append((Object)"invalid record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                byte kind = is.readByte();
                int expectedChecksum = is.readInt();
                int expectedLength = is.readInt();
                Buffer data = is.readBuffer(length$3);
                if (expectedLength == length$3 && expectedChecksum != this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer().checksum((Seq<Buffer>)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{data}))) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1), (Function0)new Serializable(this, length$3, offset$1, record$1){
                            public static final long serialVersionUID;
                            private final LogReader $outer;
                            private final int length$3;
                            private final long offset$1;
                            private final Buffer record$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("record_is_not_changing with record_is_not_changing=>%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.$outer.record_is_not_changing$1(this.length$3, this.offset$1, this.record$1))}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.length$3 = n;
                                this.offset$1 = l;
                                this.record$1 = buffer;
                            }
                        });
                    }
                    throw new IOException(new StringBuilder().append((Object)"checksum does not match at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                buffer = data;
            } else {
                Buffer record = new Buffer(length$3);
                if (this.channel().read(record.toByteBuffer(), offset$1 + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE()) != record.length) {
                    throw new IOException(new StringBuilder().append((Object)"short record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                buffer = record;
            }
            return buffer;
        }

        public Tuple3<Object, Buffer, Object> read(long record_position) {
            long offset = record_position - this.position();
            Buffer header = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE());
            this.channel().read(header.toByteBuffer(), offset);
            BufferEditor is = header.bigEndianEditor();
            byte prefix = is.readByte();
            if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                throw new IOException("invalid record position");
            }
            byte id = is.readByte();
            int expectedChecksum = is.readInt();
            int length = is.readInt();
            Buffer data = new Buffer(length);
            if (this.channel().read(data.toByteBuffer(), offset + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE()) != length) {
                throw new IOException("short record");
            }
            if (this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer().verify_checksums() && expectedChecksum != this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer().checksum((Seq<Buffer>)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{data}))) {
                throw new IOException("checksum does not match");
            }
            return new Tuple3((Object)BoxesRunTime.boxToByte((byte)id), (Object)data, (Object)BoxesRunTime.boxToLong((long)(record_position + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length)));
        }

        public Option<Tuple2<Object, Option<Object>>> check(long record_position) {
            int chunkSize;
            long offset = record_position - this.position();
            Buffer header = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE());
            this.channel().read(header.toByteBuffer(), offset);
            BufferEditor is = header.bigEndianEditor();
            byte prefix = is.readByte();
            if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                return None$.MODULE$;
            }
            byte kind = is.readByte();
            int expectedChecksum = is.readInt();
            int length = is.readInt();
            Buffer chunk = new Buffer(4096);
            ByteBuffer chunkbb = chunk.toByteBuffer();
            offset += (long)RecordLog$.MODULE$.LOG_HEADER_SIZE();
            CRC32 checksumer = new CRC32();
            for (int remaining = length; remaining > 0; remaining -= chunkSize) {
                chunkSize = Predef$.MODULE$.intWrapper(remaining).min(4096);
                chunkbb.position(0);
                chunkbb.limit(chunkSize);
                this.channel().read(chunkbb, offset);
                if (chunkbb.hasRemaining()) {
                    return None$.MODULE$;
                }
                checksumer.update(chunk.data, 0, chunkSize);
                offset += (long)chunkSize;
            }
            int checksum2 = (int)(checksumer.getValue() & 0xFFFFFFFFFFFFFFFFL);
            if (expectedChecksum != checksum2) {
                return None$.MODULE$;
            }
            None$ uow_start_pos = kind == RecordLog$.MODULE$.UOW_END_RECORD() && length == 8 ? new Some((Object)BoxesRunTime.boxToLong((long)RecordLog$.MODULE$.decode_long(chunk))) : None$.MODULE$;
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)(record_position + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length)), (Object)uow_start_pos));
        }

        public long verifyAndGetEndPosition() {
            Object object = new Object();
            long exceptionResult3 = 0L;
            try {
                long pos = this.position();
                LongRef current_uow_start$1 = new LongRef(pos);
                long limit = this.position() + this.channel().size();
                while (pos < limit) {
                    Option<Tuple2<Object, Option<Object>>> option = this.check(pos);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Tuple2 tuple2 = (Tuple2)some.x();
                        if (tuple2 != null) {
                            long l;
                            long next$1 = l = BoxesRunTime.unboxToLong((Object)tuple2._1());
                            ((Option)tuple2._2()).foreach((Function1)new Serializable(this, current_uow_start$1, next$1, object){
                                public static final long serialVersionUID;
                                private final LongRef current_uow_start$1;
                                private final long next$1;
                                private final Object nonLocalReturnKey1$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(long uow_start_pos) {
                                    this.apply$mcVJ$sp(uow_start_pos);
                                }

                                public void apply$mcVJ$sp(long v1) {
                                    if (v1 == this.current_uow_start$1.elem) {
                                        this.current_uow_start$1.elem = this.next$1;
                                        return;
                                    }
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToLong((long)this.current_uow_start$1.elem));
                                }
                                {
                                    this.current_uow_start$1 = longRef;
                                    this.next$1 = l;
                                    this.nonLocalReturnKey1$1 = object;
                                }
                            });
                            pos = next$1;
                            continue;
                        }
                        throw new MatchError(option);
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Tuple2<Object, Option<Object>>> option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        return current_uow_start$1.elem;
                    }
                    throw new MatchError(option);
                }
                return current_uow_start$1.elem;
            }
            catch (NonLocalReturnControl nonLocalReturnControl) {
                if (nonLocalReturnControl.key() == object) {
                    exceptionResult3 = BoxesRunTime.unboxToLong((Object)nonLocalReturnControl.value());
                    return exceptionResult3;
                }
                throw nonLocalReturnControl;
            }
        }

        public LogReader copy(File file, long position) {
            return new LogReader(this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer(), file, position);
        }

        public long copy$default$2() {
            return this.position();
        }

        public File copy$default$1() {
            return this.file();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long l;
            long position$2;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof LogReader)) return false;
            if (((LogReader)((Object)object2)).org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer() != this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer()) return false;
            LogReader logReader = (LogReader)((Object)object2);
            File file = logReader.file();
            File file$2 = file;
            if (!this.gd2$1(file$2, position$2 = (l = logReader.position()))) return false;
            boolean bl = ((LogReader)((Object)object)).canEqual((Object)this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "LogReader";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            Comparable<File> comparable;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    comparable = this.file();
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToLong((long)this.position());
                }
            }
            return comparable;
        }

        public boolean canEqual(Object object) {
            return object instanceof LogReader;
        }

        public RecordLog org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogReader$$$outer() {
            return this.$outer;
        }

        public final boolean record_is_not_changing$1(int n, long l, Buffer buffer) {
            return BoxesRunTime.unboxToBoolean((Object)FileSupport$.MODULE$.using((Closeable)this.open(), (Function1)new Serializable(this, n, l, buffer){
                public static final long serialVersionUID;
                private final int length$3;
                private final long offset$1;
                private final Buffer record$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(RandomAccessFile fd) {
                    FileChannel channel = fd.getChannel();
                    Buffer new_record = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE() + this.length$3);
                    channel.read(new_record.toByteBuffer(), this.offset$1);
                    Buffer buffer = this.record$1;
                    Buffer buffer2 = new_record;
                    boolean same = !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
                    Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)same));
                    return same;
                }
                {
                    this.length$3 = n;
                    this.offset$1 = l;
                    this.record$1 = buffer;
                }
            }));
        }

        private final boolean gd2$1(File file, long l) {
            File file2 = file;
            File file3 = this.file();
            return !(file2 != null ? !((Object)file2).equals(file3) : file3 != null) && l == this.position();
        }

        public LogReader(RecordLog $outer, File file, long position) {
            this.file = file;
            this.position = position;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
            this.fd = this.open();
            this.channel = this.fd().getChannel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogAppender
    extends LogReader
    implements ScalaObject {
        private final LogInfo info = new LogInfo(super.file(), super.position(), 0L);
        private long append_offset = 0L;
        private final AtomicLong flushed_offset = new AtomicLong(0L);
        private final DataByteArrayOutputStream write_buffer;

        public LogInfo info() {
            return this.info;
        }

        @Override
        public RandomAccessFile open() {
            return new RandomAccessFile(super.file(), "rw");
        }

        @Override
        public void dispose() {
            this.force();
            super.dispose();
        }

        public long append_offset() {
            return this.append_offset;
        }

        public void append_offset_$eq(long l) {
            this.append_offset = l;
        }

        public AtomicLong flushed_offset() {
            return this.flushed_offset;
        }

        public long append_position() {
            return super.position() + this.append_offset();
        }

        public DataByteArrayOutputStream write_buffer() {
            return this.write_buffer;
        }

        public void force() {
            this.flush();
            if (this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogAppender$$$outer().sync()) {
                this.channel().force(this.append_offset() > this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogAppender$$$outer().logSize());
            }
        }

        public Tuple2<Object, LogInfo> append(byte id, Seq<Buffer> data) {
            LogAppender logAppender = this;
            synchronized (logAppender) {
                long record_position = this.append_position();
                IntRef data_length$1 = new IntRef(0);
                data.foreach((Function1)new Serializable(this, data_length$1){
                    public static final long serialVersionUID;
                    private final IntRef data_length$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Buffer buffer) {
                        this.data_length$1.elem += buffer.length;
                    }
                    {
                        this.data_length$1 = intRef;
                    }
                });
                int total_length = RecordLog$.MODULE$.LOG_HEADER_SIZE() + data_length$1.elem;
                if (this.write_buffer().position() + total_length > RecordLog$.MODULE$.BUFFER_SIZE()) {
                    this.flush();
                }
                int cs = this.org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogAppender$$$outer().checksum(data);
                this.write_buffer().writeByte((int)RecordLog$.MODULE$.LOG_HEADER_PREFIX());
                this.write_buffer().writeByte((int)id);
                this.write_buffer().writeInt(cs);
                this.write_buffer().writeInt(data_length$1.elem);
                data.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final LogAppender $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Buffer data) {
                        this.$outer.write_buffer().write(data.data, data.offset, data.length);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.append_offset_$eq(this.append_offset() + (long)total_length);
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)record_position), (Object)this.info());
                return tuple2;
            }
        }

        public void flush() {
            LogAppender logAppender = this;
            synchronized (logAppender) {
                BoxedUnit boxedUnit;
                if (this.write_buffer().position() > 0) {
                    ByteBuffer buffer = this.write_buffer().toBuffer().toByteBuffer();
                    int remaining = buffer.remaining();
                    long pos = this.append_offset() - (long)remaining;
                    this.channel().write(buffer, pos);
                    if (buffer.hasRemaining()) {
                        throw new IOException("Short write");
                    }
                    this.flushed_offset().addAndGet(remaining);
                    this.write_buffer().reset();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void check_read_flush(long end_offset) {
            if (this.flushed_offset().get() >= end_offset) return;
            LogAppender logAppender = this;
            synchronized (logAppender) {
                this.flush();
                return;
            }
        }

        public RecordLog org$apache$activemq$apollo$broker$store$leveldb$RecordLog$LogAppender$$$outer() {
            return this.$outer;
        }

        public LogAppender(RecordLog $outer, File file, long position) {
            super($outer, file, position);
            this.channel().position($outer.logSize() - 1L);
            this.channel().write(new Buffer(1).toByteBuffer());
            this.channel().force(true);
            Object object = $outer.sync() ? this.channel().position(0L) : BoxedUnit.UNIT;
            this.write_buffer = new DataByteArrayOutputStream(RecordLog$.MODULE$.BUFFER_SIZE() + RecordLog$.MODULE$.LOG_HEADER_SIZE());
        }
    }
}

