/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sdp;

import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.Parser;
import com.sun.media.sdp.TimeDescription;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class SessionDescription
extends Parser {
    public Vector timeDescriptions;
    public Vector sessionAttributes;
    public boolean connectionIncluded = false;
    public String version;
    public String origin;
    public String sessionName;
    public String sessionInfo;
    public String uri;
    public String email;
    public String phone;
    public String connectionInfo;
    public String bandwidthInfo;
    public String timezoneAdjustment;
    public String encryptionKey;

    public SessionDescription(ByteArrayInputStream bin) {
        this.version = this.getLine(bin);
        if (this.getToken(bin, "o=", true)) {
            this.origin = this.getLine(bin);
        }
        if (this.getToken(bin, "s=", true)) {
            this.sessionName = this.getLine(bin);
        }
        if (this.getToken(bin, "i=", false)) {
            this.sessionInfo = this.getLine(bin);
        }
        if (this.getToken(bin, "u=", false)) {
            this.uri = this.getLine(bin);
        }
        if (this.getToken(bin, "e=", false)) {
            this.email = this.getLine(bin);
        }
        if (this.getToken(bin, "e=", false)) {
            this.email = this.getLine(bin);
        }
        if (this.getToken(bin, "p=", false)) {
            this.phone = this.getLine(bin);
        }
        if (this.getToken(bin, "c=", false)) {
            this.connectionIncluded = true;
            this.connectionInfo = this.getLine(bin);
        }
        if (this.getToken(bin, "b=", false)) {
            this.bandwidthInfo = this.getLine(bin);
            System.out.println("bandwidth info: " + this.bandwidthInfo);
        }
        this.timeDescriptions = new Vector();
        boolean found = this.getToken(bin, "t=", true);
        while (found) {
            TimeDescription timeDescription = new TimeDescription(bin);
            this.timeDescriptions.addElement(timeDescription);
            found = this.getToken(bin, "t=", false);
        }
        if (this.getToken(bin, "z=", false)) {
            this.timezoneAdjustment = this.getLine(bin);
        }
        if (this.getToken(bin, "k=", false)) {
            this.encryptionKey = this.getLine(bin);
        }
        this.sessionAttributes = new Vector();
        found = this.getToken(bin, "a=", false);
        while (found) {
            String sessionAttribute = this.getLine(bin);
            int index = sessionAttribute.indexOf(58);
            if (index > 0) {
                String name = sessionAttribute.substring(0, index);
                String value = sessionAttribute.substring(index + 1);
                MediaAttribute attribute = new MediaAttribute(name, value);
                this.sessionAttributes.addElement(attribute);
            }
            found = this.getToken(bin, "a=", false);
        }
    }

    public MediaAttribute getSessionAttribute(String name) {
        MediaAttribute attribute = null;
        if (this.sessionAttributes != null) {
            int i2 = 0;
            while (i2 < this.sessionAttributes.size()) {
                MediaAttribute entry = (MediaAttribute)this.sessionAttributes.elementAt(i2);
                if (entry.getName().equals(name)) {
                    attribute = entry;
                    break;
                }
                ++i2;
            }
        }
        return attribute;
    }
}

