/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.core.java.util.logging;

import com.google.gwt.core.shared.SerializableThrowable;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogRecord_CustomFieldSerializer {
    public static void deserialize(SerializationStreamReader reader, LogRecord instance) throws SerializationException {
        String loggerName = reader.readString();
        Long millis = reader.readLong();
        SerializableThrowable thrown = (SerializableThrowable)reader.readObject();
        instance.setLoggerName(loggerName);
        instance.setMillis(millis);
        instance.setThrown(thrown);
    }

    public static LogRecord instantiate(SerializationStreamReader reader) throws SerializationException {
        String levelString = reader.readString();
        String msg = reader.readString();
        Level level = Level.parse(levelString);
        LogRecord toReturn = new LogRecord(level, msg);
        return toReturn;
    }

    public static void serialize(SerializationStreamWriter writer, LogRecord lr) throws SerializationException {
        writer.writeString(lr.getLevel().getName());
        writer.writeString(lr.getMessage());
        writer.writeString(lr.getLoggerName());
        writer.writeLong(lr.getMillis());
        writer.writeObject(SerializableThrowable.fromThrowable(lr.getThrown()));
    }
}

