#ifndef ISDIO_H
#define ISDIO_H

#define ISDHOSTNAME "isectd"
#define ISDSERVICE "op"

#include <sys/time.h>
#include <sys/types.h>
#include <sys/param.h>
#include <stdarg.h>
#include <stdio.h>

#ifdef _Windows
#include <winsock.h>
#include <process.h>
#include <io.h>
#ifndef _WIN32
#define getpid() 0
#endif
#define Xport _export far pascal
#else
#define SOCKET int
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#define O_BINARY 0
#include <sys/socket.h>
#include <netinet/in.h>

/*
most systems have netinet/tcp.h, but MVS
systems have xti.h instead, which defines
things like TCP_NODELAY
*/

#ifdef HAVE_NETINET_TCP_H
#include <netinet/tcp.h>
#endif

#ifdef HAVE_XTI_H
#include <xti.h>
#endif

#include <netdb.h>
#define Xport
#endif

#ifndef _H_INTTYPES
#ifndef __BIT_TYPES_DEFINED__
#define __BIT_TYPES_DEFINED__
typedef short			int16_t;
typedef unsigned short  u_int16_t;
typedef int				int32_t;
typedef unsigned int    u_int32_t;
#endif
#endif

#ifndef MAXSERVICENAMELEN       /* until I can find one in an include file, I'll define my own */
#define MAXSERVICENAMELEN 32
#endif

/*
The arguments to isdAttach() are in a specific order on the
worker's command line.
*/
#define ISDARGHOST		1			/* the hostname I'm calling back to */
#define ISDARGSERVICE	2			/* the service I'm a worker for */
#define ISDARGWID		3			/* my worker id, how isectd identifies me */
#define ISDARGMAX		4			/* worker's argc should be >= ISDARGMAX */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Errors retured in header.error
 */
#define ISDERROK 0
#define ISDERRWORKERDEATH 1

/*
This is the what we use for time values
*/
#define ISDTIMETYPE struct timeval

typedef struct {		/* offsets */
	int32_t	len;		/*  0 */
	int32_t	sequence;	/*  4 */
	int16_t	reply;		/*  8 */
	int16_t	error;		/* 10 */
	int16_t	command;	/* 12 */
	int16_t	version;	/* 14 */
	u_int32_t workerid; /* 16 */
	int16_t	more;		/* 20 */
	int16_t	unused[17];
	double aligner;
} isdHeader;

typedef struct {
        int32_t id; 		/* required of workers */
        int32_t hostpid;    /* required of both workers and clients */
        int32_t priority;   /* required of clients */
        int32_t blockable;  /* tells isectd whether this process can be blocked */
		char service[MAXSERVICENAMELEN];
} isdBadge;


#define ISDXSERVICE "isdexec"

extern char	* Xport isdxstrerror(int);
extern int	  Xport isdexec(char *host, char *command);

extern void Xport isdLogInit(int argc, char **argv);
extern void Xport isdLog(char *fmt, ...);
extern void Xport isdError(char *fmt, ...);

extern SOCKET Xport isdAttach(const char *hostname, const char *service, char *wid, int priority);
extern SOCKET Xport isdConnectTo(const char *hostname, const char *service);
extern SOCKET Xport isdLogin(const char *hostname, const char *service, int priority);
extern void Xport isdLogout(SOCKET sock);
extern char * Xport isdRecv(SOCKET socket, isdHeader *header);
extern int Xport isdSend(SOCKET socket, char *message, int len, isdHeader *header);
extern SOCKET Xport isdConnect(char **argv);
extern SOCKET Xport isdSocket(char *name, char *protocol, SOCKET *sock, int *port);
extern void Xport isdSockOpts(SOCKET sock);

#ifdef __cplusplus
}
#endif

#endif
