/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BlockingHttpConnection
extends AbstractHttpConnection {
    private static final Logger LOG = Log.getLogger(BlockingHttpConnection.class);

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        super(connector, endpoint, server, parser, generator, request);
    }

    protected void handleRequest() throws IOException {
        super.handleRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        BlockingHttpConnection blockingHttpConnection;
        BlockingHttpConnection connection = this;
        try {
            BlockingHttpConnection.setCurrentConnection(this);
            while (this._endp.isOpen() && connection == this) {
                Connection switched;
                Object var4_4;
                try {
                    try {
                        if (!this._parser.isComplete() && !this._endp.isInputShutdown()) {
                            this._parser.parseAvailable();
                        }
                        if (this._generator.isCommitted() && !this._generator.isComplete() && !this._endp.isOutputShutdown()) {
                            this._generator.flushBuffer();
                        }
                        this._endp.flush();
                    }
                    catch (HttpException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("uri=" + this._uri, new Object[0]);
                            LOG.debug("fields=" + this._requestFields, new Object[0]);
                            LOG.debug((Throwable)e);
                        }
                        this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                        this._parser.reset();
                        this._endp.shutdownOutput();
                        var4_4 = null;
                        if (this._parser.isComplete() && this._generator.isComplete()) {
                            this.reset();
                            if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                connection = switched;
                            }
                            if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                                LOG.warn("Safety net oshut!!! Please open a bugzilla", new Object[0]);
                                this._endp.shutdownOutput();
                            }
                        }
                        if (!this._endp.isInputShutdown() || !this._generator.isIdle() || this._request.getAsyncContinuation().isSuspended()) continue;
                        this._endp.close();
                        continue;
                    }
                    var4_4 = null;
                }
                catch (Throwable throwable) {
                    var4_4 = null;
                    if (this._parser.isComplete() && this._generator.isComplete()) {
                        this.reset();
                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                            connection = switched;
                        }
                        if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                            LOG.warn("Safety net oshut!!! Please open a bugzilla", new Object[0]);
                            this._endp.shutdownOutput();
                        }
                    }
                    if (!this._endp.isInputShutdown()) throw throwable;
                    if (!this._generator.isIdle()) throw throwable;
                    if (this._request.getAsyncContinuation().isSuspended()) throw throwable;
                    this._endp.close();
                    throw throwable;
                }
                if (this._parser.isComplete() && this._generator.isComplete()) {
                    this.reset();
                    if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                        connection = switched;
                    }
                    if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                        LOG.warn("Safety net oshut!!! Please open a bugzilla", new Object[0]);
                        this._endp.shutdownOutput();
                    }
                }
                if (!this._endp.isInputShutdown() || !this._generator.isIdle() || this._request.getAsyncContinuation().isSuspended()) continue;
                this._endp.close();
            }
            blockingHttpConnection = connection;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            BlockingHttpConnection.setCurrentConnection(null);
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            throw throwable;
        }
        BlockingHttpConnection.setCurrentConnection(null);
        this._parser.returnBuffers();
        this._generator.returnBuffers();
        return blockingHttpConnection;
    }
}

