/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.plus.jaas.callback.ObjectCallback;
import org.eclipse.jetty.plus.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.plus.jaas.spi.UserInfo;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapLoginModule
extends AbstractLoginModule {
    private static final Logger LOG = Log.getLogger(LdapLoginModule.class);
    private String _hostname;
    private int _port;
    private String _authenticationMethod;
    private String _contextFactory;
    private String _bindDn;
    private String _bindPassword;
    private String _userObjectClass = "inetOrgPerson";
    private String _userRdnAttribute = "uid";
    private String _userIdAttribute = "cn";
    private String _userPasswordAttribute = "userPassword";
    private String _userBaseDn;
    private String _roleBaseDn;
    private String _roleObjectClass = "groupOfUniqueNames";
    private String _roleMemberAttribute = "uniqueMember";
    private String _roleNameAttribute = "roleName";
    private boolean _debug;
    private boolean _forceBindingLogin = false;
    private boolean _useLdaps = false;
    private DirContext _rootContext;

    @Override
    public UserInfo getUserInfo(String username) throws Exception {
        String pwdCredential = this.getUserCredentials(username);
        if (pwdCredential == null) {
            return null;
        }
        pwdCredential = LdapLoginModule.convertCredentialLdapToJetty(pwdCredential);
        Credential credential = Credential.getCredential((String)pwdCredential);
        List<String> roles = this.getUserRoles(this._rootContext, username);
        return new UserInfo(username, credential, roles);
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private String getUserCredentials(String username) throws LoginException {
        String ldapCredential = null;
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass={0})({1}={2}))";
        LOG.debug("Searching for users with filter: '" + filter + "'" + " from base dn: " + this._userBaseDn, new Object[0]);
        try {
            Object[] filterArguments = new Object[]{this._userObjectClass, this._userIdAttribute, username};
            NamingEnumeration<SearchResult> results = this._rootContext.search(this._userBaseDn, filter, filterArguments, ctls);
            LOG.debug("Found user?: " + results.hasMoreElements(), new Object[0]);
            if (!results.hasMoreElements()) {
                throw new LoginException("User not found.");
            }
            SearchResult result = this.findUser(username);
            Attributes attributes = result.getAttributes();
            Attribute attribute = attributes.get(this._userPasswordAttribute);
            if (attribute != null) {
                try {
                    byte[] value = (byte[])attribute.get();
                    ldapCredential = new String(value);
                }
                catch (NamingException e) {
                    LOG.debug("no password available under attribute: " + this._userPasswordAttribute, new Object[0]);
                }
            }
        }
        catch (NamingException e) {
            throw new LoginException("Root context binding failure.");
        }
        LOG.debug("user cred is: " + ldapCredential, new Object[0]);
        return ldapCredential;
    }

    private List<String> getUserRoles(DirContext dirContext, String username) throws LoginException, NamingException {
        String userDn = this._userRdnAttribute + "=" + username + "," + this._userBaseDn;
        return this.getUserRolesByDn(dirContext, userDn);
    }

    private List<String> getUserRolesByDn(DirContext dirContext, String userDn) throws LoginException, NamingException {
        ArrayList<String> roleList = new ArrayList<String>();
        if (dirContext == null || this._roleBaseDn == null || this._roleMemberAttribute == null || this._roleObjectClass == null) {
            return roleList;
        }
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{this._roleNameAttribute});
        String filter = "(&(objectClass={0})({1}={2}))";
        Object[] filterArguments = new Object[]{this._roleObjectClass, this._roleMemberAttribute, userDn};
        NamingEnumeration<SearchResult> results = dirContext.search(this._roleBaseDn, filter, filterArguments, ctls);
        LOG.debug("Found user roles?: " + results.hasMoreElements(), new Object[0]);
        while (results.hasMoreElements()) {
            Attribute roleAttribute;
            SearchResult result = (SearchResult)results.nextElement();
            Attributes attributes = result.getAttributes();
            if (attributes == null || (roleAttribute = attributes.get(this._roleNameAttribute)) == null) continue;
            NamingEnumeration<?> roles = roleAttribute.getAll();
            while (roles.hasMore()) {
                roleList.add(roles.next().toString());
            }
        }
        return roleList;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            if (this.getCallbackHandler() == null) {
                throw new LoginException("No callback handler");
            }
            Callback[] callbacks = this.configureCallbacks();
            this.getCallbackHandler().handle(callbacks);
            String webUserName = ((NameCallback)callbacks[0]).getName();
            Object webCredential = ((ObjectCallback)callbacks[1]).getObject();
            if (webUserName == null || webCredential == null) {
                this.setAuthenticated(false);
                return this.isAuthenticated();
            }
            if (this._forceBindingLogin) {
                return this.bindingLogin(webUserName, webCredential);
            }
            UserInfo userInfo = this.getUserInfo(webUserName);
            if (userInfo == null) {
                this.setAuthenticated(false);
                return false;
            }
            this.setCurrentUser(new AbstractLoginModule.JAASUserInfo(this, userInfo));
            if (webCredential instanceof String) {
                return this.credentialLogin(Credential.getCredential((String)((String)webCredential)));
            }
            return this.credentialLogin(webCredential);
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Error obtaining callback information.");
        }
        catch (IOException e) {
            if (this._debug) {
                e.printStackTrace();
            }
            throw new LoginException("IO Error performing login.");
        }
        catch (Exception e) {
            if (this._debug) {
                e.printStackTrace();
            }
            throw new LoginException("Error obtaining user info.");
        }
    }

    protected boolean credentialLogin(Object webCredential) throws LoginException {
        this.setAuthenticated(this.getCurrentUser().checkCredential(webCredential));
        return this.isAuthenticated();
    }

    public boolean bindingLogin(String username, Object password) throws LoginException, NamingException {
        SearchResult searchResult = this.findUser(username);
        String userDn = searchResult.getNameInNamespace();
        LOG.info("Attempting authentication: " + userDn, new Object[0]);
        Hashtable<Object, Object> environment = this.getEnvironment();
        environment.put("java.naming.security.principal", userDn);
        environment.put("java.naming.security.credentials", password);
        InitialDirContext dirContext = new InitialDirContext(environment);
        List<String> roles = this.getUserRolesByDn(dirContext, userDn);
        UserInfo userInfo = new UserInfo(username, null, roles);
        this.setCurrentUser(new AbstractLoginModule.JAASUserInfo(this, userInfo));
        this.setAuthenticated(true);
        return true;
    }

    private SearchResult findUser(String username) throws NamingException, LoginException {
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass={0})({1}={2}))";
        LOG.info("Searching for users with filter: '" + filter + "'" + " from base dn: " + this._userBaseDn, new Object[0]);
        Object[] filterArguments = new Object[]{this._userObjectClass, this._userIdAttribute, username};
        NamingEnumeration<SearchResult> results = this._rootContext.search(this._userBaseDn, filter, filterArguments, ctls);
        LOG.info("Found user?: " + results.hasMoreElements(), new Object[0]);
        if (!results.hasMoreElements()) {
            throw new LoginException("User not found.");
        }
        return (SearchResult)results.nextElement();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this._hostname = (String)options.get("hostname");
        this._port = Integer.parseInt((String)options.get("port"));
        this._contextFactory = (String)options.get("contextFactory");
        this._bindDn = (String)options.get("bindDn");
        this._bindPassword = (String)options.get("bindPassword");
        this._authenticationMethod = (String)options.get("authenticationMethod");
        this._userBaseDn = (String)options.get("userBaseDn");
        this._roleBaseDn = (String)options.get("roleBaseDn");
        if (options.containsKey("forceBindingLogin")) {
            this._forceBindingLogin = Boolean.parseBoolean((String)options.get("forceBindingLogin"));
        }
        if (options.containsKey("useLdaps")) {
            this._useLdaps = Boolean.parseBoolean((String)options.get("useLdaps"));
        }
        this._userObjectClass = this.getOption(options, "userObjectClass", this._userObjectClass);
        this._userRdnAttribute = this.getOption(options, "userRdnAttribute", this._userRdnAttribute);
        this._userIdAttribute = this.getOption(options, "userIdAttribute", this._userIdAttribute);
        this._userPasswordAttribute = this.getOption(options, "userPasswordAttribute", this._userPasswordAttribute);
        this._roleObjectClass = this.getOption(options, "roleObjectClass", this._roleObjectClass);
        this._roleMemberAttribute = this.getOption(options, "roleMemberAttribute", this._roleMemberAttribute);
        this._roleNameAttribute = this.getOption(options, "roleNameAttribute", this._roleNameAttribute);
        this._debug = Boolean.parseBoolean(String.valueOf(this.getOption(options, "debug", Boolean.toString(this._debug))));
        try {
            this._rootContext = new InitialDirContext(this.getEnvironment());
        }
        catch (NamingException ex) {
            throw new IllegalStateException("Unable to establish root context", ex);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            this._rootContext.close();
        }
        catch (NamingException e) {
            throw new LoginException("error closing root context: " + e.getMessage());
        }
        return super.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        try {
            this._rootContext.close();
        }
        catch (NamingException e) {
            throw new LoginException("error closing root context: " + e.getMessage());
        }
        return super.abort();
    }

    private String getOption(Map<String, ?> options, String key, String defaultValue) {
        Object value = options.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public Hashtable<Object, Object> getEnvironment() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", this._contextFactory);
        if (this._hostname != null) {
            env.put("java.naming.provider.url", (this._useLdaps ? "ldaps://" : "ldap://") + this._hostname + (this._port == 0 ? "" : ":" + this._port) + "/");
        }
        if (this._authenticationMethod != null) {
            env.put("java.naming.security.authentication", this._authenticationMethod);
        }
        if (this._bindDn != null) {
            env.put("java.naming.security.principal", this._bindDn);
        }
        if (this._bindPassword != null) {
            env.put("java.naming.security.credentials", this._bindPassword);
        }
        return env;
    }

    public static String convertCredentialJettyToLdap(String encryptedPassword) {
        if ("MD5:".startsWith(encryptedPassword.toUpperCase(Locale.ENGLISH))) {
            return "{MD5}" + encryptedPassword.substring("MD5:".length(), encryptedPassword.length());
        }
        if ("CRYPT:".startsWith(encryptedPassword.toUpperCase(Locale.ENGLISH))) {
            return "{CRYPT}" + encryptedPassword.substring("CRYPT:".length(), encryptedPassword.length());
        }
        return encryptedPassword;
    }

    public static String convertCredentialLdapToJetty(String encryptedPassword) {
        if (encryptedPassword == null) {
            return encryptedPassword;
        }
        if ("{MD5}".startsWith(encryptedPassword.toUpperCase(Locale.ENGLISH))) {
            return "MD5:" + encryptedPassword.substring("{MD5}".length(), encryptedPassword.length());
        }
        if ("{CRYPT}".startsWith(encryptedPassword.toUpperCase(Locale.ENGLISH))) {
            return "CRYPT:" + encryptedPassword.substring("{CRYPT}".length(), encryptedPassword.length());
        }
        return encryptedPassword;
    }
}

